/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.NameResolver;
import io.netty.resolver.SimpleNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.List;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    /*
     * WARNING - void declaration
     */
    public CompositeNameResolver(EventExecutor executor, NameResolver<T> ... resolvers) {
        super(executor);
        void var2_3;
        ObjectUtil.checkNotNull(resolvers, (String)"resolvers");
        for (int i = 0; i < resolvers.length; ++i) {
            ObjectUtil.checkNotNull(resolvers[i], (String)("resolvers[" + i + ']'));
        }
        if (resolvers.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(resolvers) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])var2_3.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doResolve(String inetHost, Promise<T> promise) throws Exception {
        void var2_2;
        void var1_1;
        this.doResolveRec((String)var1_1, (Promise<T>)var2_2, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    private void doResolveRec(String inetHost, Promise<T> promise, int resolverIndex, Throwable lastFailure) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        if (resolverIndex >= this.resolvers.length) {
            promise.setFailure(lastFailure);
            return;
        }
        NameResolver<T> nameResolver = this.resolvers[resolverIndex];
        nameResolver.resolve(inetHost).addListener((GenericFutureListener)new FutureListener<T>(this, (Promise)var2_2, (String)var1_1, (int)var3_3){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ String val$inetHost;
            final /* synthetic */ int val$resolverIndex;
            final /* synthetic */ CompositeNameResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
                this.val$inetHost = string;
                this.val$resolverIndex = n;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(Future<T> future) throws Exception {
                void var1_1;
                if (future.isSuccess()) {
                    this.val$promise.setSuccess(future.getNow());
                    return;
                }
                CompositeNameResolver.access$000(this.this$0, this.val$inetHost, this.val$promise, this.val$resolverIndex + 1, var1_1.cause());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doResolveAll(String inetHost, Promise<List<T>> promise) throws Exception {
        void var2_2;
        void var1_1;
        this.doResolveAllRec((String)var1_1, (Promise<List<T>>)var2_2, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    private void doResolveAllRec(String inetHost, Promise<List<T>> promise, int resolverIndex, Throwable lastFailure) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        if (resolverIndex >= this.resolvers.length) {
            promise.setFailure(lastFailure);
            return;
        }
        NameResolver<T> nameResolver = this.resolvers[resolverIndex];
        nameResolver.resolveAll(inetHost).addListener((GenericFutureListener)new FutureListener<List<T>>(this, (Promise)var2_2, (String)var1_1, (int)var3_3){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ String val$inetHost;
            final /* synthetic */ int val$resolverIndex;
            final /* synthetic */ CompositeNameResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
                this.val$inetHost = string;
                this.val$resolverIndex = n;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(Future<List<T>> future) throws Exception {
                void var1_1;
                if (future.isSuccess()) {
                    this.val$promise.setSuccess(future.getNow());
                    return;
                }
                CompositeNameResolver.access$100(this.this$0, this.val$inetHost, this.val$promise, this.val$resolverIndex + 1, var1_1.cause());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(CompositeNameResolver x0, String x1, Promise x2, int x3, Throwable x4) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.doResolveRec((String)var1_1, (Promise)var2_2, (int)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(CompositeNameResolver x0, String x1, Promise x2, int x3, Throwable x4) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.doResolveAllRec((String)var1_1, (Promise)var2_2, (int)var3_3, x4);
    }
}

