/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();
    private final Map<EventExecutor, GenericFutureListener<Future<Object>>> executorTerminationListeners = new IdentityHashMap<EventExecutor, GenericFutureListener<Future<Object>>>();

    protected AddressResolverGroup() {
    }

    /*
     * WARNING - void declaration
     */
    public AddressResolver<T> getResolver(EventExecutor executor) {
        void var2_4;
        ObjectUtil.checkNotNull((Object)executor, (String)"executor");
        if (executor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
        synchronized (map) {
            AddressResolver<T> r = this.resolvers.get(executor);
            if (r == null) {
                void var1_1;
                AddressResolver<T> newResolver;
                try {
                    newResolver = this.newResolver(executor);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to create a new resolver", e);
                }
                this.resolvers.put(executor, newResolver);
                FutureListener<Object> terminationListener = new FutureListener<Object>(this, executor, newResolver){
                    final /* synthetic */ EventExecutor val$executor;
                    final /* synthetic */ AddressResolver val$newResolver;
                    final /* synthetic */ AddressResolverGroup this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$executor = eventExecutor;
                        this.val$newResolver = addressResolver;
                    }

                    public void operationComplete(Future<Object> future) {
                        Map map = this.this$0.resolvers;
                        synchronized (map) {
                            this.this$0.resolvers.remove(this.val$executor);
                            this.this$0.executorTerminationListeners.remove(this.val$executor);
                        }
                        this.val$newResolver.close();
                    }
                };
                this.executorTerminationListeners.put(executor, (GenericFutureListener<Future<Object>>)terminationListener);
                var1_1.terminationFuture().addListener((GenericFutureListener)terminationListener);
            }
        }
        return var2_4;
    }

    protected abstract AddressResolver<T> newResolver(EventExecutor var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        AddressResolver[] addressResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            void var2_4;
            AddressResolver[] rArray = this.resolvers.values().toArray(new AddressResolver[0]);
            this.resolvers.clear();
            Map.Entry[] listeners = this.executorTerminationListeners.entrySet().toArray(new Map.Entry[0]);
            this.executorTerminationListeners.clear();
            // ** MonitorExit[var3_1] (shouldn't be in output)
            for (Map<EventExecutor, AddressResolver<T>> entry : var2_4) {
                ((EventExecutor)entry.getKey()).terminationFuture().removeListener((GenericFutureListener)entry.getValue());
            }
            addressResolverArray = rArray;
            int n = rArray.length;
            for (int i = 0; i < n; ++i) {
                AddressResolver r = addressResolverArray[i];
                try {
                    r.close();
                    continue;
                }
                catch (Throwable t) {
                    void var1_3;
                    logger.warn("Failed to close a resolver:", (Throwable)var1_3);
                }
            }
            return;
        }
    }
}

