/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAddressResolver<T extends SocketAddress>
implements AddressResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    /*
     * WARNING - void declaration
     */
    protected AbstractAddressResolver(EventExecutor executor) {
        void var1_1;
        this.executor = (EventExecutor)ObjectUtil.checkNotNull((Object)var1_1, (String)"executor");
        this.matcher = TypeParameterMatcher.find((Object)this, AbstractAddressResolver.class, (String)"T");
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractAddressResolver(EventExecutor executor, Class<? extends T> addressType) {
        void var2_2;
        void var1_1;
        this.executor = (EventExecutor)ObjectUtil.checkNotNull((Object)var1_1, (String)"executor");
        this.matcher = TypeParameterMatcher.get((Class)var2_2);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSupported(SocketAddress address) {
        void var1_1;
        return this.matcher.match((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isResolved(SocketAddress address) {
        void var1_1;
        if (!this.isSupported(address)) {
            throw new UnsupportedAddressTypeException();
        }
        return this.doIsResolved(var1_1);
    }

    protected abstract boolean doIsResolved(T var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<T> resolve(SocketAddress address) {
        void cast;
        if (!this.isSupported((SocketAddress)ObjectUtil.checkNotNull((Object)address, (String)"address"))) {
            return this.executor().newFailedFuture((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            return this.executor.newSucceededFuture((Object)cast);
        }
        try {
            void var2_3;
            Promise promise = this.executor().newPromise();
            this.doResolve(cast, promise);
            return var2_3;
        }
        catch (Exception e) {
            void var1_2;
            return this.executor().newFailedFuture((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<T> resolve(SocketAddress address, Promise<T> promise) {
        void cast;
        ObjectUtil.checkNotNull((Object)address, (String)"address");
        ObjectUtil.checkNotNull(promise, (String)"promise");
        if (!this.isSupported(address)) {
            return promise.setFailure((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            return promise.setSuccess((Object)cast);
        }
        try {
            this.doResolve(cast, promise);
            return promise;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            return var2_3.setFailure((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<List<T>> resolveAll(SocketAddress address) {
        void cast;
        if (!this.isSupported((SocketAddress)ObjectUtil.checkNotNull((Object)address, (String)"address"))) {
            return this.executor().newFailedFuture((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            return this.executor.newSucceededFuture(Collections.singletonList(cast));
        }
        try {
            void var2_3;
            Promise promise = this.executor().newPromise();
            this.doResolveAll(cast, promise);
            return var2_3;
        }
        catch (Exception e) {
            void var1_2;
            return this.executor().newFailedFuture((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<List<T>> resolveAll(SocketAddress address, Promise<List<T>> promise) {
        void cast;
        ObjectUtil.checkNotNull((Object)address, (String)"address");
        ObjectUtil.checkNotNull(promise, (String)"promise");
        if (!this.isSupported(address)) {
            return promise.setFailure((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            return promise.setSuccess(Collections.singletonList(cast));
        }
        try {
            this.doResolveAll(cast, promise);
            return promise;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            return var2_3.setFailure((Throwable)var1_2);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2) throws Exception;

    protected abstract void doResolveAll(T var1, Promise<List<T>> var2) throws Exception;

    @Override
    public void close() {
    }
}

