/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.coroutines;

import androidx.room.coroutines.ConnectionWithLock;
import androidx.sqlite.SQLiteConnection;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0012\u0010\u001e\u001a\u00020\u001a2\n\u0010\u001f\u001a\u00060 j\u0002`!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/room/coroutines/Pool;", "", "capacity", "", "connectionFactory", "Lkotlin/Function0;", "Landroidx/sqlite/SQLiteConnection;", "<init>", "(ILkotlin/jvm/functions/Function0;)V", "getCapacity", "()I", "getConnectionFactory", "()Lkotlin/jvm/functions/Function0;", "size", "Ljava/util/concurrent/atomic/AtomicInteger;", "Landroidx/room/concurrent/AtomicInt;", "Ljava/util/concurrent/atomic/AtomicInteger;", "connections", "", "Landroidx/room/coroutines/ConnectionWithLock;", "[Landroidx/room/coroutines/ConnectionWithLock;", "channel", "Lkotlinx/coroutines/channels/Channel;", "acquire", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryOpenNewConnection", "", "recycle", "connection", "close", "dump", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "room-runtime"})
@SourceDebugExtension(value={"SMAP\nConnectionPoolImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/Pool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,532:1\n13402#2,2:533\n13467#2,3:535\n*S KotlinDebug\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/Pool\n*L\n254#1:533,2\n260#1:535,3\n*E\n"})
final class Pool {
    private final int capacity;
    private final Function0<SQLiteConnection> connectionFactory;
    private final AtomicInteger size;
    private final ConnectionWithLock[] connections;
    private final Channel<ConnectionWithLock> channel;

    /*
     * WARNING - void declaration
     */
    public Pool(int capacity, Function0<? extends SQLiteConnection> connectionFactory) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        this.capacity = var1_1;
        this.connectionFactory = var2_2;
        this.size = new AtomicInteger(0);
        this.connections = new ConnectionWithLock[this.capacity];
        this.channel = ChannelKt.Channel$default((int)this.capacity, null, arg_0 -> Pool.channel$lambda$0(this, arg_0), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final Object acquire(Continuation<? super ConnectionWithLock> $completion) {
        void var1_1;
        Object receiveResult = this.channel.tryReceive-PtdJZtk();
        if (ChannelResult.isSuccess-impl((Object)receiveResult)) {
            void var2_2;
            return (ConnectionWithLock)ChannelResult.getOrThrow-impl((Object)var2_2);
        }
        this.tryOpenNewConnection();
        return this.channel.receive((Continuation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void tryOpenNewConnection() {
        void var3_3;
        void var2_2;
        int n;
        do {
            int currentSize;
            if ((currentSize = this.size.get()) >= this.capacity) {
                return;
            }
            n = currentSize;
        } while (!this.size.compareAndSet(n, n + 1));
        ConnectionWithLock newConnection = new ConnectionWithLock((SQLiteConnection)this.connectionFactory.invoke(), null, 2);
        Object sendResult = this.channel.trySend-JP2dKIU((Object)newConnection);
        if (ChannelResult.isSuccess-impl((Object)sendResult)) {
            this.connections[var1_1] = newConnection;
            return;
        }
        var2_2.close();
        if (!ChannelResult.isClosed-impl((Object)var3_3)) {
            throw new IllegalStateException("Couldn't send a new connection for acquisition".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void recycle(ConnectionWithLock connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Object sendResult = this.channel.trySend-JP2dKIU((Object)connection);
        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
            void var2_2;
            void var1_1;
            var1_1.close();
            if (!ChannelResult.isClosed-impl((Object)var2_2)) {
                throw new IllegalStateException("Couldn't recycle connection".toString());
            }
        }
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.channel), null, (int)1, null);
        for (ConnectionWithLock connectionWithLock : this.connections) {
            ConnectionWithLock connectionWithLock2 = connectionWithLock;
            connectionWithLock2 = connectionWithLock;
            if (connectionWithLock == null) continue;
            connectionWithLock.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.append("\t" + super.toString() + " (capacity=" + this.capacity + ')').append('\n');
        ConnectionWithLock[] $this$forEachIndexed$iv = this.connections;
        int index$iv = 0;
        for (ConnectionWithLock item$iv : $this$forEachIndexed$iv) {
            void connection;
            int index = index$iv++;
            void v0 = connection;
            builder.append("\t\t[" + (index + 1) + "] - " + (v0 != null ? v0.toString() : null)).append('\n');
            void v1 = connection;
            if (v1 == null) continue;
            v1.dump(builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit channel$lambda$0(Pool this$0, ConnectionWithLock it) {
        void var1_1;
        Pool pool;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        pool.recycle((ConnectionWithLock)var1_1);
        return Unit.INSTANCE;
    }
}

