/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    /*
     * WARNING - void declaration
     */
    public static Hashtable<String, String[]> parseQueryString(String s) {
        void var1_1;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            Object object;
            Object valArray;
            Object pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), sb);
            String val = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (ht.containsKey(key)) {
                String[] oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i = 0; i < oldVals.length; ++i) {
                    valArray[i] = oldVals[i];
                }
                valArray[oldVals.length] = val;
            } else {
                String[] stringArray = new String[1];
                valArray = stringArray;
                stringArray[0] = val;
            }
            ht.put(key, (String[])object);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Hashtable<String, String[]> parsePostData(int len, ServletInputStream in) {
        int n;
        if (len <= 0) {
            return new Hashtable<String, String[]>();
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        byte[] postedBytes = new byte[len];
        try {
            int inputLen;
            int offset = 0;
            do {
                void var0_1;
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = lStrings.getString("err.io.short_read");
                throw new IllegalArgumentException((String)var0_1);
            } while (n - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            void var2_3;
            String e = new String((byte[])var2_3, 0, n, "8859_1");
            return HttpUtils.parseQueryString(e);
        }
        catch (UnsupportedEncodingException e) {
            void var3_7;
            throw new IllegalArgumentException(var3_7.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String parseName(String s, StringBuilder sb) {
        void var1_1;
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        void var3_4;
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (var3_4.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    void var3_3;
                    sb.append((char)var3_3);
                }
            }
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuffer getRequestURL(HttpServletRequest req) {
        void var1_1;
        void var3_3;
        void var2_2;
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = req.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || var2_2.equals("https") && var3_3 != 443) {
            HttpServletRequest httpServletRequest;
            url.append(':');
            url.append(httpServletRequest.getServerPort());
        }
        url.append(urlPath);
        return var1_1;
    }
}

