/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyResponse;

public abstract class HttpServlet
extends GenericServlet {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    /*
     * WARNING - void declaration
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String protocol = req.getProtocol();
        String msg = lStrings.getString("http.method_get_not_supported");
        if (var1_1.endsWith("1.1")) {
            resp.sendError(405, msg);
            return;
        }
        var2_2.sendError(400, (String)var3_3);
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        NoBodyResponse response = new NoBodyResponse(resp);
        this.doGet((HttpServletRequest)var1_1, response);
        var2_2.setContentLength();
    }

    /*
     * WARNING - void declaration
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String protocol = req.getProtocol();
        String msg = lStrings.getString("http.method_post_not_supported");
        if (var1_1.endsWith("1.1")) {
            resp.sendError(405, msg);
            return;
        }
        var2_2.sendError(400, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String protocol = req.getProtocol();
        String msg = lStrings.getString("http.method_put_not_supported");
        if (var1_1.endsWith("1.1")) {
            resp.sendError(405, msg);
            return;
        }
        var2_2.sendError(400, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String protocol = req.getProtocol();
        String msg = lStrings.getString("http.method_delete_not_supported");
        if (var1_1.endsWith("1.1")) {
            resp.sendError(405, msg);
            return;
        }
        var2_2.sendError(400, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Method[] getAllDeclaredMethods(Class<? extends HttpServlet> c) {
        Class<? extends HttpServlet> clazz = c;
        Method[] allMethods = null;
        while (!clazz.equals(HttpServlet.class)) {
            Method[] thisMethods = clazz.getDeclaredMethods();
            if (allMethods != null && allMethods.length > 0) {
                Method[] subClassMethods = allMethods;
                allMethods = new Method[thisMethods.length + subClassMethods.length];
                System.arraycopy(thisMethods, 0, allMethods, 0, thisMethods.length);
                System.arraycopy(subClassMethods, 0, allMethods, thisMethods.length, subClassMethods.length);
            } else {
                void var3_3;
                allMethods = var3_3;
            }
            clazz = clazz.getSuperclass();
        }
        if (allMethods != null) {
            void var2_2;
            return var2_2;
        }
        return new Method[0];
    }

    /*
     * WARNING - void declaration
     */
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var2_2;
        void var3_3;
        HttpServlet httpServlet = this;
        Method[] methods = httpServlet.getAllDeclaredMethods(httpServlet.getClass());
        boolean ALLOW_GET = false;
        boolean ALLOW_HEAD = false;
        boolean ALLOW_POST = false;
        boolean ALLOW_PUT = false;
        boolean ALLOW_DELETE = false;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.equals("doGet")) {
                ALLOW_GET = true;
                ALLOW_HEAD = true;
                continue;
            }
            if (methodName.equals("doPost")) {
                ALLOW_POST = true;
                continue;
            }
            if (methodName.equals("doPut")) {
                ALLOW_PUT = true;
                continue;
            }
            if (!methodName.equals("doDelete")) continue;
            ALLOW_DELETE = true;
        }
        StringBuilder allow = new StringBuilder();
        if (var3_3 != false) {
            allow.append(METHOD_GET);
        }
        if (ALLOW_HEAD) {
            if (allow.length() > 0) {
                allow.append(", ");
            }
            allow.append(METHOD_HEAD);
        }
        if (ALLOW_POST) {
            if (allow.length() > 0) {
                allow.append(", ");
            }
            allow.append(METHOD_POST);
        }
        if (ALLOW_PUT) {
            if (allow.length() > 0) {
                allow.append(", ");
            }
            allow.append(METHOD_PUT);
        }
        if (ALLOW_DELETE) {
            if (allow.length() > 0) {
                allow.append(", ");
            }
            allow.append(METHOD_DELETE);
        }
        if (allow.length() > 0) {
            allow.append(", ");
        }
        allow.append(METHOD_TRACE);
        if (allow.length() > 0) {
            allow.append(", ");
        }
        allow.append(METHOD_OPTIONS);
        var2_2.setHeader("Allow", allow.toString());
    }

    /*
     * WARNING - void declaration
     */
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var2_3;
        void var1_2;
        void var3_4;
        String CRLF = "\r\n";
        StringBuilder buffer = new StringBuilder("TRACE ").append(req.getRequestURI()).append(" ").append(req.getProtocol());
        Enumeration<String> reqHeaderEnum = req.getHeaderNames();
        while (reqHeaderEnum.hasMoreElements()) {
            String headerName = reqHeaderEnum.nextElement();
            buffer.append(CRLF).append(headerName).append(": ").append(req.getHeader(headerName));
        }
        buffer.append((String)var3_4);
        int responseLength = buffer.length();
        resp.setContentType("message/http");
        resp.setContentLength((int)var1_2);
        ServletOutputStream servletOutputStream = var2_3.getOutputStream();
        servletOutputStream.print(buffer.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var2_2;
        void var3_3;
        String method = req.getMethod();
        if (method.equals(METHOD_GET)) {
            long lastModified = this.getLastModified(req);
            if (lastModified == -1L) {
                this.doGet(req, resp);
                return;
            }
            long l = req.getDateHeader(HEADER_IFMODSINCE);
            if (l < lastModified) {
                this.maybeSetLastModified(resp, lastModified);
                this.doGet(req, resp);
                return;
            }
            resp.setStatus(304);
            return;
        }
        if (method.equals(METHOD_HEAD)) {
            long lastModified = this.getLastModified(req);
            this.maybeSetLastModified(resp, lastModified);
            this.doHead(req, resp);
            return;
        }
        if (method.equals(METHOD_POST)) {
            this.doPost(req, resp);
            return;
        }
        if (method.equals(METHOD_PUT)) {
            this.doPut(req, resp);
            return;
        }
        if (method.equals(METHOD_DELETE)) {
            this.doDelete(req, resp);
            return;
        }
        if (method.equals(METHOD_OPTIONS)) {
            this.doOptions(req, resp);
            return;
        }
        if (method.equals(METHOD_TRACE)) {
            void var1_1;
            this.doTrace((HttpServletRequest)var1_1, resp);
            return;
        }
        String errMsg = lStrings.getString("http.method_not_implemented");
        Object[] objectArray = new Object[1];
        Object[] errArgs = objectArray;
        objectArray[0] = var3_3;
        errMsg = MessageFormat.format(errMsg, errArgs);
        var2_2.sendError(501, errMsg);
    }

    /*
     * WARNING - void declaration
     */
    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (lastModified >= 0L) {
            void var2_2;
            void var1_1;
            var1_1.setDateHeader(HEADER_LASTMOD, (long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        void var2_2;
        void var1_1;
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.service((HttpServletRequest)var1_1, (HttpServletResponse)var2_2);
    }
}

