/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Cookie
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6454587001725327448L;
    private static final String TSPECIALS;
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings;
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private boolean isHttpOnly = false;

    /*
     * WARNING - void declaration
     */
    public Cookie(String name, String value) {
        void var1_1;
        void var2_2;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (!this.isToken(name) || name.equalsIgnoreCase("Comment") || name.equalsIgnoreCase("Discard") || name.equalsIgnoreCase("Domain") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Max-Age") || name.equalsIgnoreCase("Path") || name.equalsIgnoreCase("Secure") || name.equalsIgnoreCase("Version") || name.startsWith("$")) {
            void var3_3;
            String errMsg = lStrings.getString("err.cookie_name_is_token");
            Object[] objectArray = new Object[1];
            Object[] errArgs = objectArray;
            objectArray[0] = name;
            errMsg = MessageFormat.format(errMsg, (Object[])var3_3);
            throw new IllegalArgumentException((String)var2_2);
        }
        this.name = var1_1;
        this.value = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setComment(String purpose) {
        void var1_1;
        this.comment = var1_1;
    }

    public String getComment() {
        return this.comment;
    }

    /*
     * WARNING - void declaration
     */
    public void setDomain(String domain) {
        void var1_1;
        this.domain = var1_1.toLowerCase(Locale.ENGLISH);
    }

    public String getDomain() {
        return this.domain;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxAge(int expiry) {
        void var1_1;
        this.maxAge = var1_1;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    /*
     * WARNING - void declaration
     */
    public void setPath(String uri) {
        void var1_1;
        this.path = var1_1;
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecure(boolean flag) {
        void var1_1;
        this.secure = var1_1;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(String newValue) {
        void var1_1;
        this.value = var1_1;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public void setVersion(int v) {
        void var1_1;
        this.version = var1_1;
    }

    private boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new RuntimeException(var1_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpOnly(boolean isHttpOnly) {
        void var1_1;
        this.isHttpOnly = var1_1;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    static {
        lStrings = ResourceBundle.getBundle(LSTRING_FILE);
        TSPECIALS = Boolean.valueOf(System.getProperty("org.glassfish.web.rfc2109_cookie_names_enforced", "true")) != false ? "/()<>@,;:\\\"[]?={} \t" : ",; ";
    }
}

