/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;

public class ServletSecurityElement
extends HttpConstraintElement {
    private Collection<String> methodNames;
    private Collection<HttpMethodConstraintElement> methodConstraints;

    public ServletSecurityElement() {
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        this.methodNames = Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public ServletSecurityElement(HttpConstraintElement constraint) {
        super(constraint.getEmptyRoleSemantic(), constraint.getTransportGuarantee(), var1_1.getRolesAllowed());
        void var1_1;
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        this.methodNames = Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public ServletSecurityElement(Collection<HttpMethodConstraintElement> methodConstraints) {
        void var1_1;
        this.methodConstraints = methodConstraints == null ? new HashSet() : var1_1;
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    /*
     * WARNING - void declaration
     */
    public ServletSecurityElement(HttpConstraintElement constraint, Collection<HttpMethodConstraintElement> methodConstraints) {
        super(constraint.getEmptyRoleSemantic(), constraint.getTransportGuarantee(), var1_1.getRolesAllowed());
        void var2_2;
        void var1_1;
        this.methodConstraints = methodConstraints == null ? new HashSet() : var2_2;
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    public ServletSecurityElement(ServletSecurity annotation) {
        super(annotation.value().value(), annotation.value().transportGuarantee(), annotation.value().rolesAllowed());
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        for (HttpMethodConstraint constraint : annotation.httpMethodConstraints()) {
            this.methodConstraints.add(new HttpMethodConstraintElement(constraint.value(), new HttpConstraintElement(constraint.emptyRoleSemantic(), constraint.transportGuarantee(), constraint.rolesAllowed())));
        }
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        return Collections.unmodifiableCollection(this.methodConstraints);
    }

    public Collection<String> getMethodNames() {
        return Collections.unmodifiableCollection(this.methodNames);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<String> checkMethodNames(Collection<HttpMethodConstraintElement> methodConstraints) {
        void var2_2;
        HashSet<String> methodNames = new HashSet<String>();
        for (HttpMethodConstraintElement httpMethodConstraintElement : methodConstraints) {
            String methodName = httpMethodConstraintElement.getMethodName();
            if (methodNames.add(methodName)) continue;
            throw new IllegalArgumentException("Duplicate HTTP method name: " + (String)((Object)httpMethodConstraintElement));
        }
        return var2_2;
    }
}

