/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class JsonWriter
implements Closeable,
Flushable {
    private static final Pattern VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    /*
     * WARNING - void declaration
     */
    public JsonWriter(Writer out) {
        void var1_1;
        this.push(6);
        this.separator = ":";
        this.serializeNulls = true;
        this.out = (Writer)Objects.requireNonNull(var1_1, "out == null");
    }

    /*
     * WARNING - void declaration
     */
    public final void setIndent(String indent) {
        void var1_1;
        if (indent.length() == 0) {
            this.indent = null;
            this.separator = ":";
            return;
        }
        this.indent = var1_1;
        this.separator = ": ";
    }

    /*
     * WARNING - void declaration
     */
    public final void setLenient(boolean lenient) {
        void var1_1;
        this.lenient = var1_1;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHtmlSafe(boolean htmlSafe) {
        void var1_1;
        this.htmlSafe = var1_1;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSerializeNulls(boolean serializeNulls) {
        void var1_1;
        this.serializeNulls = var1_1;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    /*
     * WARNING - void declaration
     */
    private JsonWriter open(int empty, char openBracket) throws IOException {
        void var2_2;
        void var1_1;
        this.beforeValue();
        this.push((int)var1_1);
        this.out.write((int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private JsonWriter close(int empty, int nonempty, char closeBracket) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        int context = this.peek();
        if (context != nonempty && context != var1_1) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (context == var2_2) {
            this.newline();
        }
        this.out.write((int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void push(int newTop) {
        void var1_1;
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize << 1);
        }
        this.stack[this.stackSize++] = var1_1;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    /*
     * WARNING - void declaration
     */
    private void replaceTop(int topOfStack) {
        void var1_1;
        this.stack[this.stackSize - 1] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter name(String name) throws IOException {
        void var1_1;
        Objects.requireNonNull(name, "name == null");
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = var1_1;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            JsonWriter jsonWriter = this;
            jsonWriter.string(jsonWriter.deferredName);
            this.deferredName = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(String value) throws IOException {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter jsonValue(String value) throws IOException {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append((CharSequence)var1_1);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(boolean value) throws IOException {
        void var1_1;
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(var1_1 != false ? "true" : "false");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(Boolean value) throws IOException {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(var1_1.booleanValue() ? "true" : "false");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(float value) throws IOException {
        void var1_1;
        this.writeDeferredName();
        if (!this.lenient && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(Float.toString((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(double value) throws IOException {
        void var1_1;
        this.writeDeferredName();
        if (!this.lenient && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue();
        this.out.append(Double.toString((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(long value) throws IOException {
        void var1_1;
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString((long)var1_1));
        return this;
    }

    private static boolean isTrustedNumberType(Class<? extends Number> c) {
        Class<? extends Number> clazz;
        return c == Integer.class || c == Long.class || c == Double.class || c == Float.class || c == Byte.class || c == Short.class || c == BigDecimal.class || c == BigInteger.class || c == AtomicInteger.class || clazz == AtomicLong.class;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(Number value) throws IOException {
        void var2_2;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
            if (!this.lenient) {
                throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
            }
        } else {
            Class<?> numberClass = value.getClass();
            if (!JsonWriter.isTrustedNumberType(numberClass) && !VALID_JSON_NUMBER_PATTERN.matcher(string).matches()) {
                void var1_1;
                throw new IllegalArgumentException("String created by " + var1_1 + " is not a valid JSON number: " + string);
            }
        }
        this.beforeValue();
        this.out.append((CharSequence)var2_2);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws IOException {
        void var1_1;
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[var1_1 - true] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void string(String value) throws IOException {
        String[] replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write(34);
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            void replacement22;
            String replacement22;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement22 = replacements[c];
                if (replacement22 == null) {
                    continue;
                }
            } else if (replacement22 == 8232) {
                replacement22 = "\\u2028";
            } else {
                if (replacement22 != 8233) continue;
                replacement22 = "\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement22);
            last = i + 1;
        }
        if (last < length) {
            void var3_3;
            void var1_1;
            this.out.write((String)var1_1, last, length - var3_3);
        }
        this.out.write(34);
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void beforeName() throws IOException {
        void var1_1;
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (var1_1 != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                return;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                return;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                return;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem.");
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        String[] stringArray = (String[])REPLACEMENT_CHARS.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }
}

