/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.reflect;

import com.google.gson.internal.$Gson$Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TypeToken<T> {
    private final Class<? super T> rawType;
    private final Type type;
    private final int hashCode;

    protected TypeToken() {
        this.type = this.getTypeTokenTypeArgument();
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private TypeToken(Type type) {
        void var1_1;
        this.type = $Gson$Types.canonicalize((Type)Objects.requireNonNull(var1_1));
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private Type getTypeTokenTypeArgument() {
        void var1_1;
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)superclass;
            if (parameterized.getRawType() == TypeToken.class) {
                return $Gson$Types.canonicalize(var1_1.getActualTypeArguments()[0]);
            }
        } else if (var1_1 == TypeToken.class) {
            throw new IllegalStateException("TypeToken must be created with a type argument: new TypeToken<...>() {}; When using code shrinkers (ProGuard, R8, ...) make sure that generic signatures are preserved.");
        }
        throw new IllegalStateException("Must only create direct subclasses of TypeToken");
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isAssignableFrom(Class<?> cls) {
        void var1_1;
        return this.isAssignableFrom((Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isAssignableFrom(Type from) {
        if (from == null) {
            return false;
        }
        if (this.type.equals(from)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(from));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(from, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (this.type instanceof GenericArrayType) {
            void var1_1;
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(from)) && TypeToken.isAssignableFrom((Type)var1_1, (GenericArrayType)this.type);
        }
        throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> token) {
        void var1_1;
        return this.isAssignableFrom(var1_1.getType());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignableFrom(Type from, GenericArrayType to) {
        Type toGenericComponentType = to.getGenericComponentType();
        if (toGenericComponentType instanceof ParameterizedType) {
            void var1_1;
            void var2_2;
            Type t = from;
            if (from instanceof GenericArrayType) {
                t = ((GenericArrayType)from).getGenericComponentType();
            } else if (from instanceof Class) {
                Class<?> clazz;
                Class<?> classType = (Class)from;
                while (classType.isArray()) {
                    classType = classType.getComponentType();
                }
                t = clazz;
            }
            return TypeToken.isAssignableFrom((Type)var2_2, (ParameterizedType)var1_1, new HashMap<String, Type>());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignableFrom(Type from, ParameterizedType to, Map<String, Type> typeVarMap2) {
        while (from != null) {
            void var3_9;
            if (to.equals(from)) {
                return true;
            }
            Class<?> clazz = $Gson$Types.getRawType((Type)from);
            ParameterizedType ptype = null;
            if (from instanceof ParameterizedType) {
                ptype = (ParameterizedType)from;
            }
            if (ptype != null) {
                Type[] tArgs = ptype.getActualTypeArguments();
                TypeVariable<Class<?>>[] tParams = clazz.getTypeParameters();
                for (int i = 0; i < tArgs.length; ++i) {
                    Type type;
                    Type arg = tArgs[i];
                    TypeVariable<Class<?>> var = tParams[i];
                    while (arg instanceof TypeVariable) {
                        TypeVariable v = (TypeVariable)arg;
                        type = (Type)typeVarMap2.get(v.getName());
                    }
                    typeVarMap2.put(var.getName(), type);
                }
                if (TypeToken.typeEquals(ptype, (ParameterizedType)to, (Map<String, Type>)typeVarMap2)) {
                    return true;
                }
            }
            for (Type type : clazz.getGenericInterfaces()) {
                if (!TypeToken.isAssignableFrom(type, (ParameterizedType)to, new HashMap<String, Type>(typeVarMap2))) continue;
                return true;
            }
            Type type = var3_9.getGenericSuperclass();
            HashMap<String, Type> typeVarMap2 = new HashMap<String, Type>(typeVarMap2);
            Type type2 = type;
        }
        return false;
    }

    private static boolean typeEquals(ParameterizedType from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from.getRawType().equals(to.getRawType())) {
            Type[] fromArgs = from.getActualTypeArguments();
            Type[] toArgs = to.getActualTypeArguments();
            for (int i = 0; i < fromArgs.length; ++i) {
                if (TypeToken.matches(fromArgs[i], toArgs[i], typeVarMap)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static AssertionError buildUnexpectedTypeError(Type token, Class<?> ... expected) {
        void var2_2;
        Type type;
        void var1_1;
        StringBuilder exceptionMessage = new StringBuilder("Unexpected type. Expected one of: ");
        for (void clazz : var1_1) {
            exceptionMessage.append(clazz.getName()).append(", ");
        }
        exceptionMessage.append("but got: ").append(token.getClass().getName()).append(", for type token: ").append(type.toString()).append('.');
        return new AssertionError((Object)var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matches(Type from, Type to, Map<String, Type> typeMap) {
        Type type;
        void var2_2;
        void var1_1;
        return to.equals(from) || from instanceof TypeVariable && var1_1.equals(var2_2.get(((TypeVariable)type).getName()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        return o instanceof TypeToken && $Gson$Types.equals(this.type, ((TypeToken)var1_1).type);
    }

    public final String toString() {
        return $Gson$Types.typeToString(this.type);
    }

    public static TypeToken<?> get(Type type) {
        Type type2;
        return new TypeToken(type2);
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        Class<T> clazz;
        return new TypeToken<T>(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static TypeToken<?> getParameterized(Type rawType, Type ... typeArguments) {
        void var1_1;
        Type type;
        Objects.requireNonNull(rawType);
        Objects.requireNonNull(typeArguments);
        if (!(rawType instanceof Class)) {
            throw new IllegalArgumentException("rawType must be of type Class, but was " + rawType);
        }
        int actualArgsCount = typeArguments.length;
        Class rawClass = (Class)rawType;
        TypeVariable<Class<T>>[] typeVariables = rawClass.getTypeParameters();
        int expectedArgsCount = typeVariables.length;
        if (actualArgsCount != expectedArgsCount) {
            throw new IllegalArgumentException(rawClass.getName() + " requires " + expectedArgsCount + " type arguments, but got " + actualArgsCount);
        }
        for (int i = 0; i < expectedArgsCount; ++i) {
            Type typeArgument = typeArguments[i];
            Class<?> rawTypeArgument = $Gson$Types.getRawType(typeArgument);
            TypeVariable typeVariable = typeVariables[i];
            for (Type type2 : typeVariable.getBounds()) {
                Class<?> clazz = $Gson$Types.getRawType(type2);
                if (clazz.isAssignableFrom(rawTypeArgument)) continue;
                throw new IllegalArgumentException("Type argument " + typeArgument + " does not satisfy bounds for type variable " + typeVariable + " declared by " + rawType);
            }
        }
        return new TypeToken($Gson$Types.newParameterizedTypeWithOwner(null, type, (Type[])var1_1));
    }

    public static TypeToken<?> getArray(Type componentType) {
        Type type;
        return new TypeToken($Gson$Types.arrayOf(type));
    }
}

