/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static final RecordHelper RECORD_HELPER;

    private ReflectionHelper() {
    }

    /*
     * WARNING - void declaration
     */
    public static void makeAccessible(AccessibleObject object) throws JsonIOException {
        try {
            object.setAccessible(true);
            return;
        }
        catch (Exception exception) {
            void var1_1;
            String string;
            String description = ReflectionHelper.getAccessibleObjectDescription(object, false);
            throw new JsonIOException("Failed making " + (String)string + " accessible; either increase its visibility or write a custom TypeAdapter for its declaring type.", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getAccessibleObjectDescription(AccessibleObject object, boolean uppercaseFirstLetter) {
        Method method;
        void var1_1;
        Method description;
        if (object instanceof Field) {
            description = "field '" + ReflectionHelper.fieldToString((Field)object) + "'";
        } else if (description instanceof Method) {
            void var2_2;
            Method method2 = description;
            StringBuilder methodSignatureBuilder = new StringBuilder(method2.getName());
            ReflectionHelper.appendExecutableParameters(method2, methodSignatureBuilder);
            String methodSignature = methodSignatureBuilder.toString();
            description = "method '" + method2.getDeclaringClass().getName() + "#" + (String)var2_2 + "'";
        } else {
            description = description instanceof Constructor ? "constructor '" + ReflectionHelper.constructorToString((Constructor)((Object)description)) + "'" : "<unknown AccessibleObject> " + ((Object)description).toString();
        }
        if (var1_1 != false && Character.isLowerCase(((String)((Object)description)).charAt(0))) {
            description = Character.toUpperCase(((String)((Object)description)).charAt(0)) + ((String)((Object)description)).substring(1);
        }
        return method;
    }

    public static String fieldToString(Field field) {
        Field field2;
        return field.getDeclaringClass().getName() + "#" + field2.getName();
    }

    /*
     * WARNING - void declaration
     */
    public static String constructorToString(Constructor<?> constructor) {
        void var1_1;
        Constructor<?> constructor2;
        StringBuilder stringBuilder = new StringBuilder(constructor.getDeclaringClass().getName());
        ReflectionHelper.appendExecutableParameters(constructor2, stringBuilder);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void appendExecutableParameters(AccessibleObject executable, StringBuilder stringBuilder) {
        void var1_1;
        stringBuilder.append('(');
        Class<?>[] parameters = executable instanceof Method ? ((Method)executable).getParameterTypes() : ((Constructor)executable).getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameters[i].getSimpleName());
        }
        var1_1.append(')');
    }

    /*
     * WARNING - void declaration
     */
    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            void var1_1;
            Constructor<?> constructor2;
            return "Failed making constructor '" + ReflectionHelper.constructorToString(constructor2) + "' accessible; either increase its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: " + var1_1.getMessage();
        }
    }

    public static boolean isRecord(Class<?> raw) {
        Class<?> clazz;
        return RECORD_HELPER.isRecord(clazz);
    }

    public static String[] getRecordComponentNames(Class<?> raw) {
        Class<?> clazz;
        return RECORD_HELPER.getRecordComponentNames(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessor(Class<?> raw, Field field) {
        void var1_1;
        Class<?> clazz;
        return RECORD_HELPER.getAccessor(clazz, (Field)var1_1);
    }

    public static <T> Constructor<T> getCanonicalRecordConstructor(Class<T> raw) {
        Class<T> clazz;
        return RECORD_HELPER.getCanonicalRecordConstructor(clazz);
    }

    public static RuntimeException createExceptionForUnexpectedIllegalAccess(IllegalAccessException exception) {
        IllegalAccessException illegalAccessException;
        throw new RuntimeException("Unexpected IllegalAccessException occurred (Gson 2.10.1). Certain ReflectionAccessFilter features require Java >= 9 to work correctly. If you are not using ReflectionAccessFilter, report this to the Gson maintainers.", illegalAccessException);
    }

    private static RuntimeException createExceptionForRecordReflectionException(ReflectiveOperationException exception) {
        ReflectiveOperationException reflectiveOperationException;
        throw new RuntimeException("Unexpected ReflectiveOperationException occurred (Gson 2.10.1). To support Java records, reflection is utilized to read out information about records. All these invocations happens after it is established that records exist in the JVM. This exception is unexpected behavior.", reflectiveOperationException);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        RecordHelper instance;
        try {
            instance = new RecordSupportedHelper();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            instance = new RecordNotSupportedHelper();
        }
        RECORD_HELPER = var0;
    }

    private static class RecordNotSupportedHelper
    extends RecordHelper {
        private RecordNotSupportedHelper() {
        }

        @Override
        boolean isRecord(Class<?> clazz) {
            return false;
        }

        @Override
        String[] getRecordComponentNames(Class<?> clazz) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }

        @Override
        <T> Constructor<T> getCanonicalRecordConstructor(Class<T> raw) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }

        @Override
        public Method getAccessor(Class<?> raw, Field field) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }
    }

    private static class RecordSupportedHelper
    extends RecordHelper {
        private final Method isRecord = Class.class.getMethod("isRecord", new Class[0]);
        private final Method getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
        private final Method getName;
        private final Method getType;

        /*
         * WARNING - void declaration
         */
        private RecordSupportedHelper() throws NoSuchMethodException {
            void var1_1;
            Class<?> classRecordComponent = this.getRecordComponents.getReturnType().getComponentType();
            this.getName = classRecordComponent.getMethod("getName", new Class[0]);
            this.getType = var1_1.getMethod("getType", new Class[0]);
        }

        @Override
        boolean isRecord(Class<?> raw) {
            ReflectiveOperationException reflectiveOperationException;
            try {
                return (Boolean)this.isRecord.invoke((Object)reflectiveOperationException, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                reflectiveOperationException = reflectiveOperationException2;
                throw ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        String[] getRecordComponentNames(Class<?> raw) {
            try {
                void var2_2;
                Object[] recordComponents = (Object[])this.getRecordComponents.invoke(raw, new Object[0]);
                String[] componentNames = new String[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    componentNames[i] = (String)this.getName.invoke(recordComponents[i], new Object[0]);
                }
                return var2_2;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                throw ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> Constructor<T> getCanonicalRecordConstructor(Class<T> raw) {
            try {
                void var3_4;
                void var1_1;
                Object[] recordComponents = (Object[])this.getRecordComponents.invoke(raw, new Object[0]);
                Class[] recordComponentTypes = new Class[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    recordComponentTypes[i] = (Class)this.getType.invoke(recordComponents[i], new Object[0]);
                }
                return var1_1.getDeclaredConstructor((Class<?>)var3_4);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                throw ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Method getAccessor(Class<?> raw, Field field) {
            try {
                void var2_2;
                return raw.getMethod(var2_2.getName(), new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                throw ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException);
            }
        }
    }

    private static abstract class RecordHelper {
        private RecordHelper() {
        }

        abstract boolean isRecord(Class<?> var1);

        abstract String[] getRecordComponentNames(Class<?> var1);

        abstract <T> Constructor<T> getCanonicalRecordConstructor(Class<T> var1);

        public abstract Method getAccessor(Class<?> var1, Field var2);
    }
}

