/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Class value) throws IOException {
            void var2_2;
            throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + var2_2.getName() + ". Forgot to register a type adapter?");
        }

        @Override
        public Class read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
        }
    }.nullSafe();
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public BitSet read(JsonReader in) throws IOException {
            void var2_2;
            void var1_1;
            void var4_5;
            BitSet bitset = new BitSet();
            in.beginArray();
            int i = 0;
            JsonToken jsonToken = in.peek();
            while (var4_5 != JsonToken.END_ARRAY) {
                void var4_10;
                switch (35.$SwitchMap$com$google$gson$stream$JsonToken[var4_5.ordinal()]) {
                    case 1: 
                    case 2: {
                        int n = in.nextInt();
                        if (n == 0) {
                            boolean bl = false;
                            break;
                        }
                        if (n == 1) {
                            boolean bl = true;
                            break;
                        }
                        throw new JsonSyntaxException("Invalid bitset value " + n + ", expected 0 or 1; at path " + in.getPreviousPath());
                    }
                    case 3: {
                        boolean bl = in.nextBoolean();
                        break;
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + var4_5 + "; at path " + in.getPath());
                    }
                }
                if (var4_10 != false) {
                    bitset.set(i);
                }
                ++i;
                JsonToken jsonToken2 = in.peek();
            }
            var1_1.endArray();
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, BitSet src) throws IOException {
            void var1_1;
            out.beginArray();
            int length = src.length();
            for (int i = 0; i < length; ++i) {
                int value = src.get(i) ? 1 : 0;
                out.value(value);
            }
            var1_1.endArray();
        }
    }.nullSafe();
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean read(JsonReader in) throws IOException {
            void var1_1;
            void var2_2;
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (var2_2 == JsonToken.STRING) {
                return Boolean.parseBoolean(in.nextString());
            }
            return var1_1.nextBoolean();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            void var2_2;
            out.value((Boolean)var2_2);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Boolean.valueOf(var1_1.nextString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Boolean value) throws IOException {
            void var2_2;
            out.value(value == null ? "null" : var2_2.toString());
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            void var2_3;
            int intValue;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                intValue = in.nextInt();
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new JsonSyntaxException((Throwable)var1_2);
            }
            if (intValue > 255 || intValue < -128) {
                void var1_1;
                throw new JsonSyntaxException("Lossy conversion from " + intValue + " to byte; at path " + var1_1.getPreviousPath());
            }
            return (byte)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            var1_1.value(var2_2.byteValue());
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            void var2_3;
            int intValue;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                intValue = in.nextInt();
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new JsonSyntaxException((Throwable)var1_2);
            }
            if (intValue > 65535 || intValue < Short.MIN_VALUE) {
                void var1_1;
                throw new JsonSyntaxException("Lossy conversion from " + intValue + " to short; at path " + var1_1.getPreviousPath());
            }
            return (short)var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            var1_1.value(var2_2.shortValue());
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextInt();
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new JsonSyntaxException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            var1_1.value(var2_2.intValue());
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<AtomicInteger> ATOMIC_INTEGER = new TypeAdapter<AtomicInteger>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public AtomicInteger read(JsonReader in) throws IOException {
            try {
                return new AtomicInteger(in.nextInt());
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new JsonSyntaxException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, AtomicInteger value) throws IOException {
            void var2_2;
            out.value(var2_2.get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, ATOMIC_INTEGER);
    public static final TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN = new TypeAdapter<AtomicBoolean>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public AtomicBoolean read(JsonReader in) throws IOException {
            void var1_1;
            return new AtomicBoolean(var1_1.nextBoolean());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, AtomicBoolean value) throws IOException {
            void var2_2;
            out.value(var2_2.get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, ATOMIC_BOOLEAN);
    public static final TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY = new TypeAdapter<AtomicIntegerArray>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public AtomicIntegerArray read(JsonReader in) throws IOException {
            void var1_1;
            ArrayList<Integer> list = new ArrayList<Integer>();
            in.beginArray();
            while (in.hasNext()) {
                try {
                    int integer = in.nextInt();
                    list.add(integer);
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException(e);
                }
            }
            in.endArray();
            int length = list.size();
            AtomicIntegerArray array = new AtomicIntegerArray(length);
            for (int i = 0; i < length; ++i) {
                array.set(i, (Integer)list.get(i));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, AtomicIntegerArray value) throws IOException {
            void var1_1;
            out.beginArray();
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                out.value(value.get(i));
            }
            var1_1.endArray();
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, ATOMIC_INTEGER_ARRAY);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                return in.nextLong();
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new JsonSyntaxException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            var1_1.value(var2_2.longValue());
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return Float.valueOf((float)var1_1.nextDouble());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            Number floatNumber = value instanceof Float ? (Number)value : (Number)Float.valueOf(value.floatValue());
            var1_1.value((Number)var2_2);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Number read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return var1_1.nextDouble();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Number value) throws IOException {
            void var2_2;
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            var1_1.value(var2_2.doubleValue());
        }
    };
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Character read(JsonReader in) throws IOException {
            void var2_2;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String str = in.nextString();
            if (str.length() != 1) {
                void var1_1;
                throw new JsonSyntaxException("Expecting character, got: " + str + "; at " + var1_1.getPreviousPath());
            }
            return Character.valueOf(var2_2.charAt(0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Character value) throws IOException {
            void var2_2;
            out.value(value == null ? null : String.valueOf(var2_2));
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public String read(JsonReader in) throws IOException {
            void var1_1;
            void var2_2;
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (var2_2 == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return var1_1.nextString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, String value) throws IOException {
            void var2_2;
            out.value((String)var2_2);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public BigDecimal read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String s = in.nextString();
            try {
                return new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new JsonSyntaxException("Failed parsing '" + (String)var2_2 + "' as BigDecimal; at path " + var1_1.getPreviousPath(), (Throwable)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, BigDecimal value) throws IOException {
            void var2_2;
            out.value((Number)var2_2);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public BigInteger read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String s = in.nextString();
            try {
                return new BigInteger(s);
            }
            catch (NumberFormatException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new JsonSyntaxException("Failed parsing '" + (String)var2_2 + "' as BigInteger; at path " + var1_1.getPreviousPath(), (Throwable)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, BigInteger value) throws IOException {
            void var2_2;
            out.value((Number)var2_2);
        }
    };
    public static final TypeAdapter<LazilyParsedNumber> LAZILY_PARSED_NUMBER = new TypeAdapter<LazilyParsedNumber>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public LazilyParsedNumber read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new LazilyParsedNumber(var1_1.nextString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, LazilyParsedNumber value) throws IOException {
            void var2_2;
            out.value((Number)var2_2);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuilder(var1_1.nextString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, StringBuilder value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuffer read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new StringBuffer(var1_1.nextString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, StringBuffer value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public URL read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String nextString = in.nextString();
            if ("null".equals(nextString)) {
                return null;
            }
            return new URL((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, URL value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toExternalForm());
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public URI read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                String nextString = in.nextString();
                if ("null".equals(nextString)) {
                    return null;
                }
                return new URI(nextString);
            }
            catch (URISyntaxException e) {
                void var1_2;
                throw new JsonIOException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, URI value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toASCIIString());
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public InetAddress read(JsonReader in) throws IOException {
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return InetAddress.getByName(var1_1.nextString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, InetAddress value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public UUID read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String s = in.nextString();
            try {
                return java.util.UUID.fromString(s);
            }
            catch (IllegalArgumentException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new JsonSyntaxException("Failed parsing '" + (String)var2_2 + "' as UUID; at path " + var1_1.getPreviousPath(), (Throwable)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, UUID value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapter<Currency> CURRENCY = new TypeAdapter<Currency>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Currency read(JsonReader in) throws IOException {
            String s = in.nextString();
            try {
                return Currency.getInstance(s);
            }
            catch (IllegalArgumentException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new JsonSyntaxException("Failed parsing '" + (String)var2_2 + "' as Currency; at path " + var1_1.getPreviousPath(), (Throwable)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Currency value) throws IOException {
            void var2_2;
            out.value(var2_2.getCurrencyCode());
        }
    }.nullSafe();
    public static final TypeAdapterFactory CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, CURRENCY);
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){
        private static final String YEAR = "year";
        private static final String MONTH = "month";
        private static final String DAY_OF_MONTH = "dayOfMonth";
        private static final String HOUR_OF_DAY = "hourOfDay";
        private static final String MINUTE = "minute";
        private static final String SECOND = "second";

        /*
         * WARNING - void declaration
         */
        @Override
        public Calendar read(JsonReader in) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            int year = 0;
            int month = 0;
            int dayOfMonth = 0;
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            while (in.peek() != JsonToken.END_OBJECT) {
                String name = in.nextName();
                int value = in.nextInt();
                if (YEAR.equals(name)) {
                    year = value;
                    continue;
                }
                if (MONTH.equals(name)) {
                    month = value;
                    continue;
                }
                if (DAY_OF_MONTH.equals(name)) {
                    dayOfMonth = value;
                    continue;
                }
                if (HOUR_OF_DAY.equals(name)) {
                    hourOfDay = value;
                    continue;
                }
                if (MINUTE.equals(name)) {
                    minute = value;
                    continue;
                }
                if (!SECOND.equals(name)) continue;
                second = value;
            }
            var1_1.endObject();
            return new GregorianCalendar((int)var2_2, (int)var3_3, dayOfMonth, hourOfDay, minute, second);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Calendar value) throws IOException {
            void var1_1;
            void var2_2;
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(YEAR);
            out.value(value.get(1));
            out.name(MONTH);
            out.value(value.get(2));
            out.name(DAY_OF_MONTH);
            out.value(value.get(5));
            out.name(HOUR_OF_DAY);
            out.value(value.get(11));
            out.name(MINUTE);
            out.value(value.get(12));
            out.name(SECOND);
            out.value(var2_2.get(13));
            var1_1.endObject();
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Locale read(JsonReader in) throws IOException {
            void var3_3;
            void var2_2;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String locale = in.nextString();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                void var1_1;
                variant = var1_1.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale((String)var2_2, (String)var3_3, variant);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, Locale value) throws IOException {
            void var2_2;
            out.value(value == null ? null : var2_2.toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        /*
         * WARNING - void declaration
         */
        private JsonElement tryBeginNesting(JsonReader in, JsonToken peeked) throws IOException {
            void var2_2;
            switch (35.$SwitchMap$com$google$gson$stream$JsonToken[var2_2.ordinal()]) {
                case 4: {
                    in.beginArray();
                    return new JsonArray();
                }
                case 5: {
                    void var1_1;
                    var1_1.beginObject();
                    return new JsonObject();
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private JsonElement readTerminal(JsonReader in, JsonToken peeked) throws IOException {
            void var2_2;
            switch (peeked) {
                case STRING: {
                    return new JsonPrimitive(in.nextString());
                }
                case NUMBER: {
                    void var1_1;
                    String number = in.nextString();
                    return new JsonPrimitive(new LazilyParsedNumber((String)var1_1));
                }
                case BOOLEAN: {
                    void var1_1;
                    return new JsonPrimitive(var1_1.nextBoolean());
                }
                case NULL: {
                    void var1_1;
                    var1_1.nextNull();
                    return JsonNull.INSTANCE;
                }
            }
            throw new IllegalStateException("Unexpected token: " + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JsonElement read(JsonReader in) throws IOException {
            if (in instanceof JsonTreeReader) {
                return ((JsonTreeReader)in).nextJsonElement();
            }
            JsonToken peeked = in.peek();
            JsonElement current = this.tryBeginNesting(in, peeked);
            if (current == null) {
                return this.readTerminal(in, peeked);
            }
            ArrayDeque<JsonElement> stack = new ArrayDeque<JsonElement>();
            while (true) {
                if (in.hasNext()) {
                    JsonElement value;
                    boolean isNesting;
                    String name = null;
                    if (current instanceof JsonObject) {
                        name = in.nextName();
                    }
                    boolean bl = isNesting = (value = this.tryBeginNesting(in, peeked = in.peek())) != null;
                    if (value == null) {
                        void var3_2;
                        value = this.readTerminal(in, (JsonToken)var3_2);
                    }
                    if (current instanceof JsonArray) {
                        ((JsonArray)current).add(value);
                    } else {
                        ((JsonObject)current).add(name, value);
                    }
                    if (!isNesting) continue;
                    stack.addLast(current);
                    current = value;
                    continue;
                }
                if (current instanceof JsonArray) {
                    in.endArray();
                } else {
                    in.endObject();
                }
                if (stack.isEmpty()) {
                    return current;
                }
                current = (JsonElement)stack.removeLast();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void write(JsonWriter out, JsonElement value) throws IOException {
            Iterator<Object> iterator;
            if (value == null || value.isJsonNull()) {
                out.nullValue();
                return;
            }
            if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    out.value(((JsonElement)primitive).getAsNumber());
                    return;
                }
                if (primitive.isBoolean()) {
                    out.value(((JsonElement)primitive).getAsBoolean());
                    return;
                }
                out.value(((JsonElement)((Object)iterator)).getAsString());
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonArray()) {
                out.beginArray();
                iterator = ((JsonElement)((Object)iterator)).getAsJsonArray().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        out.endArray();
                        return;
                    }
                    JsonElement jsonElement = iterator.next();
                    this.write(out, jsonElement);
                }
            }
            if (!((JsonElement)((Object)iterator)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
            out.beginObject();
            iterator = ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    void var1_1;
                    var1_1.endObject();
                    return;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                out.name((String)entry.getKey());
                this.write(out, (JsonElement)entry.getValue());
            }
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            EnumTypeAdapter enumTypeAdapter;
            Class<T> rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            enumTypeAdapter = new EnumTypeAdapter(enumTypeAdapter);
            return enumTypeAdapter;
        }
    };

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(TypeToken<TT> type, TypeAdapter<TT> typeAdapter) {
        void var1_1;
        TypeToken<TT> typeToken;
        return new TypeAdapterFactory((TypeAdapter)var1_1){
            final /* synthetic */ TypeAdapter val$typeAdapter;
            {
                this.val$typeAdapter = typeAdapter;
            }

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken2) {
                if (typeToken2.equals(typeToken)) {
                    return this.val$typeAdapter;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(Class<TT> type, TypeAdapter<TT> typeAdapter) {
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory((TypeAdapter)var1_1){
            final /* synthetic */ TypeAdapter val$typeAdapter;
            {
                this.val$typeAdapter = typeAdapter;
            }

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() == clazz) {
                    return this.val$typeAdapter;
                }
                return null;
            }

            public String toString() {
                return "Factory[type=" + clazz.getName() + ",adapter=" + this.val$typeAdapter + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(Class<TT> unboxed, Class<TT> boxed, TypeAdapter<? super TT> typeAdapter) {
        void var2_2;
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory((Class)var1_1, (TypeAdapter)var2_2){
            final /* synthetic */ Class val$boxed;
            final /* synthetic */ TypeAdapter val$typeAdapter;
            {
                this.val$boxed = clazz2;
                this.val$typeAdapter = typeAdapter;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                void var1_1;
                Class<T> rawType = typeToken.getRawType();
                if (rawType == clazz || var1_1 == this.val$boxed) {
                    return this.val$typeAdapter;
                }
                return null;
            }

            public String toString() {
                return "Factory[type=" + this.val$boxed.getName() + "+" + clazz.getName() + ",adapter=" + this.val$typeAdapter + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(Class<TT> base, Class<? extends TT> sub, TypeAdapter<? super TT> typeAdapter) {
        void var2_2;
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory((Class)var1_1, (TypeAdapter)var2_2){
            final /* synthetic */ Class val$sub;
            final /* synthetic */ TypeAdapter val$typeAdapter;
            {
                this.val$sub = clazz2;
                this.val$typeAdapter = typeAdapter;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                void var1_1;
                Class<T> rawType = typeToken.getRawType();
                if (rawType == clazz || var1_1 == this.val$sub) {
                    return this.val$typeAdapter;
                }
                return null;
            }

            public String toString() {
                return "Factory[type=" + clazz.getName() + "+" + this.val$sub.getName() + ",adapter=" + this.val$typeAdapter + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T1> TypeAdapterFactory newTypeHierarchyFactory(Class<T1> clazz, TypeAdapter<T1> typeAdapter) {
        void var1_1;
        Class<T1> clazz2;
        return new TypeAdapterFactory((TypeAdapter)var1_1){
            final /* synthetic */ TypeAdapter val$typeAdapter;
            {
                this.val$typeAdapter = typeAdapter;
            }

            /*
             * WARNING - void declaration
             */
            public <T2> TypeAdapter<T2> create(Gson gson, TypeToken<T2> typeToken) {
                void var1_1;
                Class<T2> requestedType = typeToken.getRawType();
                if (!clazz2.isAssignableFrom(requestedType)) {
                    return null;
                }
                return new TypeAdapter<T1>(this, (Class)var1_1){
                    final /* synthetic */ Class val$requestedType;
                    final /* synthetic */ 34 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$requestedType = clazz;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void write(JsonWriter out, T1 value) throws IOException {
                        void var2_2;
                        void var1_1;
                        this.this$0.val$typeAdapter.write((JsonWriter)var1_1, var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public T1 read(JsonReader in) throws IOException {
                        void var2_2;
                        Object result = this.this$0.val$typeAdapter.read(in);
                        if (result != null && !this.val$requestedType.isInstance(result)) {
                            void var1_1;
                            throw new JsonSyntaxException("Expected a " + this.val$requestedType.getName() + " but was " + result.getClass().getName() + "; at path " + var1_1.getPreviousPath());
                        }
                        return var2_2;
                    }
                };
            }

            public String toString() {
                return "Factory[typeHierarchy=" + clazz2.getName() + ",adapter=" + this.val$typeAdapter + "]";
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<String, T> stringToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        /*
         * WARNING - void declaration
         */
        public EnumTypeAdapter(Class<T> classOfT) {
            try {
                Field[] fieldArray = AccessController.doPrivileged(new PrivilegedAction<Field[]>(this, classOfT){
                    final /* synthetic */ Class val$classOfT;
                    final /* synthetic */ EnumTypeAdapter this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$classOfT = clazz;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Field[] run() {
                        void var1_1;
                        void var2_2;
                        Field[] fields = this.val$classOfT.getDeclaredFields();
                        ArrayList<Field> constantFieldsList = new ArrayList<Field>(fields.length);
                        for (Field f : fields) {
                            if (!f.isEnumConstant()) continue;
                            constantFieldsList.add(f);
                        }
                        AccessibleObject[] constantFields = var2_2.toArray(new Field[0]);
                        AccessibleObject.setAccessible(constantFields, true);
                        return var1_1;
                    }
                });
                classOfT = fieldArray;
                classOfT = fieldArray;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field constantField = classOfT[i];
                    Enum constant = (Enum)constantField.get(null);
                    String name = constant.name();
                    String toStringVal = constant.toString();
                    SerializedName annotation = constantField.getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                        for (String alternate : annotation.alternate()) {
                            this.nameToConstant.put(alternate, constant);
                        }
                    }
                    this.nameToConstant.put(name, constant);
                    this.stringToConstant.put(toStringVal, constant);
                    this.constantToName.put(constant, name);
                }
                return;
            }
            catch (IllegalAccessException e) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T read(JsonReader in) throws IOException {
            void var2_2;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String key = in.nextString();
            Enum constant = (Enum)this.nameToConstant.get(key);
            if (constant == null) {
                void var1_1;
                return (T)((Enum)this.stringToConstant.get(var1_1));
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(JsonWriter out, T value) throws IOException {
            void var2_2;
            out.value(value == null ? null : this.constantToName.get(var2_2));
        }
    }
}

