/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.SerializationDelegatingTypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public final class TreeTypeAdapter<T>
extends SerializationDelegatingTypeAdapter<T> {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;
    final Gson gson;
    private final TypeToken<T> typeToken;
    private final TypeAdapterFactory skipPast;
    private final GsonContextImpl context = new GsonContextImpl();
    private final boolean nullSafe;
    private volatile TypeAdapter<T> delegate;

    /*
     * WARNING - void declaration
     */
    public TreeTypeAdapter(JsonSerializer<T> serializer, JsonDeserializer<T> deserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory skipPast, boolean nullSafe) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.serializer = var1_1;
        this.deserializer = var2_2;
        this.gson = var3_3;
        this.typeToken = typeToken;
        this.skipPast = skipPast;
        this.nullSafe = nullSafe;
    }

    /*
     * WARNING - void declaration
     */
    public TreeTypeAdapter(JsonSerializer<T> serializer, JsonDeserializer<T> deserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory skipPast) {
        this((JsonSerializer<T>)var1_1, (JsonDeserializer<T>)var2_2, (Gson)var3_3, typeToken, skipPast, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T read(JsonReader in) throws IOException {
        void var1_1;
        if (this.deserializer == null) {
            return this.delegate().read(in);
        }
        JsonElement value = Streams.parse(in);
        if (this.nullSafe && value.isJsonNull()) {
            return null;
        }
        return this.deserializer.deserialize((JsonElement)var1_1, this.typeToken.getType(), this.context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, T value) throws IOException {
        void var1_1;
        JsonElement jsonElement;
        if (this.serializer == null) {
            this.delegate().write(out, value);
            return;
        }
        if (this.nullSafe && value == null) {
            out.nullValue();
            return;
        }
        jsonElement = this.serializer.serialize((void)jsonElement, this.typeToken.getType(), this.context);
        Streams.write(jsonElement, (JsonWriter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private TypeAdapter<T> delegate() {
        TypeAdapter<T> d = this.delegate;
        if (d != null) {
            void var1_1;
            return var1_1;
        }
        this.delegate = this.gson.getDelegateAdapter(this.skipPast, this.typeToken);
        return this.delegate;
    }

    @Override
    public final TypeAdapter<T> getSerializationDelegate() {
        if (this.serializer != null) {
            return this;
        }
        return this.delegate();
    }

    /*
     * WARNING - void declaration
     */
    public static TypeAdapterFactory newFactory(TypeToken<?> exactType, Object typeAdapter) {
        TypeToken<?> typeToken;
        void var1_1;
        return new SingleTypeFactory(var1_1, typeToken, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static TypeAdapterFactory newFactoryWithMatchRawType(TypeToken<?> exactType, Object typeAdapter) {
        void var2_2;
        TypeToken<?> typeToken;
        void var1_1;
        boolean matchRawType = exactType.getType() == exactType.getRawType();
        return new SingleTypeFactory(var1_1, typeToken, (boolean)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static TypeAdapterFactory newTypeHierarchyFactory(Class<?> hierarchyType, Object typeAdapter) {
        Class<?> clazz;
        void var1_1;
        return new SingleTypeFactory(var1_1, null, false, clazz);
    }

    private final class GsonContextImpl
    implements JsonDeserializationContext,
    JsonSerializationContext {
        private GsonContextImpl() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final JsonElement serialize(Object src) {
            void var1_1;
            return TreeTypeAdapter.this.gson.toJsonTree(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final JsonElement serialize(Object src, Type typeOfSrc) {
            void var2_2;
            void var1_1;
            return TreeTypeAdapter.this.gson.toJsonTree(var1_1, (Type)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <R> R deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            void var2_2;
            void var1_1;
            return (R)TreeTypeAdapter.this.gson.fromJson((JsonElement)var1_1, (Type)var2_2);
        }
    }

    private static final class SingleTypeFactory
    implements TypeAdapterFactory {
        private final TypeToken<?> exactType;
        private final boolean matchRawType;
        private final Class<?> hierarchyType;
        private final JsonSerializer<?> serializer;
        private final JsonDeserializer<?> deserializer;

        /*
         * WARNING - void declaration
         */
        SingleTypeFactory(Object typeAdapter, TypeToken<?> exactType, boolean matchRawType, Class<?> hierarchyType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.serializer = typeAdapter instanceof JsonSerializer ? (JsonSerializer)typeAdapter : null;
            this.deserializer = typeAdapter instanceof JsonDeserializer ? (JsonDeserializer)var1_1 : null;
            $Gson$Preconditions.checkArgument(this.serializer != null || this.deserializer != null);
            this.exactType = var2_2;
            this.matchRawType = var3_3;
            this.hierarchyType = hierarchyType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            boolean bl;
            boolean bl2 = this.exactType != null ? this.exactType.equals(type) || this.matchRawType && this.exactType.getType() == type.getRawType() : (bl = this.hierarchyType.isAssignableFrom(type.getRawType()));
            if (bl2) {
                void var2_2;
                void var1_1;
                return new TreeTypeAdapter(this.serializer, this.deserializer, (Gson)var1_1, (TypeToken<?>)var2_2, this);
            }
            return null;
        }
    }
}

