/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final List<ReflectionAccessFilter> reflectionFilters;

    /*
     * WARNING - void declaration
     */
    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory, List<ReflectionAccessFilter> reflectionFilters) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.constructorConstructor = var1_1;
        this.fieldNamingPolicy = var2_2;
        this.excluder = var3_3;
        this.jsonAdapterFactory = jsonAdapterFactory;
        this.reflectionFilters = reflectionFilters;
    }

    /*
     * WARNING - void declaration
     */
    private boolean includeField(Field f, boolean serialize) {
        void var2_2;
        void var1_1;
        return !this.excluder.excludeClass(f.getType(), serialize) && !this.excluder.excludeField((Field)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getFieldNames(Field f) {
        void var3_3;
        void var2_2;
        void var1_1;
        SerializedName annotation = ((Field)f).getAnnotation(SerializedName.class);
        if (annotation == null) {
            f = this.fieldNamingPolicy.translateName((Field)f);
            return Collections.singletonList(f);
        }
        String serializedName = annotation.value();
        String[] alternates = annotation.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<void> fieldNames = new ArrayList<void>(alternates.length + 1);
        fieldNames.add(var1_1);
        Collections.addAll(fieldNames, var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean blockInaccessible;
        Class<T> raw = type.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, raw);
        if (filterResult == ReflectionAccessFilter.FilterResult.BLOCK_ALL) {
            throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + raw + ". Register a TypeAdapter for this type or adjust the access filter.");
        }
        boolean bl = blockInaccessible = filterResult == ReflectionAccessFilter.FilterResult.BLOCK_INACCESSIBLE;
        if (ReflectionHelper.isRecord(raw)) {
            RecordAdapter<T> recordAdapter = new RecordAdapter<T>(raw, this.getBoundFields(gson, type, raw, blockInaccessible, true), blockInaccessible);
            return recordAdapter;
        }
        ObjectConstructor<T> constructor = this.constructorConstructor.get(type);
        return new FieldReflectionAdapter<T>(constructor, this.getBoundFields((Gson)var1_1, (TypeToken<?>)var2_2, (Class<?>)var3_3, blockInaccessible, false));
    }

    /*
     * WARNING - void declaration
     */
    private static <M extends AccessibleObject> void checkAccessible(Object object, M member) {
        M m = member;
        if (!ReflectionAccessFilterHelper.canAccess(m, Modifier.isStatic(((Member)((Object)m)).getModifiers()) ? null : object)) {
            Object object2;
            void var1_1;
            Object memberDescription = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)var1_1, true);
            throw new JsonIOException((String)object2 + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private BoundField createBoundField(Gson context, Field field, Method accessor, String name, TypeToken<?> fieldType, boolean serialize, boolean deserialize, boolean blockInaccessible) {
        void var1_1;
        void var3_3;
        void var2_2;
        boolean jsonAdapterPresent;
        boolean isPrimitive = Primitives.isPrimitive(fieldType.getRawType());
        int modifiers = field.getModifiers();
        boolean isStaticFinalField = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        JsonAdapter annotation = field.getAnnotation(JsonAdapter.class);
        TypeAdapter<?> mapped = null;
        if (annotation != null) {
            mapped = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, context, fieldType, annotation);
        }
        boolean bl = jsonAdapterPresent = mapped != null;
        if (mapped == null) {
            mapped = context.getAdapter(fieldType);
        }
        TypeAdapter<?> typeAdapter = mapped;
        return new BoundField(this, name, (Field)var2_2, serialize, deserialize, blockInaccessible, (Method)var3_3, jsonAdapterPresent, typeAdapter, (Gson)var1_1, fieldType, isPrimitive, isStaticFinalField){
            final /* synthetic */ boolean val$blockInaccessible;
            final /* synthetic */ Method val$accessor;
            final /* synthetic */ boolean val$jsonAdapterPresent;
            final /* synthetic */ TypeAdapter val$typeAdapter;
            final /* synthetic */ Gson val$context;
            final /* synthetic */ TypeToken val$fieldType;
            final /* synthetic */ boolean val$isPrimitive;
            final /* synthetic */ boolean val$isStaticFinalField;
            final /* synthetic */ ReflectiveTypeAdapterFactory this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$blockInaccessible = bl;
                this.val$accessor = method;
                this.val$jsonAdapterPresent = bl2;
                this.val$typeAdapter = typeAdapter;
                this.val$context = gson;
                this.val$fieldType = typeToken;
                this.val$isPrimitive = bl3;
                this.val$isStaticFinalField = bl4;
                super((String)var2_2, (Field)var3_3, serialized, deserialized);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void write(JsonWriter writer, Object source) throws IOException, IllegalAccessException {
                void var3_4;
                TypeAdapter typeAdapter;
                void var1_1;
                Object fieldValue;
                if (!this.serialized) {
                    return;
                }
                if (this.val$blockInaccessible) {
                    if (this.val$accessor == null) {
                        ReflectiveTypeAdapterFactory.access$000(source, this.field);
                    } else {
                        ReflectiveTypeAdapterFactory.access$000(source, this.val$accessor);
                    }
                }
                if (this.val$accessor != null) {
                    try {
                        fieldValue = this.val$accessor.invoke(source, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        void var2_3;
                        String accessorDescription = ReflectionHelper.getAccessibleObjectDescription(this.val$accessor, false);
                        throw new JsonIOException("Accessor " + (String)var1_1 + " threw exception", var2_3.getCause());
                    }
                } else {
                    fieldValue = this.field.get(typeAdapter);
                }
                if (fieldValue == typeAdapter) {
                    return;
                }
                var1_1.name(this.name);
                typeAdapter = this.val$jsonAdapterPresent ? this.val$typeAdapter : new TypeAdapterRuntimeTypeWrapper(this.val$context, this.val$typeAdapter, this.val$fieldType.getType());
                typeAdapter.write((JsonWriter)var1_1, var3_4);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void readIntoArray(JsonReader reader, int index, Object[] target) throws IOException, JsonParseException {
                Object fieldValue = this.val$typeAdapter.read(reader);
                if (fieldValue == null && this.val$isPrimitive) {
                    void var1_1;
                    throw new JsonParseException("null is not allowed as value for record component '" + this.fieldName + "' of primitive type; at path " + var1_1.getPath());
                }
                var3_3[var2_2] = fieldValue;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void readIntoField(JsonReader reader, Object target) throws IOException, IllegalAccessException {
                Object fieldValue = this.val$typeAdapter.read(reader);
                if (fieldValue != null || !this.val$isPrimitive) {
                    void var2_2;
                    void var1_1;
                    if (this.val$blockInaccessible) {
                        ReflectiveTypeAdapterFactory.access$000(target, this.field);
                    } else if (this.val$isStaticFinalField) {
                        String fieldDescription = ReflectionHelper.getAccessibleObjectDescription(this.field, false);
                        throw new JsonIOException("Cannot set value of 'static final' " + (String)var1_1);
                    }
                    this.field.set(var2_2, var1_1);
                }
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type, Class<?> raw, boolean blockInaccessible, boolean isRecord) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        Class<?> originalRaw = raw;
        while (raw != Object.class) {
            Field[] fields = raw.getDeclaredFields();
            if (raw != originalRaw && fields.length > 0) {
                ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, raw);
                if (filterResult == ReflectionAccessFilter.FilterResult.BLOCK_ALL) {
                    throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + raw + " (supertype of " + originalRaw + "). Register a TypeAdapter for this type or adjust the access filter.");
                }
                blockInaccessible = filterResult == ReflectionAccessFilter.FilterResult.BLOCK_INACCESSIBLE;
            }
            Field[] fieldArray = fields;
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                boolean serialize = this.includeField(field, true);
                boolean deserialize = this.includeField(field, false);
                if (!serialize && !deserialize) continue;
                Method accessor = null;
                if (isRecord) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        deserialize = false;
                    } else {
                        accessor = ReflectionHelper.getAccessor(raw, field);
                        if (!blockInaccessible) {
                            ReflectionHelper.makeAccessible(accessor);
                        }
                        if (accessor.getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                            String methodDescription = ReflectionHelper.getAccessibleObjectDescription(accessor, false);
                            throw new JsonIOException("@SerializedName on " + methodDescription + " is not supported");
                        }
                    }
                }
                if (!blockInaccessible && accessor == null) {
                    ReflectionHelper.makeAccessible(field);
                }
                Type fieldType = $Gson$Types.resolve(type.getType(), raw, field.getGenericType());
                List<String> fieldNames = this.getFieldNames(field);
                BoundField previous = null;
                int size = fieldNames.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String name = fieldNames.get(i2);
                    if (i2 != 0) {
                        serialize = false;
                    }
                    BoundField boundField = this.createBoundField(context, field, accessor, name, TypeToken.get(fieldType), serialize, deserialize, blockInaccessible);
                    BoundField replaced = result.put(name, boundField);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException("Class " + originalRaw.getName() + " declares multiple JSON fields named '" + previous.name + "'; conflict is caused by fields " + ReflectionHelper.fieldToString(previous.field) + " and " + ReflectionHelper.fieldToString(field));
            }
            Class<?> clazz = raw;
            type = TypeToken.get($Gson$Types.resolve(type.getType(), clazz, clazz.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Object x0, AccessibleObject x1) {
        void var1_1;
        ReflectiveTypeAdapterFactory.checkAccessible(x0, var1_1);
    }

    private static final class RecordAdapter<T>
    extends Adapter<T, Object[]> {
        static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = RecordAdapter.primitiveDefaults();
        private final Constructor<T> constructor;
        private final Object[] constructorArgsDefaults;
        private final Map<String, Integer> componentIndices = new HashMap<String, Integer>();

        /*
         * WARNING - void declaration
         */
        RecordAdapter(Class<T> raw, Map<String, BoundField> boundFields, boolean blockInaccessible) {
            super(boundFields);
            void var3_6;
            this.constructor = ReflectionHelper.getCanonicalRecordConstructor(raw);
            if (var3_6 != false) {
                ReflectiveTypeAdapterFactory.access$000(null, this.constructor);
            } else {
                ReflectionHelper.makeAccessible(this.constructor);
            }
            String[] componentNames = ReflectionHelper.getRecordComponentNames(raw);
            for (int i = 0; i < componentNames.length; ++i) {
                this.componentIndices.put(componentNames[i], i);
            }
            Class<?>[] parameterTypes = this.constructor.getParameterTypes();
            this.constructorArgsDefaults = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.constructorArgsDefaults[i] = PRIMITIVE_DEFAULTS.get(parameterTypes[i]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static Map<Class<?>, Object> primitiveDefaults() {
            void var0;
            HashMap<Class<Serializable>, Serializable> zeroes = new HashMap<Class<Serializable>, Serializable>();
            zeroes.put(Byte.TYPE, Byte.valueOf((byte)0));
            zeroes.put(Short.TYPE, Short.valueOf((short)0));
            zeroes.put(Integer.TYPE, Integer.valueOf(0));
            zeroes.put(Long.TYPE, Long.valueOf(0L));
            zeroes.put(Float.TYPE, Float.valueOf(0.0f));
            zeroes.put(Double.TYPE, Double.valueOf(0.0));
            zeroes.put(Character.TYPE, Character.valueOf('\u0000'));
            zeroes.put(Boolean.TYPE, Boolean.FALSE);
            return var0;
        }

        @Override
        final Object[] createAccumulator() {
            return (Object[])this.constructorArgsDefaults.clone();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void readField(Object[] accumulator, JsonReader in, BoundField field) throws IOException {
            void var1_1;
            void var2_2;
            void var3_3;
            Integer componentIndex = this.componentIndices.get(field.fieldName);
            if (componentIndex == null) {
                throw new IllegalStateException("Could not find the index in the constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' for field with name '" + field.fieldName + "', unable to determine which argument in the constructor the field corresponds to. This is unexpected behavior, as we expect the RecordComponents to have the same names as the fields in the Java class, and that the order of the RecordComponents is the same as the order of the canonical constructor parameters.");
            }
            var3_3.readIntoArray((JsonReader)var2_2, componentIndex, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final T finalize(Object[] accumulator) {
            try {
                return this.constructor.newInstance(accumulator);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            catch (IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(accumulator), e);
            }
            catch (InvocationTargetException e) {
                void var2_4;
                void var1_1;
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString((Object[])var1_1), var2_4.getCause());
            }
        }
    }

    private static final class FieldReflectionAdapter<T>
    extends Adapter<T, T> {
        private final ObjectConstructor<T> constructor;

        /*
         * WARNING - void declaration
         */
        FieldReflectionAdapter(ObjectConstructor<T> constructor, Map<String, BoundField> boundFields) {
            super((Map<String, BoundField>)var2_2);
            void var1_1;
            void var2_2;
            this.constructor = var1_1;
        }

        @Override
        final T createAccumulator() {
            return this.constructor.construct();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void readField(T accumulator, JsonReader in, BoundField field) throws IllegalAccessException, IOException {
            void var1_1;
            void var2_2;
            field.readIntoField((JsonReader)var2_2, var1_1);
        }

        @Override
        final T finalize(T accumulator) {
            return accumulator;
        }
    }

    public static abstract class Adapter<T, A>
    extends TypeAdapter<T> {
        final Map<String, BoundField> boundFields;

        /*
         * WARNING - void declaration
         */
        Adapter(Map<String, BoundField> boundFields) {
            void var1_1;
            this.boundFields = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, T value) throws IOException {
            void var1_1;
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    boundField.write(out, value);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            var1_1.endObject();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T read(JsonReader in) throws IOException {
            void var2_2;
            void var1_1;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            A accumulator = this.createAccumulator();
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    BoundField field = this.boundFields.get(name);
                    if (field == null || !field.deserialized) {
                        in.skipValue();
                        continue;
                    }
                    this.readField(accumulator, in, field);
                }
            }
            catch (IllegalStateException e) {
                void var3_4;
                throw new JsonSyntaxException((Throwable)var3_4);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            var1_1.endObject();
            return this.finalize(var2_2);
        }

        abstract A createAccumulator();

        abstract void readField(A var1, JsonReader var2, BoundField var3) throws IllegalAccessException, IOException;

        abstract T finalize(A var1);
    }

    static abstract class BoundField {
        final String name;
        final Field field;
        final String fieldName;
        final boolean serialized;
        final boolean deserialized;

        /*
         * WARNING - void declaration
         */
        protected BoundField(String name, Field field, boolean serialized, boolean deserialized) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.field = field;
            this.fieldName = var2_2.getName();
            this.serialized = var3_3;
            this.deserialized = deserialized;
        }

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void readIntoArray(JsonReader var1, int var2, Object[] var3) throws IOException, JsonParseException;

        abstract void readIntoField(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

