/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    private static final TypeAdapterFactory DOUBLE_FACTORY = ObjectTypeAdapter.newFactory(ToNumberPolicy.DOUBLE);
    private final Gson gson;
    private final ToNumberStrategy toNumberStrategy;

    /*
     * WARNING - void declaration
     */
    private ObjectTypeAdapter(Gson gson, ToNumberStrategy toNumberStrategy) {
        void var2_2;
        void var1_1;
        this.gson = var1_1;
        this.toNumberStrategy = var2_2;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        ToNumberStrategy toNumberStrategy2;
        return new TypeAdapterFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == Object.class) {
                    void var1_1;
                    return new ObjectTypeAdapter((Gson)var1_1, toNumberStrategy2);
                }
                return null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        ToNumberStrategy toNumberStrategy2;
        if (toNumberStrategy == ToNumberPolicy.DOUBLE) {
            return DOUBLE_FACTORY;
        }
        return ObjectTypeAdapter.newFactory(toNumberStrategy2);
    }

    /*
     * WARNING - void declaration
     */
    private Object tryBeginNesting(JsonReader in, JsonToken peeked) throws IOException {
        void var2_2;
        switch (2.$SwitchMap$com$google$gson$stream$JsonToken[var2_2.ordinal()]) {
            case 1: {
                in.beginArray();
                return new ArrayList();
            }
            case 2: {
                void var1_1;
                var1_1.beginObject();
                return new LinkedTreeMap();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object readTerminal(JsonReader in, JsonToken peeked) throws IOException {
        void var2_2;
        switch (peeked) {
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                return this.toNumberStrategy.readNumber(in);
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                void var1_1;
                var1_1.nextNull();
                return null;
            }
        }
        throw new IllegalStateException("Unexpected token: " + var2_2);
    }

    @Override
    public final Object read(JsonReader in) throws IOException {
        JsonToken peeked = in.peek();
        Object current = this.tryBeginNesting(in, peeked);
        if (current == null) {
            return this.readTerminal(in, peeked);
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        while (true) {
            if (in.hasNext()) {
                Object object;
                Object value;
                boolean isNesting;
                String name = null;
                if (current instanceof Map) {
                    name = in.nextName();
                }
                boolean bl = isNesting = (value = this.tryBeginNesting(in, peeked = in.peek())) != null;
                if (value == null) {
                    value = this.readTerminal(in, (JsonToken)((Object)object));
                }
                if (current instanceof List) {
                    object = (List)current;
                    object.add(value);
                } else {
                    object = (Map)current;
                    object.put(name, value);
                }
                if (!isNesting) continue;
                stack.addLast(current);
                current = value;
                continue;
            }
            if (current instanceof List) {
                in.endArray();
            } else {
                in.endObject();
            }
            if (stack.isEmpty()) {
                return current;
            }
            current = stack.removeLast();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Object value) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        if (value == null) {
            out.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.gson.getAdapter(value.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            out.beginObject();
            out.endObject();
            return;
        }
        var3_3.write((JsonWriter)var1_1, var2_2);
    }
}

