/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    final boolean complexMapKeySerialization;

    /*
     * WARNING - void declaration
     */
    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean complexMapKeySerialization) {
        void var2_2;
        void var1_1;
        this.constructorConstructor = var1_1;
        this.complexMapKeySerialization = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        void var2_2;
        void var3_3;
        Adapter adapter;
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type[] keyAndValueTypes = $Gson$Types.getMapKeyAndValueTypes(type, rawType);
        TypeAdapter<?> keyAdapter = this.getKeyAdapter(gson, keyAndValueTypes[0]);
        TypeAdapter<?> valueAdapter = gson.getAdapter(TypeToken.get(keyAndValueTypes[1]));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        adapter = new Adapter((Gson)((Object)adapter), keyAndValueTypes[0], keyAdapter, (Type)var3_3[1], valueAdapter, (ObjectConstructor<Map<?, ?>>)var2_2);
        return adapter;
    }

    /*
     * WARNING - void declaration
     */
    private TypeAdapter<?> getKeyAdapter(Gson context, Type keyType) {
        void var2_2;
        void var1_1;
        if (keyType == Boolean.TYPE || keyType == Boolean.class) {
            return TypeAdapters.BOOLEAN_AS_STRING;
        }
        return var1_1.getAdapter(TypeToken.get((Type)var2_2));
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;

        /*
         * WARNING - void declaration
         */
        public Adapter(Gson context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<K, V>> constructor) {
            void var2_2;
            void var3_3;
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, (Type)var3_3);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>((Gson)var2_2, valueTypeAdapter, valueType);
            this.constructor = constructor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<K, V> read(JsonReader in) throws IOException {
            void var3_3;
            K key;
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Map<K, V> map = this.constructor.construct();
            if (peek == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    in.beginArray();
                    key = this.keyTypeAdapter.read(in);
                    V value = this.valueTypeAdapter.read(in);
                    value = map.put(key, value);
                    if (value != null) {
                        throw new JsonSyntaxException("duplicate key: " + key);
                    }
                    in.endArray();
                }
                in.endArray();
            } else {
                void var1_1;
                in.beginObject();
                while (in.hasNext()) {
                    void var2_2;
                    V value;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    key = this.keyTypeAdapter.read(in);
                    V v = map.put(key, value = this.valueTypeAdapter.read(in));
                    if (v == null) continue;
                    throw new JsonSyntaxException("duplicate key: " + var2_2);
                }
                var1_1.endObject();
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(JsonWriter out, Map<K, V> map) throws IOException {
            void var1_1;
            void var3_6;
            JsonElement keyElement;
            if (map == null) {
                out.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                out.beginObject();
                for (Map.Entry entry : map.entrySet()) {
                    out.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(out, entry.getValue());
                }
                out.endObject();
                return;
            }
            boolean hasComplexKeys = false;
            ArrayList<JsonElement> keys = new ArrayList<JsonElement>(map.size());
            ArrayList values = new ArrayList(map.size());
            for (Map.Entry entry : map.entrySet()) {
                keyElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
                keys.add(keyElement);
                values.add(entry.getValue());
                hasComplexKeys |= keyElement.isJsonArray() || keyElement.isJsonObject();
            }
            if (var3_6 != false) {
                out.beginArray();
                int n = keys.size();
                for (int i = 0; i < n; ++i) {
                    out.beginArray();
                    Streams.write((JsonElement)keys.get(i), out);
                    this.valueTypeAdapter.write(out, values.get(i));
                    out.endArray();
                }
                out.endArray();
                return;
            }
            out.beginObject();
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                keyElement = (JsonElement)keys.get(i);
                out.name(this.keyToString(keyElement));
                this.valueTypeAdapter.write(out, values.get(i));
            }
            var1_1.endObject();
        }

        /*
         * WARNING - void declaration
         */
        private String keyToString(JsonElement keyElement) {
            void var1_1;
            if (keyElement.isJsonPrimitive()) {
                JsonPrimitive primitive = keyElement.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    return String.valueOf(((JsonElement)primitive).getAsNumber());
                }
                if (primitive.isBoolean()) {
                    return Boolean.toString(((JsonElement)primitive).getAsBoolean());
                }
                if (primitive.isString()) {
                    return var1_1.getAsString();
                }
                throw new AssertionError();
            }
            if (var1_1.isJsonNull()) {
                return "null";
            }
            throw new AssertionError();
        }
    }
}

