/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        @Override
        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        @Override
        public void flush() {
            throw new AssertionError();
        }

        @Override
        public void close() {
            throw new AssertionError();
        }
    };
    private static final JsonPrimitive SENTINEL_CLOSED = new JsonPrimitive("closed");
    private final List<JsonElement> stack = new ArrayList<JsonElement>();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public final JsonElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + this.stack);
        }
        return this.product;
    }

    private JsonElement peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private void put(JsonElement value) {
        if (this.pendingName != null) {
            if (!value.isJsonNull() || this.getSerializeNulls()) {
                JsonObject jsonObject = (JsonObject)this.peek();
                jsonObject.add(this.pendingName, value);
            }
            this.pendingName = null;
            return;
        }
        if (this.stack.isEmpty()) {
            this.product = value;
            return;
        }
        JsonElement element = this.peek();
        if (element instanceof JsonArray) {
            void var1_1;
            void var2_3;
            ((JsonArray)var2_3).add((JsonElement)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter beginArray() throws IOException {
        void var1_1;
        JsonArray array = new JsonArray();
        this.put(array);
        this.stack.add((JsonElement)var1_1);
        return this;
    }

    @Override
    public final JsonWriter endArray() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter beginObject() throws IOException {
        void var1_1;
        JsonObject object = new JsonObject();
        this.put(object);
        this.stack.add((JsonElement)var1_1);
        return this;
    }

    @Override
    public final JsonWriter endObject() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter name(String name) throws IOException {
        Objects.requireNonNull(name, "name == null");
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            void var1_1;
            this.pendingName = var1_1;
            return this;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(String value) throws IOException {
        void var1_1;
        if (value == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive((String)var1_1));
        return this;
    }

    @Override
    public final JsonWriter jsonValue(String value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final JsonWriter nullValue() throws IOException {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(boolean value) throws IOException {
        void var1_1;
        this.put(new JsonPrimitive((boolean)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(Boolean value) throws IOException {
        void var1_1;
        if (value == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive((Boolean)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(float value) throws IOException {
        void var1_1;
        if (!this.isLenient() && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.put(new JsonPrimitive(Float.valueOf((float)var1_1)));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(double value) throws IOException {
        void var1_1;
        if (!this.isLenient() && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.put(new JsonPrimitive((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(long value) throws IOException {
        void var1_1;
        this.put(new JsonPrimitive((long)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonWriter value(Number value) throws IOException {
        void var1_1;
        void var2_2;
        double d;
        if (value == null) {
            return ((JsonWriter)this).nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite((double)var2_2))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.put(new JsonPrimitive((Number)var1_1));
        return this;
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final void close() throws IOException {
        if (!this.stack.isEmpty()) {
            throw new IOException("Incomplete document");
        }
        this.stack.add(SENTINEL_CLOSED);
    }
}

