/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new Reader(){

        @Override
        public int read(char[] buffer, int offset, int count) {
            throw new AssertionError();
        }

        @Override
        public void close() {
            throw new AssertionError();
        }
    };
    private static final Object SENTINEL_CLOSED = new Object();
    private Object[] stack = new Object[32];
    private int stackSize = 0;
    private String[] pathNames = new String[32];
    private int[] pathIndices = new int[32];

    /*
     * WARNING - void declaration
     */
    public JsonTreeReader(JsonElement element) {
        super(UNREADABLE_READER);
        void var1_1;
        this.push(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void beginArray() throws IOException {
        void var1_1;
        this.expect(JsonToken.BEGIN_ARRAY);
        JsonArray array = (JsonArray)this.peekStack();
        this.push(var1_1.iterator());
        this.pathIndices[this.stackSize - 1] = 0;
    }

    @Override
    public final void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void beginObject() throws IOException {
        void var1_1;
        this.expect(JsonToken.BEGIN_OBJECT);
        JsonObject object = (JsonObject)this.peekStack();
        this.push(var1_1.entrySet().iterator());
    }

    @Override
    public final void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
        this.pathNames[this.stackSize - 1] = null;
        this.popStack();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasNext() throws IOException {
        void var1_1;
        JsonToken token = ((JsonReader)this).peek();
        return token != JsonToken.END_OBJECT && token != JsonToken.END_ARRAY && var1_1 != JsonToken.END_DOCUMENT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonToken peek() throws IOException {
        void var1_1;
        block12: {
            boolean isObject;
            while (true) {
                if (this.stackSize == 0) {
                    return JsonToken.END_DOCUMENT;
                }
                Object o = this.peekStack();
                if (!(o instanceof Iterator)) break block12;
                isObject = this.stack[this.stackSize - 2] instanceof JsonObject;
                Iterator iterator = (Iterator)o;
                if (!iterator.hasNext()) break;
                if (isObject) {
                    return JsonToken.NAME;
                }
                this.push(var1_1.next());
            }
            if (isObject) {
                return JsonToken.END_OBJECT;
            }
            return JsonToken.END_ARRAY;
        }
        if (var1_1 instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (var1_1 instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (var1_1 instanceof JsonPrimitive) {
            void var2_3;
            JsonPrimitive primitive = (JsonPrimitive)var1_1;
            if (primitive.isString()) {
                return JsonToken.STRING;
            }
            if (primitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (var2_3.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (var1_1 instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (var1_1 == SENTINEL_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new MalformedJsonException("Custom JsonElement subclass " + var1_1.getClass().getName() + " is not supported");
    }

    private Object peekStack() {
        return this.stack[this.stackSize - 1];
    }

    /*
     * WARNING - void declaration
     */
    private Object popStack() {
        void var1_1;
        Object result = this.stack[--this.stackSize];
        this.stack[this.stackSize] = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void expect(JsonToken expected) throws IOException {
        if (((JsonReader)this).peek() != expected) {
            void var1_1;
            throw new IllegalStateException("Expected " + var1_1 + " but was " + (Object)((Object)((JsonReader)this).peek()) + this.locationString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private String nextName(boolean skipName) throws IOException {
        void var3_3;
        void var1_1;
        this.expect(JsonToken.NAME);
        Iterator iterator = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)iterator.next();
        String result = (String)entry.getKey();
        this.pathNames[this.stackSize - 1] = var1_1 != false ? "<skipped>" : result;
        this.push(iterator.getValue());
        return var3_3;
    }

    @Override
    public final String nextName() throws IOException {
        return this.nextName(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String nextString() throws IOException {
        void var1_1;
        JsonToken token = ((JsonReader)this).peek();
        if (token != JsonToken.STRING && token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.STRING) + " but was " + (Object)((Object)token) + this.locationString());
        }
        String result = ((JsonElement)((JsonPrimitive)this.popStack())).getAsString();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean nextBoolean() throws IOException {
        void var1_1;
        this.expect(JsonToken.BOOLEAN);
        boolean result = ((JsonElement)((JsonPrimitive)this.popStack())).getAsBoolean();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return (boolean)var1_1;
    }

    @Override
    public final void nextNull() throws IOException {
        this.expect(JsonToken.NULL);
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double nextDouble() throws IOException {
        void var2_2;
        JsonToken token = ((JsonReader)this).peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            void var1_1;
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + var1_1 + this.locationString());
        }
        double result = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + result);
        }
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long nextLong() throws IOException {
        void var2_2;
        JsonToken token = ((JsonReader)this).peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            void var1_1;
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + var1_1 + this.locationString());
        }
        long result = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsLong();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int nextInt() throws IOException {
        void var1_2;
        JsonToken token = ((JsonReader)this).peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)token) + this.locationString());
        }
        int result = ((JsonElement)((JsonPrimitive)this.peekStack())).getAsInt();
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    final JsonElement nextJsonElement() throws IOException {
        void var1_1;
        JsonToken peeked = ((JsonReader)this).peek();
        if (peeked == JsonToken.NAME || peeked == JsonToken.END_ARRAY || peeked == JsonToken.END_OBJECT || peeked == JsonToken.END_DOCUMENT) {
            throw new IllegalStateException("Unexpected " + (Object)((Object)peeked) + " when reading a JsonElement.");
        }
        JsonElement element = (JsonElement)this.peekStack();
        ((JsonReader)this).skipValue();
        return var1_1;
    }

    @Override
    public final void close() throws IOException {
        this.stack = new Object[]{SENTINEL_CLOSED};
        this.stackSize = 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void skipValue() throws IOException {
        void var1_1;
        JsonToken peeked = ((JsonReader)this).peek();
        switch (2.$SwitchMap$com$google$gson$stream$JsonToken[var1_1.ordinal()]) {
            case 1: {
                this.nextName(true);
                return;
            }
            case 2: {
                ((JsonReader)this).endArray();
                return;
            }
            case 3: {
                ((JsonReader)this).endObject();
                return;
            }
            case 4: {
                return;
            }
        }
        this.popStack();
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    public final void promoteNameToValue() throws IOException {
        this.expect(JsonToken.NAME);
        Iterator iterator = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)iterator.next();
        this.push(entry.getValue());
        this.push(new JsonPrimitive((String)iterator.getKey()));
    }

    /*
     * WARNING - void declaration
     */
    private void push(Object newTop) {
        void var1_1;
        if (this.stackSize == this.stack.length) {
            void var2_2;
            int newLength = this.stackSize << 1;
            this.stack = Arrays.copyOf(this.stack, newLength);
            this.pathIndices = Arrays.copyOf(this.pathIndices, newLength);
            this.pathNames = Arrays.copyOf(this.pathNames, (int)var2_2);
        }
        this.stack[this.stackSize++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String getPath(boolean usePreviousPath) {
        void var2_2;
        StringBuilder result = new StringBuilder("$");
        for (int i = 0; i < this.stackSize; ++i) {
            if (this.stack[i] instanceof JsonArray) {
                if (++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
                int pathIndex = this.pathIndices[i];
                if (usePreviousPath && pathIndex > 0 && (i == this.stackSize - 1 || i == this.stackSize - 2)) {
                    --pathIndex;
                }
                result.append('[').append(pathIndex).append(']');
                continue;
            }
            if (!(this.stack[i] instanceof JsonObject) || ++i >= this.stackSize || !(this.stack[i] instanceof Iterator)) continue;
            result.append('.');
            if (this.pathNames[i] == null) continue;
            result.append(this.pathNames[i]);
        }
        return var2_2.toString();
    }

    @Override
    public final String getPreviousPath() {
        return this.getPath(true);
    }

    @Override
    public final String getPath() {
        return this.getPath(false);
    }

    private String locationString() {
        return " at path " + ((JsonReader)this).getPath();
    }
}

