/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class DefaultDateTypeAdapter<T extends Date>
extends TypeAdapter<T> {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    private final DateType<T> dateType;
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, String datePattern) {
        void var1_1;
        this.dateType = (DateType)Objects.requireNonNull(var1_1);
        this.dateFormats.add(new SimpleDateFormat(datePattern, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            void var2_2;
            this.dateFormats.add(new SimpleDateFormat((String)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, int style) {
        void var1_1;
        this.dateType = (DateType)Objects.requireNonNull(var1_1);
        this.dateFormats.add(DateFormat.getDateInstance(style, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateInstance(style));
        }
        if (JavaVersion.isJava9OrLater()) {
            void var2_2;
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateFormat((int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, int dateStyle, int timeStyle) {
        void var1_1;
        this.dateType = (DateType)Objects.requireNonNull(var1_1);
        this.dateFormats.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle));
        }
        if (JavaVersion.isJava9OrLater()) {
            void var3_3;
            void var2_2;
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat((int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Date value) throws IOException {
        void var2_3;
        void var1_1;
        if (value == null) {
            out.nullValue();
            return;
        }
        DateFormat dateFormat = this.dateFormats.get(0);
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            void var3_4;
            String dateFormatAsString = var3_4.format(value);
        }
        var1_1.value((String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T read(JsonReader in) throws IOException {
        void var1_1;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Date date = this.deserializeToDate(in);
        return this.dateType.deserialize((Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Date deserializeToDate(JsonReader in) throws IOException {
        String s = in.nextString();
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                try {
                    return dateFormat.parse(s);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.parse(s, new ParsePosition(0));
            }
            catch (ParseException e) {
                void var3_5;
                void var1_1;
                void var2_3;
                throw new JsonSyntaxException("Failed parsing '" + (String)var2_3 + "' as Date; at path " + var1_1.getPreviousPath(), (Throwable)var3_5);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        DateFormat defaultFormat = this.dateFormats.get(0);
        if (defaultFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)defaultFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + var1_1.getClass().getSimpleName() + ')';
    }

    public static abstract class DateType<T extends Date> {
        public static final DateType<Date> DATE = new DateType<Date>(Date.class){
            {
                void var1_1;
            }

            @Override
            protected Date deserialize(Date date) {
                return date;
            }
        };
        private final Class<T> dateClass;

        /*
         * WARNING - void declaration
         */
        protected DateType(Class<T> dateClass) {
            void var1_1;
            this.dateClass = var1_1;
        }

        protected abstract T deserialize(Date var1);

        /*
         * WARNING - void declaration
         */
        private TypeAdapterFactory createFactory(DefaultDateTypeAdapter<T> adapter) {
            void var1_1;
            return TypeAdapters.newFactory(this.dateClass, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(String datePattern) {
            void var1_1;
            return this.createFactory(new DefaultDateTypeAdapter(this, (String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(int style) {
            void var1_1;
            return this.createFactory(new DefaultDateTypeAdapter(this, (int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(int dateStyle, int timeStyle) {
            void var2_2;
            void var1_1;
            return this.createFactory(new DefaultDateTypeAdapter(this, (int)var1_1, (int)var2_2));
        }

        public final TypeAdapterFactory createDefaultsAdapterFactory() {
            return this.createFactory(new DefaultDateTypeAdapter(this, 2, 2));
        }
    }
}

