/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            void var2_2;
            void var3_3;
            ArrayTypeAdapter arrayTypeAdapter;
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> componentTypeAdapter = gson.getAdapter(TypeToken.get(componentType));
            arrayTypeAdapter = new ArrayTypeAdapter((Gson)((Object)arrayTypeAdapter), (TypeAdapter<?>)var3_3, $Gson$Types.getRawType((Type)var2_2));
            return arrayTypeAdapter;
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    /*
     * WARNING - void declaration
     */
    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>((Gson)var1_1, var2_2, componentType);
        this.componentType = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object read(JsonReader in) throws IOException {
        void var1_1;
        void var2_2;
        void var3_4;
        Object[] array;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> list = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E instance = this.componentTypeAdapter.read(in);
            list.add(instance);
        }
        in.endArray();
        int size = list.size();
        if (this.componentType.isPrimitive()) {
            array = Array.newInstance(this.componentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        array = (Object[])Array.newInstance(this.componentType, (int)var3_4);
        return var2_2.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Object array) throws IOException {
        void var1_1;
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            this.componentTypeAdapter.write(out, value);
        }
        var1_1.endArray();
    }
}

