/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public final class Streams {
    private Streams() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static JsonElement parse(JsonReader reader) throws JsonParseException {
        boolean isEmpty = true;
        try {
            reader.peek();
            isEmpty = false;
            return TypeAdapters.JSON_ELEMENT.read(reader);
        }
        catch (EOFException e) {
            void var1_5;
            if (var1_5 != false) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(e);
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            void var0_4;
            throw new JsonSyntaxException((Throwable)var0_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void write(JsonElement element, JsonWriter writer) throws IOException {
        JsonElement jsonElement;
        void var1_1;
        TypeAdapters.JSON_ELEMENT.write((JsonWriter)var1_1, jsonElement);
    }

    public static Writer writerForAppendable(Appendable appendable) {
        Appendable appendable2;
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable2);
    }

    private static final class AppendableWriter
    extends Writer {
        private final Appendable appendable;
        private final CurrentWrite currentWrite = new CurrentWrite();

        /*
         * WARNING - void declaration
         */
        AppendableWriter(Appendable appendable) {
            void var1_1;
            this.appendable = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(char[] chars, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.currentWrite.setChars((char[])var1_1);
            void v0 = var2_2;
            this.appendable.append(this.currentWrite, (int)v0, (int)(v0 + var3_3));
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(int i) throws IOException {
            void var1_1;
            this.appendable.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(String str, int off, int len) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            Objects.requireNonNull(str);
            void v0 = var2_2;
            this.appendable.append((CharSequence)var1_1, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Writer append(CharSequence csq) throws IOException {
            void var1_1;
            this.appendable.append((CharSequence)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Writer append(CharSequence csq, int start, int end) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.appendable.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
            return this;
        }

        private static class CurrentWrite
        implements CharSequence {
            private char[] chars;
            private String cachedString;

            private CurrentWrite() {
            }

            /*
             * WARNING - void declaration
             */
            void setChars(char[] chars) {
                void var1_1;
                this.chars = var1_1;
                this.cachedString = null;
            }

            @Override
            public int length() {
                return this.chars.length;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public char charAt(int i) {
                void var1_1;
                return this.chars[var1_1];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public CharSequence subSequence(int start, int end) {
                void var1_1;
                void var2_2;
                return new String(this.chars, start, (int)(var2_2 - var1_1));
            }

            @Override
            public String toString() {
                if (this.cachedString == null) {
                    this.cachedString = new String(this.chars);
                }
                return this.cachedString;
            }
        }
    }
}

