/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ReflectionAccessFilter;
import com.google.gson.internal.JavaVersion;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectionAccessFilterHelper {
    private ReflectionAccessFilterHelper() {
    }

    public static boolean isJavaType(Class<?> c) {
        return ReflectionAccessFilterHelper.isJavaType(c.getName());
    }

    private static boolean isJavaType(String className) {
        String string;
        return className.startsWith("java.") || string.startsWith("javax.");
    }

    public static boolean isAndroidType(Class<?> c) {
        return ReflectionAccessFilterHelper.isAndroidType(c.getName());
    }

    private static boolean isAndroidType(String className) {
        String string;
        return className.startsWith("android.") || className.startsWith("androidx.") || ReflectionAccessFilterHelper.isJavaType(string);
    }

    public static boolean isAnyPlatformType(Class<?> c) {
        String string;
        String className = c.getName();
        return ReflectionAccessFilterHelper.isAndroidType(className) || className.startsWith("kotlin.") || className.startsWith("kotlinx.") || string.startsWith("scala.");
    }

    public static ReflectionAccessFilter.FilterResult getFilterResult(List<ReflectionAccessFilter> reflectionFilters, Class<?> c) {
        for (ReflectionAccessFilter reflectionAccessFilter : reflectionFilters) {
            ReflectionAccessFilter.FilterResult result = reflectionAccessFilter.check(c);
            if (result == ReflectionAccessFilter.FilterResult.INDECISIVE) continue;
            return reflectionAccessFilter;
        }
        return ReflectionAccessFilter.FilterResult.ALLOW;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean canAccess(AccessibleObject accessibleObject, Object object) {
        void var1_1;
        AccessibleObject accessibleObject2;
        return AccessChecker.INSTANCE.canAccess(accessibleObject2, var1_1);
    }

    private static abstract class AccessChecker {
        public static final AccessChecker INSTANCE;

        private AccessChecker() {
        }

        public abstract boolean canAccess(AccessibleObject var1, Object var2);

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            AccessChecker accessChecker = null;
            if (JavaVersion.isJava9OrLater()) {
                try {
                    void var1_1;
                    Method canAccessMethod = AccessibleObject.class.getDeclaredMethod("canAccess", Object.class);
                    accessChecker = new AccessChecker((Method)var1_1){
                        final /* synthetic */ Method val$canAccessMethod;
                        {
                            this.val$canAccessMethod = method;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public boolean canAccess(AccessibleObject accessibleObject, Object object) {
                            try {
                                void var2_3;
                                return (Boolean)this.val$canAccessMethod.invoke((Object)accessibleObject, var2_3);
                            }
                            catch (Exception e) {
                                void var1_2;
                                throw new RuntimeException("Failed invoking canAccess", (Throwable)var1_2);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (accessChecker == null) {
                accessChecker = new AccessChecker(){

                    @Override
                    public boolean canAccess(AccessibleObject accessibleObject, Object object) {
                        return true;
                    }
                };
            }
            INSTANCE = var0;
        }
    }
}

