/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new Comparator<Comparable>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(Comparable a, Comparable b) {
            void var2_2;
            return a.compareTo(var2_2);
        }
    };
    private final Comparator<? super K> comparator;
    private final boolean allowNullValues;
    Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final Node<K, V> header;
    private EntrySet entrySet;
    private KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER, true);
    }

    /*
     * WARNING - void declaration
     */
    public LinkedTreeMap(boolean allowNullValues) {
        this(NATURAL_ORDER, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedTreeMap(Comparator<? super K> comparator, boolean allowNullValues) {
        void var2_2;
        void var1_1;
        this.comparator = comparator != null ? var1_1 : NATURAL_ORDER;
        this.allowNullValues = allowNullValues;
        this.header = new Node((boolean)var2_2);
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        Node<K, V> node = this.findByObject(key);
        if (node != null) {
            void var1_1;
            return var1_1.value;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var1_1;
        return this.findByObject(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, V value) {
        void var3_3;
        void var2_2;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null && !this.allowNullValues) {
            throw new NullPointerException("value == null");
        }
        Node<K, V> created = this.find(key, true);
        Object result = created.value;
        var1_1.value = var2_2;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        void var1_1;
        this.root = null;
        this.size = 0;
        ++this.modCount;
        Node<K, V> header = this.header;
        header.prev = var1_1;
        this.header.next = header.prev;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(Object key) {
        Node<K, V> node = this.removeInternalByKey(key);
        if (node != null) {
            void var1_1;
            return var1_1.value;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final Node<K, V> find(K key, boolean create) {
        Node<Object, V> created;
        void var2_2;
        Comparator<K> comparator = this.comparator;
        Node<K, V> nearest = this.root;
        int comparison = 0;
        if (nearest != null) {
            Comparable comparableKey = comparator == NATURAL_ORDER ? (Comparable)key : null;
            while (true) {
                if ((comparison = comparableKey != null ? comparableKey.compareTo(nearest.key) : comparator.compare(key, nearest.key)) == 0) {
                    return nearest;
                }
                Node child = comparison < 0 ? nearest.left : nearest.right;
                if (child == null) break;
                nearest = child;
            }
        }
        if (var2_2 == false) {
            return null;
        }
        Node<K, V> header = this.header;
        if (nearest == null) {
            void var3_3;
            if (var3_3 == NATURAL_ORDER && !(key instanceof Comparable)) {
                throw new ClassCastException(key.getClass().getName() + " is not Comparable");
            }
            Node<K, V> node = header;
            created = new Node<K, V>(this.allowNullValues, nearest, key, node, node.prev);
            this.root = created;
        } else {
            void var1_1;
            Node<K, V> node = header;
            created = new Node<void, V>(this.allowNullValues, nearest, var1_1, node, node.prev);
            if (comparison < 0) {
                nearest.left = created;
            } else {
                nearest.right = created;
            }
            this.rebalance(nearest, true);
        }
        ++this.size;
        ++this.modCount;
        return created;
    }

    /*
     * WARNING - void declaration
     */
    final Node<K, V> findByObject(Object key) {
        try {
            if (key != null) {
                void var1_1;
                return this.find(var1_1, false);
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    final Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        void var1_1;
        Node<K, V> mine = this.findByObject(entry.getKey());
        boolean bl = mine != null && this.equal(mine.value, var1_1.getValue());
        if (bl) {
            void var2_3;
            return var2_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean equal(Object a, Object b) {
        void var2_2;
        return Objects.equals(a, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void removeInternal(Node<K, V> node, boolean unlink) {
        void var4_6;
        void var2_3;
        if (unlink) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        Node left = node.left;
        Node right = node.right;
        Node originalParent = node.parent;
        if (left != null && right != null) {
            void var2_4;
            Node adjacent = left.height > right.height ? left.last() : right.first();
            this.removeInternal(adjacent, false);
            int leftHeight = 0;
            left = node.left;
            if (left != null) {
                leftHeight = left.height;
                adjacent.left = left;
                left.parent = adjacent;
                node.left = null;
            }
            int rightHeight = 0;
            right = node.right;
            if (right != null) {
                rightHeight = right.height;
                adjacent.right = right;
                right.parent = adjacent;
                node.right = null;
            }
            adjacent.height = Math.max(leftHeight, (int)var2_4) + 1;
            this.replaceInParent(node, adjacent);
            return;
        }
        if (var2_3 != null) {
            this.replaceInParent(node, (Node<K, V>)var2_3);
            node.left = null;
        } else if (right != null) {
            void var3_5;
            this.replaceInParent(node, (Node<K, V>)var3_5);
            node.right = null;
        } else {
            void var1_1;
            this.replaceInParent((Node<K, V>)var1_1, null);
        }
        this.rebalance((Node<K, V>)var4_6, false);
        --this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    final Node<K, V> removeInternalByKey(Object key) {
        void var1_1;
        Node<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void replaceInParent(Node<K, V> node, Node<K, V> replacement) {
        void var2_2;
        Node parent = node.parent;
        node.parent = null;
        if (replacement != null) {
            replacement.parent = parent;
        }
        if (parent != null) {
            void var1_1;
            if (parent.left == node) {
                parent.left = replacement;
                return;
            }
            assert (parent.right == var1_1);
            var3_3.right = replacement;
            return;
        }
        this.root = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void rebalance(Node<K, V> unbalanced, boolean insert) {
        Node<K, V> node = unbalanced;
        while (node != null) {
            void var5_5;
            Node right;
            int rightHeight;
            Node left = node.left;
            int leftHeight = left != null ? left.height : 0;
            int delta = leftHeight - (rightHeight = (right = node.right) != null ? right.height : 0);
            if (delta == -2) {
                Node rightRight;
                int rightRightHeight;
                Node rightLeft22 = right.left;
                int rightLeft22 = rightLeft22 != null ? rightLeft22.height : 0;
                int rightDelta = rightLeft22 - (rightRightHeight = (rightRight = right.right) != null ? rightRight.height : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.rotateLeft(node);
                } else {
                    assert (rightDelta == 1);
                    this.rotateRight(right);
                    this.rotateLeft(node);
                }
                if (insert) break;
            } else if (delta == 2) {
                Node leftRight;
                int leftRightHeight;
                Node leftLeft22 = left.left;
                int leftLeft22 = leftLeft22 != null ? leftLeft22.height : 0;
                int leftDelta = leftLeft22 - (leftRightHeight = (leftRight = left.right) != null ? leftRight.height : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.rotateRight(node);
                } else {
                    void var3_3;
                    assert (leftDelta == -1);
                    this.rotateLeft((Node<K, V>)var3_3);
                    this.rotateRight(node);
                }
                if (insert) break;
            } else if (delta == 0) {
                node.height = var5_5 + true;
                if (insert) {
                    return;
                }
            } else {
                void var6_8;
                assert (delta == -1 || delta == 1);
                node.height = Math.max((int)var5_5, (int)var6_8) + 1;
                if (!insert) break;
            }
            node = node.parent;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rotateLeft(Node<K, V> root) {
        void var1_1;
        void var2_2;
        Node left = root.left;
        Node pivot = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.right = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.left = root;
        root.parent = pivot;
        root.height = Math.max(left != null ? var2_2.height : 0, pivotLeft != null ? pivotLeft.height : 0) + 1;
        var3_3.height = Math.max(var1_1.height, pivotRight != null ? pivotRight.height : 0) + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void rotateRight(Node<K, V> root) {
        void var1_1;
        void var3_3;
        Node pivot = root.left;
        Node right = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.left = pivotRight;
        if (pivotRight != null) {
            pivotRight.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.right = root;
        root.parent = pivot;
        root.height = Math.max(right != null ? var3_3.height : 0, pivotRight != null ? pivotRight.height : 0) + 1;
        var2_2.height = Math.max(var1_1.height, pivotLeft != null ? pivotLeft.height : 0) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        EntrySet result = this.entrySet;
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<K> keySet() {
        KeySet result = this.keySet;
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Deserialization is unsupported");
    }

    final class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ LinkedTreeMap this$0;

        /*
         * WARNING - void declaration
         */
        KeySet(LinkedTreeMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final int size() {
            return this.this$0.size;
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(){
                {
                    void var1_1;
                }

                @Override
                public K next() {
                    return this.nextNode().key;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object key) {
            void var1_1;
            return this.this$0.removeInternalByKey(var1_1) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ LinkedTreeMap this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(LinkedTreeMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public int size() {
            return this.this$0.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(){
                {
                    void var1_1;
                }

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextNode();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return o instanceof Map.Entry && this.this$0.findByEntry((Map.Entry)var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Node node = this.this$0.findByEntry((Map.Entry)o);
            if (node == null) {
                return false;
            }
            this.this$0.removeInternal(var1_1, true);
            return true;
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }
    }

    private abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        Node<K, V> next;
        Node<K, V> lastReturned;
        int expectedModCount;

        LinkedTreeMapIterator() {
            this.next = LinkedTreeMap.this.header.next;
            this.lastReturned = null;
            this.expectedModCount = LinkedTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != LinkedTreeMap.this.header;
        }

        /*
         * WARNING - void declaration
         */
        final Node<K, V> nextNode() {
            void var1_1;
            Node e = this.next;
            if (e == LinkedTreeMap.this.header) {
                throw new NoSuchElementException();
            }
            if (LinkedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = e.next;
            this.lastReturned = var1_1;
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedTreeMap.this.removeInternal(this.lastReturned, true);
            this.lastReturned = null;
            this.expectedModCount = LinkedTreeMap.this.modCount;
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        Node<K, V> next;
        Node<K, V> prev;
        final K key;
        final boolean allowNullValue;
        V value;
        int height;

        /*
         * WARNING - void declaration
         */
        Node(boolean allowNullValue) {
            Node node;
            void var1_1;
            this.key = null;
            this.allowNullValue = var1_1;
            node = node.next = (node.prev = this);
        }

        /*
         * WARNING - void declaration
         */
        Node(boolean allowNullValue, Node<K, V> parent, K key, Node<K, V> next, Node<K, V> prev) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.parent = var2_2;
            this.key = var3_3;
            this.allowNullValue = var1_1;
            this.height = 1;
            this.next = next;
            this.prev = prev;
            prev.next = this;
            next.prev = this;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V value) {
            void var2_2;
            void var1_1;
            if (value == null && !this.allowNullValue) {
                throw new NullPointerException("value == null");
            }
            V oldValue = this.value;
            this.value = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                void var1_1;
                Map.Entry other = (Map.Entry)o;
                return (this.key == null ? other.getKey() == null : this.key.equals(other.getKey())) && (this.value == null ? other.getValue() == null : this.value.equals(var1_1.getValue()));
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final Node<K, V> first() {
            void var1_1;
            Node<K, V> node = this;
            Node<K, V> child = node.left;
            while (child != null) {
                node = child;
                child = node.left;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final Node<K, V> last() {
            void var1_1;
            Node<K, V> node = this;
            Node<K, V> child = node.right;
            while (child != null) {
                node = child;
                child = node.right;
            }
            return var1_1;
        }
    }
}

