/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    public double version = -1.0;
    public int modifiers = 136;
    public boolean serializeInnerClasses = true;
    public boolean requireExpose;
    public List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    public List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    /*
     * WARNING - void declaration
     */
    protected final Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new AssertionError(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Excluder withVersion(double ignoreVersionsAfter) {
        void var3_2;
        void var1_1;
        Excluder result = this.clone();
        this.clone().version = var1_1;
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Excluder withModifiers(int ... modifiers) {
        void var2_2;
        void var1_1;
        Excluder result = this.clone();
        this.clone().modifiers = 0;
        for (void modifier : var1_1) {
            result.modifiers |= modifier;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Excluder disableInnerClassSerialization() {
        void var1_1;
        Excluder result = this.clone();
        this.clone().serializeInnerClasses = false;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Excluder excludeFieldsWithoutExposeAnnotation() {
        void var1_1;
        Excluder result = this.clone();
        this.clone().requireExpose = true;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean serialization, boolean deserialization) {
        void var3_3;
        void var2_2;
        Excluder result = this.clone();
        if (var2_2 != false) {
            result.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            result.serializationStrategies.add(exclusionStrategy);
        }
        if (var3_3 != false) {
            void var1_1;
            result.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            result.deserializationStrategies.add((ExclusionStrategy)var1_1);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        void var2_2;
        void var1_1;
        void var3_4;
        boolean skipDeserialize;
        Class<T> rawType = type.getRawType();
        boolean excludeClass = this.excludeClassChecks(rawType);
        boolean skipSerialize = excludeClass || this.excludeClassInStrategy(rawType, true);
        boolean bl = skipDeserialize = excludeClass || this.excludeClassInStrategy(rawType, false);
        if (!skipSerialize && !skipDeserialize) {
            return null;
        }
        return new TypeAdapter<T>(this, (boolean)var3_4, skipSerialize, (Gson)var1_1, (TypeToken)var2_2){
            private TypeAdapter<T> delegate;
            final /* synthetic */ boolean val$skipDeserialize;
            final /* synthetic */ boolean val$skipSerialize;
            final /* synthetic */ Gson val$gson;
            final /* synthetic */ TypeToken val$type;
            final /* synthetic */ Excluder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$skipDeserialize = bl;
                this.val$skipSerialize = bl2;
                this.val$gson = gson;
                this.val$type = typeToken;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public T read(JsonReader in) throws IOException {
                void var1_1;
                if (this.val$skipDeserialize) {
                    in.skipValue();
                    return null;
                }
                return this.delegate().read((JsonReader)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, T value) throws IOException {
                void var2_2;
                void var1_1;
                if (this.val$skipSerialize) {
                    out.nullValue();
                    return;
                }
                this.delegate().write((JsonWriter)var1_1, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            private TypeAdapter<T> delegate() {
                TypeAdapter d = this.delegate;
                if (d != null) {
                    void var1_1;
                    return var1_1;
                }
                this.delegate = this.val$gson.getDelegateAdapter(this.this$0, this.val$type);
                return this.delegate;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final boolean excludeField(Field field, boolean serialize) {
        void var2_2;
        Expose annotation;
        if ((this.modifiers & field.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field.getAnnotation(Since.class), field.getAnnotation(Until.class))) {
            return true;
        }
        if (field.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((annotation = field.getAnnotation(Expose.class)) == null || (serialize ? !annotation.serialize() : !annotation.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(field.getType())) {
            return true;
        }
        if (this.isAnonymousOrNonStaticLocal(field.getType())) {
            return true;
        }
        List<ExclusionStrategy> list = var2_2 != false ? this.serializationStrategies : this.deserializationStrategies;
        if (!list.isEmpty()) {
            ExclusionStrategy exclusionStrategy;
            FieldAttributes fieldAttributes = new FieldAttributes(field);
            Iterator iterator = exclusionStrategy.iterator();
            while (iterator.hasNext()) {
                exclusionStrategy = (ExclusionStrategy)iterator.next();
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean excludeClassChecks(Class<?> clazz) {
        void var1_1;
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        return this.isAnonymousOrNonStaticLocal((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean excludeClass(Class<?> clazz, boolean serialize) {
        void var2_2;
        void var1_1;
        return this.excludeClassChecks(clazz) || this.excludeClassInStrategy((Class<?>)var1_1, (boolean)var2_2);
    }

    private boolean excludeClassInStrategy(Class<?> clazz, boolean serialize) {
        Object object = serialize ? this.serializationStrategies : this.deserializationStrategies;
        object = object.iterator();
        while (object.hasNext()) {
            ExclusionStrategy exclusionStrategy = (ExclusionStrategy)object.next();
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        void var1_1;
        return !Enum.class.isAssignableFrom(clazz) && !this.isStatic(clazz) && (clazz.isAnonymousClass() || var1_1.isLocalClass());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInnerClass(Class<?> clazz) {
        void var1_1;
        return clazz.isMemberClass() && !this.isStatic((Class<?>)var1_1);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidVersion(Since since, Until until) {
        void var2_2;
        void var1_1;
        return this.isValidSince((Since)var1_1) && this.isValidUntil((Until)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidSince(Since annotation) {
        if (annotation != null) {
            void var2_2;
            void var1_1;
            double annotationVersion = var1_1.value();
            return this.version >= var2_2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidUntil(Until annotation) {
        if (annotation != null) {
            void var2_2;
            void var1_1;
            double annotationVersion = var1_1.value();
            return this.version < var2_2;
        }
        return true;
    }
}

