/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;
    private final boolean useJdkUnsafe;
    private final List<ReflectionAccessFilter> reflectionFilters;

    /*
     * WARNING - void declaration
     */
    public ConstructorConstructor(Map<Type, InstanceCreator<?>> instanceCreators, boolean useJdkUnsafe, List<ReflectionAccessFilter> reflectionFilters) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instanceCreators = var1_1;
        this.useJdkUnsafe = var2_2;
        this.reflectionFilters = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static String checkInstantiable(Class<?> c) {
        void var1_1;
        int modifiers = c.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            return "Interfaces can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Interface name: " + c.getName();
        }
        if (Modifier.isAbstract((int)var1_1)) {
            Class<?> clazz;
            return "Abstract classes can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Class name: " + clazz.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        void var1_1;
        void var3_3;
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        InstanceCreator<?> typeCreator = this.instanceCreators.get(type);
        if (typeCreator != null) {
            return new ObjectConstructor<T>(this, typeCreator, type){
                final /* synthetic */ InstanceCreator val$typeCreator;
                final /* synthetic */ Type val$type;
                final /* synthetic */ ConstructorConstructor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$typeCreator = instanceCreator;
                    this.val$type = type;
                }

                @Override
                public T construct() {
                    return this.val$typeCreator.createInstance(this.val$type);
                }
            };
        }
        InstanceCreator<?> rawTypeCreator = this.instanceCreators.get(rawType);
        if (rawTypeCreator != null) {
            return new ObjectConstructor<T>(this, rawTypeCreator, type){
                final /* synthetic */ InstanceCreator val$rawTypeCreator;
                final /* synthetic */ Type val$type;
                final /* synthetic */ ConstructorConstructor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$rawTypeCreator = instanceCreator;
                    this.val$type = type;
                }

                @Override
                public T construct() {
                    return this.val$rawTypeCreator.createInstance(this.val$type);
                }
            };
        }
        ObjectConstructor<T> specialConstructor = ConstructorConstructor.newSpecialCollectionConstructor(type, rawType);
        if (specialConstructor != null) {
            return specialConstructor;
        }
        ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, rawType);
        ObjectConstructor<T> defaultConstructor = ConstructorConstructor.newDefaultConstructor(rawType, filterResult);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ObjectConstructor<T> defaultImplementation = ConstructorConstructor.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        String exceptionMessage = ConstructorConstructor.checkInstantiable(rawType);
        if (exceptionMessage != null) {
            void var2_2;
            return new ObjectConstructor<T>(this, (String)var2_2){
                final /* synthetic */ String val$exceptionMessage;
                final /* synthetic */ ConstructorConstructor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$exceptionMessage = string;
                }

                @Override
                public T construct() {
                    throw new JsonIOException(this.val$exceptionMessage);
                }
            };
        }
        if (var3_3 == ReflectionAccessFilter.FilterResult.ALLOW) {
            return this.newUnsafeAllocator(rawType);
        }
        String message = "Unable to create instance of " + rawType + "; ReflectionAccessFilter does not permit using reflection or Unsafe. Register an InstanceCreator or a TypeAdapter for this type or adjust the access filter to allow using reflection.";
        return new ObjectConstructor<T>(this, (String)var1_1){
            final /* synthetic */ String val$message;
            final /* synthetic */ ConstructorConstructor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$message = string;
            }

            @Override
            public T construct() {
                throw new JsonIOException(this.val$message);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static <T> ObjectConstructor<T> newSpecialCollectionConstructor(final Type type, Class<? super T> rawType) {
        void var1_1;
        if (EnumSet.class.isAssignableFrom(rawType)) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    if (type instanceof ParameterizedType) {
                        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                        if (elementType instanceof Class) {
                            EnumSet enumSet;
                            enumSet = EnumSet.noneOf((Class)((Object)enumSet));
                            return enumSet;
                        }
                        throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                    }
                    throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                }
            };
        }
        if (var1_1 == EnumMap.class) {
            Type type2;
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    if (type2 instanceof ParameterizedType) {
                        Type elementType = ((ParameterizedType)type2).getActualTypeArguments()[0];
                        if (elementType instanceof Class) {
                            EnumMap enumMap;
                            enumMap = new EnumMap((Class)((Object)enumMap));
                            return enumMap;
                        }
                        throw new JsonIOException("Invalid EnumMap type: " + type2.toString());
                    }
                    throw new JsonIOException("Invalid EnumMap type: " + type2.toString());
                }
            };
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> rawType, ReflectionAccessFilter.FilterResult filterResult) {
        void var2_2;
        String exceptionMessage;
        void var1_1;
        Constructor<T> constructor;
        if (Modifier.isAbstract(rawType.getModifiers())) {
            return null;
        }
        try {
            constructor = rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        boolean bl = filterResult == ReflectionAccessFilter.FilterResult.ALLOW || ReflectionAccessFilterHelper.canAccess(constructor, null) && (filterResult != ReflectionAccessFilter.FilterResult.BLOCK_ALL || Modifier.isPublic(constructor.getModifiers()));
        if (!bl) {
            final String message = "Unable to invoke no-args constructor of " + rawType + "; constructor is not accessible and ReflectionAccessFilter does not permit making it accessible. Register an InstanceCreator or a TypeAdapter for this type, change the visibility of the constructor or adjust the access filter.";
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    throw new JsonIOException(message);
                }
            };
        }
        if (var1_1 == ReflectionAccessFilter.FilterResult.ALLOW && (exceptionMessage = ReflectionHelper.tryMakeAccessible(constructor)) != null) {
            String string;
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    throw new JsonIOException(string);
                }
            };
        }
        return new ObjectConstructor<T>((Constructor)var2_2){
            final /* synthetic */ Constructor val$constructor;
            {
                this.val$constructor = constructor;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public T construct() {
                try {
                    Object t = this.val$constructor.newInstance(new Object[0]);
                    return t;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.val$constructor) + "' with no args", e);
                }
                catch (InvocationTargetException e) {
                    void var1_3;
                    throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.val$constructor) + "' with no args", var1_3.getCause());
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static <T> ObjectConstructor<T> newDefaultImplementationConstructor(Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ArrayDeque();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type type2;
            void var1_1;
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentSkipListMap();
                    }
                };
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentHashMap();
                    }
                };
            }
            if (SortedMap.class.isAssignableFrom((Class<?>)var1_1)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type2).getActualTypeArguments()[0]).getRawType())) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private <T> ObjectConstructor<T> newUnsafeAllocator(Class<? super T> rawType) {
        void var1_1;
        if (this.useJdkUnsafe) {
            return new ObjectConstructor<T>(this, rawType){
                final /* synthetic */ Class val$rawType;
                final /* synthetic */ ConstructorConstructor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$rawType = clazz;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public T construct() {
                    try {
                        Object t = UnsafeAllocator.INSTANCE.newInstance(this.val$rawType);
                        return t;
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new RuntimeException("Unable to create instance of " + this.val$rawType + ". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.", (Throwable)var1_2);
                    }
                }
            };
        }
        String exceptionMessage = "Unable to create instance of " + rawType + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        return new ObjectConstructor<T>(this, (String)var1_1){
            final /* synthetic */ String val$exceptionMessage;
            final /* synthetic */ ConstructorConstructor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$exceptionMessage = string;
            }

            @Override
            public T construct() {
                throw new JsonIOException(this.val$exceptionMessage);
            }
        };
    }

    public final String toString() {
        return this.instanceCreators.toString();
    }
}

