/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        void var2_2;
        void var1_1;
        Type type;
        return new ParameterizedTypeImpl(type, (Type)var1_1, (Type[])var2_2);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        Type type;
        return new GenericArrayTypeImpl(type);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] typeArray;
        Type[] upperBounds;
        upperBounds = bound instanceof WildcardType ? ((WildcardType)bound).getUpperBounds() : new Type[]{upperBounds};
        return new WildcardTypeImpl(typeArray, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] typeArray;
        Type[] lowerBounds;
        lowerBounds = bound instanceof WildcardType ? ((WildcardType)bound).getLowerBounds() : new Type[]{lowerBounds};
        return new WildcardTypeImpl(new Type[]{Object.class}, typeArray);
    }

    public static Type canonicalize(Type type) {
        Type type2;
        Type g;
        Type p;
        Type c;
        if (type instanceof Class) {
            c = (Class)type;
            return ((Class)c).isArray() ? new GenericArrayTypeImpl($Gson$Types.canonicalize(((Class)c).getComponentType())) : c;
        }
        if (c instanceof ParameterizedType) {
            p = (ParameterizedType)c;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (p instanceof GenericArrayType) {
            g = (GenericArrayType)p;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (g instanceof WildcardType) {
            Type w = (WildcardType)g;
            return new WildcardTypeImpl(w.getUpperBounds(), type2.getLowerBounds());
        }
        return type2;
    }

    public static Class<?> getRawType(Type type) {
        Type type2;
        Type type3;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                type3 = (ParameterizedType)type;
                Type rawType = type3.getRawType();
                $Gson$Preconditions.checkArgument(rawType instanceof Class);
                return (Class)type2;
            }
            if (type2 instanceof GenericArrayType) {
                type3 = ((GenericArrayType)type2).getGenericComponentType();
                return Array.newInstance($Gson$Types.getRawType(type3), 0).getClass();
            }
            if (type2 instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type2 instanceof WildcardType)) break;
            Type[] bounds = ((WildcardType)type2).getUpperBounds();
            assert (bounds.length == 1);
            type2 = bounds[0];
        }
        String className = type2 == null ? "null" : type2.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type2 + "> is of type " + (String)((Object)type3));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equal(Object a, Object b) {
        void var1_1;
        return Objects.equals(a, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Type a, Type b) {
        WildcardType wb;
        Type wa;
        Type gb;
        Type ga;
        while (true) {
            ParameterizedType pb;
            Type pa;
            if (a == b) {
                return true;
            }
            if (a instanceof Class) {
                return a.equals(b);
            }
            if (a instanceof ParameterizedType) {
                if (!(b instanceof ParameterizedType)) {
                    return false;
                }
                pa = (ParameterizedType)a;
                pb = (ParameterizedType)b;
                return $Gson$Types.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
            }
            if (!(pa instanceof GenericArrayType)) break;
            if (!(pb instanceof GenericArrayType)) {
                return false;
            }
            ga = (GenericArrayType)pa;
            gb = (GenericArrayType)((Object)pb);
            gb = gb.getGenericComponentType();
            ga = ga.getGenericComponentType();
        }
        if (ga instanceof WildcardType) {
            if (!(gb instanceof WildcardType)) {
                return false;
            }
            wa = (WildcardType)ga;
            wb = (WildcardType)gb;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (wa instanceof TypeVariable) {
            void var1_1;
            Type type;
            if (!(wb instanceof TypeVariable)) {
                return false;
            }
            Type va = (TypeVariable)wa;
            TypeVariable vb = (TypeVariable)((Object)wb);
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && type.getName().equals(var1_1.getName());
        }
        return false;
    }

    public static String typeToString(Type type) {
        Type type2;
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> supertype) {
        void var2_2;
        block0: while (true) {
            if (supertype == rawType) {
                return context;
            }
            if (supertype.isInterface()) {
                Object interfaces = ((Class)rawType).getInterfaces();
                int length = ((Class<?>[])interfaces).length;
                for (int i = 0; i < length; ++i) {
                    if (interfaces[i] == supertype) {
                        return ((Class)rawType).getGenericInterfaces()[i];
                    }
                    if (!supertype.isAssignableFrom(interfaces[i])) continue;
                    Type type = ((Class)rawType).getGenericInterfaces()[i];
                    rawType = interfaces[i];
                    interfaces = type;
                    continue block0;
                }
            }
            if (((Class)rawType).isInterface()) break;
            while (rawType != Object.class) {
                Object object;
                Object rawSupertype = ((Class)rawType).getSuperclass();
                if (rawSupertype == supertype) {
                    return ((Class)rawType).getGenericSuperclass();
                }
                if (supertype.isAssignableFrom((Class<?>)rawSupertype)) {
                    Type type = ((Class)rawType).getGenericSuperclass();
                    rawType = rawSupertype;
                    rawSupertype = type;
                    continue block0;
                }
                rawType = object;
            }
            break;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        void var2_2;
        void var1_1;
        Object object;
        if (context instanceof WildcardType) {
            Object bounds = ((WildcardType)context).getUpperBounds();
            assert (((Type[])bounds).length == 1);
            object = object[0];
        }
        $Gson$Preconditions.checkArgument(supertype.isAssignableFrom(contextRawType));
        return $Gson$Types.resolve((Type)object, contextRawType, $Gson$Types.getGenericSupertype((Type)object, var1_1, var2_2));
    }

    public static Type getArrayComponentType(Type array) {
        Type type;
        if (array instanceof GenericArrayType) {
            return ((GenericArrayType)array).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    /*
     * WARNING - void declaration
     */
    public static Type getCollectionElementType(Type context, Class<?> contextRawType) {
        void var1_1;
        Type collectionType = $Gson$Types.getSupertype(context, var1_1, Collection.class);
        if (collectionType instanceof ParameterizedType) {
            Type type;
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] getMapKeyAndValueTypes(Type context, Class<?> contextRawType) {
        void var1_1;
        if (context == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        Type mapType = $Gson$Types.getSupertype(context, var1_1, Map.class);
        if (mapType instanceof ParameterizedType) {
            Type type;
            type = (ParameterizedType)type;
            return type.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    /*
     * WARNING - void declaration
     */
    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        void var2_2;
        void var1_1;
        return $Gson$Types.resolve(context, var1_1, (Type)var2_2, new HashMap());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Map<TypeVariable<?>, Type> visitedTypeVariables) {
        block10: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            resolving = null;
                            while (toResolve instanceof TypeVariable) {
                                typeVariable = (TypeVariable)toResolve;
                                previouslyResolved = visitedTypeVariables.get(typeVariable);
                                if (previouslyResolved != null) {
                                    if (previouslyResolved == Void.TYPE) {
                                        return toResolve;
                                    }
                                    return previouslyResolved;
                                }
                                visitedTypeVariables.put(typeVariable, Void.TYPE);
                                if (resolving == null) {
                                    resolving = typeVariable;
                                }
                                if ((toResolve = $Gson$Types.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) {
                                    continue;
                                }
                                break block10;
                            }
                            if (!(toResolve instanceof Class) || !((Class)toResolve).isArray()) break block11;
                            original = (Class)toResolve;
                            componentType = original.getComponentType();
                            newComponentType = $Gson$Types.equal(componentType, newComponentType = $Gson$Types.resolve(context, contextRawType, componentType, visitedTypeVariables)) != false ? original : $Gson$Types.arrayOf(newComponentType);
                            break block10;
                        }
                        if (!(newComponentType instanceof GenericArrayType)) break block12;
                        original = (GenericArrayType)newComponentType;
                        componentType = original.getGenericComponentType();
                        newComponentType = $Gson$Types.equal(componentType, newComponentType = $Gson$Types.resolve(context, contextRawType, componentType, visitedTypeVariables)) != false ? original : $Gson$Types.arrayOf(newComponentType);
                        break block10;
                    }
                    if (!(newComponentType instanceof ParameterizedType)) break block13;
                    original = (ParameterizedType)newComponentType;
                    ownerType = original.getOwnerType();
                    newOwnerType = $Gson$Types.resolve(context, contextRawType, ownerType, visitedTypeVariables);
                    changed = $Gson$Types.equal(newOwnerType, ownerType) == false;
                    args = original.getActualTypeArguments();
                    length = args.length;
                    for (t = 0; t < length; ++t) {
                        resolvedTypeArgument = $Gson$Types.resolve(context, contextRawType, args[t], visitedTypeVariables);
                        if ($Gson$Types.equal(resolvedTypeArgument, args[t])) continue;
                        if (!changed) {
                            args = (Type[])args.clone();
                            changed = true;
                        }
                        args[t] = resolvedTypeArgument;
                    }
                    newOwnerType = changed != false ? $Gson$Types.newParameterizedTypeWithOwner(newOwnerType, original.getRawType(), args) : original;
                    break block10;
                }
                if (!(newOwnerType instanceof WildcardType)) break block10;
                original = (WildcardType)newOwnerType;
                originalLowerBound = original.getLowerBounds();
                originalUpperBound /* !! */  = original.getUpperBounds();
                if (originalLowerBound.length != 1) break block14;
                lowerBound = $Gson$Types.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                if (lowerBound == originalLowerBound[0]) ** GOTO lbl-1000
                originalUpperBound /* !! */  = $Gson$Types.supertypeOf(lowerBound);
                break block10;
            }
            if (originalUpperBound /* !! */ .length == 1 && (upperBound = $Gson$Types.resolve(var0, var1_1, originalUpperBound /* !! */ [0], visitedTypeVariables)) != var2_2[0]) {
                var2_2 = $Gson$Types.subtypeOf(upperBound);
            } else lbl-1000:
            // 2 sources

            {
                var2_2 = original;
            }
        }
        if (resolving != null) {
            var3_3.put(resolving, var2_2);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        void var2_3;
        Class<?> declaredByRaw = $Gson$Types.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = $Gson$Types.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            void var1_2;
            Type type;
            void var3_4;
            int index = $Gson$Types.indexOf(var3_4.getTypeParameters(), unknown);
            return ((ParameterizedType)type).getActualTypeArguments()[var1_2];
        }
        return var2_3;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        TypeVariable<?> genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            TypeVariable<?> typeVariable2;
            return (Class)((Object)typeVariable2);
        }
        return null;
    }

    static void checkNotPrimitive(Type type) {
        Type type2;
        $Gson$Preconditions.checkArgument(!(type instanceof Class) || !((Class)type2).isPrimitive());
    }

    private static final class WildcardTypeImpl
    implements Serializable,
    WildcardType {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            void var1_1;
            $Gson$Preconditions.checkArgument(lowerBounds.length <= 1);
            $Gson$Preconditions.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                void var2_2;
                Objects.requireNonNull(lowerBounds[0]);
                $Gson$Types.checkNotPrimitive(lowerBounds[0]);
                $Gson$Preconditions.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = $Gson$Types.canonicalize((Type)var2_2[0]);
                this.upperBound = Object.class;
                return;
            }
            Objects.requireNonNull(upperBounds[0]);
            $Gson$Types.checkNotPrimitive(upperBounds[0]);
            this.lowerBound = null;
            this.upperBound = $Gson$Types.canonicalize((Type)var1_1[0]);
        }

        @Override
        public final Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public final Type[] getLowerBounds() {
            if (this.lowerBound != null) {
                return new Type[]{this.lowerBound};
            }
            return EMPTY_TYPE_ARRAY;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)var1_1);
        }

        public final int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public final String toString() {
            if (this.lowerBound != null) {
                return "? super " + $Gson$Types.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + $Gson$Types.typeToString(this.upperBound);
        }
    }

    private static final class GenericArrayTypeImpl
    implements Serializable,
    GenericArrayType {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public GenericArrayTypeImpl(Type componentType) {
            void var1_1;
            Objects.requireNonNull(componentType);
            this.componentType = $Gson$Types.canonicalize((Type)var1_1);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            return o instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)var1_1);
        }

        public final int hashCode() {
            return this.componentType.hashCode();
        }

        public final String toString() {
            return $Gson$Types.typeToString(this.componentType) + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements Serializable,
    ParameterizedType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            Objects.requireNonNull(rawType);
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                boolean isStaticOrTopLevelClass = Modifier.isStatic(rawTypeAsClass.getModifiers()) || rawTypeAsClass.getEnclosingClass() == null;
                $Gson$Preconditions.checkArgument(ownerType != null || isStaticOrTopLevelClass);
            }
            this.ownerType = ownerType == null ? null : $Gson$Types.canonicalize((Type)var1_1);
            this.rawType = $Gson$Types.canonicalize((Type)var2_2);
            this.typeArguments = (Type[])var3_3.clone();
            int length = this.typeArguments.length;
            for (int t = 0; t < length; ++t) {
                Objects.requireNonNull(this.typeArguments[t]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = $Gson$Types.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getRawType() {
            return this.rawType;
        }

        @Override
        public final Type getOwnerType() {
            return this.ownerType;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)var1_1);
        }

        private static int hashCodeOrZero(Object o) {
            if (o != null) {
                Object object;
                return object.hashCode();
            }
            return 0;
        }

        public final int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var2_2;
            int length = this.typeArguments.length;
            if (length == 0) {
                return $Gson$Types.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
            stringBuilder.append($Gson$Types.typeToString(this.rawType)).append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
            for (int i = 1; i < length; ++i) {
                stringBuilder.append(", ").append($Gson$Types.typeToString(this.typeArguments[i]));
            }
            return var2_2.append(">").toString();
        }
    }
}

