/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public final Double readNumber(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        /*
         * WARNING - void declaration
         */
        @Override
        public final Number readNumber(JsonReader in) throws IOException {
            void var1_1;
            return new LazilyParsedNumber(var1_1.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        /*
         * WARNING - void declaration
         */
        @Override
        public final Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value = in.nextString();
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double d = Double.valueOf(value);
                    if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + in.getPreviousPath());
                    }
                    return d;
                }
                catch (NumberFormatException doubleE) {
                    void var3_4;
                    void var1_1;
                    void var2_2;
                    throw new JsonParseException("Cannot parse " + (String)var2_2 + "; at path " + var1_1.getPreviousPath(), (Throwable)var3_4);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        /*
         * WARNING - void declaration
         */
        @Override
        public final BigDecimal readNumber(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                void var3_3;
                void var1_1;
                void var2_2;
                throw new JsonParseException("Cannot parse " + (String)var2_2 + "; at path " + var1_1.getPreviousPath(), (Throwable)var3_3);
            }
        }
    };

}

