/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    /*
     * WARNING - void declaration
     */
    public JsonStreamParser(String json) {
        this(new StringReader((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JsonStreamParser(Reader reader) {
        void var1_1;
        this.parser = new JsonReader((Reader)var1_1);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (OutOfMemoryError e) {
            void var1_2;
            throw new JsonParseException("Failed parsing JSON source to Json", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                void var2_3;
                throw new JsonIOException((Throwable)var2_3);
            }
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

