/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class JsonPrimitive
extends JsonElement {
    private final Object value;

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Boolean bool) {
        void var1_1;
        this.value = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Number number) {
        void var1_1;
        this.value = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(String string) {
        void var1_1;
        this.value = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Character c) {
        void var1_1;
        this.value = ((Character)Objects.requireNonNull(var1_1)).toString();
    }

    @Override
    public final JsonPrimitive deepCopy() {
        return this;
    }

    public final boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public final boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(((JsonElement)this).getAsString());
    }

    public final boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public final Number getAsNumber() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        if (this.value instanceof String) {
            return new LazilyParsedNumber((String)this.value);
        }
        throw new UnsupportedOperationException("Primitive is neither a number nor a string");
    }

    public final boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public final String getAsString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.value).toString();
        }
        throw new AssertionError((Object)("Unexpected value type: " + this.value.getClass()));
    }

    @Override
    public final double getAsDouble() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().doubleValue();
        }
        return Double.parseDouble(((JsonElement)this).getAsString());
    }

    @Override
    public final BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(((JsonElement)this).getAsString());
    }

    @Override
    public final BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(((JsonElement)this).getAsString());
    }

    @Override
    public final float getAsFloat() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().floatValue();
        }
        return Float.parseFloat(((JsonElement)this).getAsString());
    }

    @Override
    public final long getAsLong() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().longValue();
        }
        return Long.parseLong(((JsonElement)this).getAsString());
    }

    @Override
    public final short getAsShort() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().shortValue();
        }
        return Short.parseShort(((JsonElement)this).getAsString());
    }

    @Override
    public final int getAsInt() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().intValue();
        }
        return Integer.parseInt(((JsonElement)this).getAsString());
    }

    @Override
    public final byte getAsByte() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().byteValue();
        }
        return Byte.parseByte(((JsonElement)this).getAsString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final char getAsCharacter() {
        void var1_1;
        String s = ((JsonElement)this).getAsString();
        if (s.isEmpty()) {
            throw new UnsupportedOperationException("String value is empty");
        }
        return var1_1.charAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long value = ((JsonElement)this).getAsNumber().longValue();
            return (int)(value ^ value >>> 32);
        }
        if (this.value instanceof Number) {
            void var1_2;
            long value = Double.doubleToLongBits(((JsonElement)this).getAsNumber().doubleValue());
            return (int)(value ^ var1_2 >>> 32);
        }
        return this.value.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPrimitive other = (JsonPrimitive)obj;
        if (this.value == null) {
            return other.value == null;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral(other)) {
            return ((JsonElement)this).getAsNumber().longValue() == ((JsonElement)other).getAsNumber().longValue();
        }
        if (this.value instanceof Number && other.value instanceof Number) {
            void var3_2;
            double b;
            double a = ((JsonElement)this).getAsNumber().doubleValue();
            return a == (b = ((JsonElement)other).getAsNumber().doubleValue()) || Double.isNaN((double)var3_2) && Double.isNaN(b);
        }
        return this.value.equals(var1_1.value);
    }

    private static boolean isIntegral(JsonPrimitive primitive) {
        if (primitive.value instanceof Number) {
            Number number;
            Number number2 = (Number)primitive.value;
            return number2 instanceof BigInteger || number2 instanceof Long || number2 instanceof Integer || number2 instanceof Short || number instanceof Byte;
        }
        return false;
    }
}

