/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json) throws JsonSyntaxException {
        String string;
        return JsonParser.parseReader(new StringReader(string));
    }

    /*
     * WARNING - void declaration
     */
    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            void var1_4;
            Closeable jsonReader = new JsonReader(reader);
            JsonElement element = JsonParser.parseReader((JsonReader)jsonReader);
            if (!element.isJsonNull() && ((JsonReader)jsonReader).peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return var1_4;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            void var0_3;
            throw new JsonSyntaxException((Throwable)var0_3);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        boolean lenient = reader.isLenient();
        reader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(reader);
            reader.setLenient(lenient);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            try {
                throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", e);
                catch (OutOfMemoryError e2) {
                    void var2_4;
                    throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)var2_4);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                JsonReader jsonReader;
                jsonReader.setLenient((boolean)var1_1);
                throw throwable;
            }
        }
    }

    @Deprecated
    public final JsonElement parse(String json) throws JsonSyntaxException {
        return JsonParser.parseString(json);
    }

    @Deprecated
    public final JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }

    @Deprecated
    public final JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json);
    }
}

