/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.NonNullElementWrapperList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JsonArray
extends JsonElement
implements Iterable<JsonElement> {
    private final ArrayList<JsonElement> elements;

    public JsonArray() {
        this.elements = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    public JsonArray(int capacity) {
        void var1_1;
        this.elements = new ArrayList((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JsonArray deepCopy() {
        if (!this.elements.isEmpty()) {
            void var1_1;
            JsonArray result = new JsonArray(this.elements.size());
            for (JsonElement element : this.elements) {
                void var3_3;
                result.add(var3_3.deepCopy());
            }
            return var1_1;
        }
        return new JsonArray();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Boolean bool) {
        void var1_1;
        this.elements.add(bool == null ? JsonNull.INSTANCE : new JsonPrimitive((Boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Character character) {
        void var1_1;
        this.elements.add(character == null ? JsonNull.INSTANCE : new JsonPrimitive((Character)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Number number) {
        void var1_1;
        this.elements.add(number == null ? JsonNull.INSTANCE : new JsonPrimitive((Number)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(String string) {
        void var1_1;
        this.elements.add(string == null ? JsonNull.INSTANCE : new JsonPrimitive((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(JsonElement element) {
        void var1_1;
        if (element == null) {
            element = JsonNull.INSTANCE;
        }
        this.elements.add((JsonElement)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(JsonArray array) {
        void var1_1;
        this.elements.addAll(var1_1.elements);
    }

    /*
     * WARNING - void declaration
     */
    public final JsonElement set(int index, JsonElement element) {
        void var2_2;
        void var1_1;
        return this.elements.set((int)var1_1, (JsonElement)(element == null ? JsonNull.INSTANCE : var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(JsonElement element) {
        void var1_1;
        return this.elements.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final JsonElement remove(int index) {
        void var1_1;
        return this.elements.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(JsonElement element) {
        void var1_1;
        return this.elements.contains(var1_1);
    }

    public final int size() {
        return this.elements.size();
    }

    public final boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public final Iterator<JsonElement> iterator() {
        return this.elements.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final JsonElement get(int i) {
        void var1_1;
        return this.elements.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private JsonElement getAsSingleElement() {
        void var1_1;
        int size = this.elements.size();
        if (size == 1) {
            return this.elements.get(0);
        }
        throw new IllegalStateException("Array must have size 1, but has size " + (int)var1_1);
    }

    @Override
    public final Number getAsNumber() {
        return this.getAsSingleElement().getAsNumber();
    }

    @Override
    public final String getAsString() {
        return this.getAsSingleElement().getAsString();
    }

    @Override
    public final double getAsDouble() {
        return this.getAsSingleElement().getAsDouble();
    }

    @Override
    public final BigDecimal getAsBigDecimal() {
        return this.getAsSingleElement().getAsBigDecimal();
    }

    @Override
    public final BigInteger getAsBigInteger() {
        return this.getAsSingleElement().getAsBigInteger();
    }

    @Override
    public final float getAsFloat() {
        return this.getAsSingleElement().getAsFloat();
    }

    @Override
    public final long getAsLong() {
        return this.getAsSingleElement().getAsLong();
    }

    @Override
    public final int getAsInt() {
        return this.getAsSingleElement().getAsInt();
    }

    @Override
    public final byte getAsByte() {
        return this.getAsSingleElement().getAsByte();
    }

    @Override
    @Deprecated
    public final char getAsCharacter() {
        return this.getAsSingleElement().getAsCharacter();
    }

    @Override
    public final short getAsShort() {
        return this.getAsSingleElement().getAsShort();
    }

    @Override
    public final boolean getAsBoolean() {
        return this.getAsSingleElement().getAsBoolean();
    }

    public final List<JsonElement> asList() {
        return new NonNullElementWrapperList<JsonElement>(this.elements);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        return o == this || o instanceof JsonArray && ((JsonArray)var1_1).elements.equals(this.elements);
    }

    public final int hashCode() {
        return this.elements.hashCode();
    }
}

