/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.bind.DefaultDateTypeAdapter;
import com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.sql.SqlTypesSupport;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>();
    private boolean serializeNulls = false;
    private String datePattern = Gson.DEFAULT_DATE_PATTERN;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization = false;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private boolean prettyPrinting = false;
    private boolean generateNonExecutableJson = false;
    private boolean lenient = false;
    private boolean useJdkUnsafe = true;
    private ToNumberStrategy objectToNumberStrategy = Gson.DEFAULT_OBJECT_TO_NUMBER_STRATEGY;
    private ToNumberStrategy numberToNumberStrategy = Gson.DEFAULT_NUMBER_TO_NUMBER_STRATEGY;
    private final LinkedList<ReflectionAccessFilter> reflectionFilters = new LinkedList();

    public GsonBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    GsonBuilder(Gson gson) {
        void var1_1;
        this.excluder = gson.excluder;
        this.fieldNamingPolicy = gson.fieldNamingStrategy;
        this.instanceCreators.putAll(gson.instanceCreators);
        this.serializeNulls = gson.serializeNulls;
        this.complexMapKeySerialization = gson.complexMapKeySerialization;
        this.generateNonExecutableJson = gson.generateNonExecutableJson;
        this.escapeHtmlChars = gson.htmlSafe;
        this.prettyPrinting = gson.prettyPrinting;
        this.lenient = gson.lenient;
        this.serializeSpecialFloatingPointValues = gson.serializeSpecialFloatingPointValues;
        this.longSerializationPolicy = gson.longSerializationPolicy;
        this.datePattern = gson.datePattern;
        this.dateStyle = gson.dateStyle;
        this.timeStyle = gson.timeStyle;
        this.factories.addAll(gson.builderFactories);
        this.hierarchyFactories.addAll(gson.builderHierarchyFactories);
        this.useJdkUnsafe = gson.useJdkUnsafe;
        this.objectToNumberStrategy = gson.objectToNumberStrategy;
        this.numberToNumberStrategy = gson.numberToNumberStrategy;
        this.reflectionFilters.addAll(var1_1.reflectionFilters);
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setVersion(double version) {
        void var1_1;
        if (Double.isNaN(version) || version < 0.0) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        this.excluder = this.excluder.withVersion((double)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder excludeFieldsWithModifiers(int ... modifiers) {
        void var1_1;
        Objects.requireNonNull(modifiers);
        this.excluder = this.excluder.withModifiers((int[])var1_1);
        return this;
    }

    public final GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    public final GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    public final GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public final GsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    public final GsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setLongSerializationPolicy(LongSerializationPolicy serializationPolicy) {
        void var1_1;
        this.longSerializationPolicy = (LongSerializationPolicy)Objects.requireNonNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        void var1_1;
        return this.setFieldNamingStrategy((FieldNamingStrategy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        void var1_1;
        this.fieldNamingPolicy = (FieldNamingStrategy)Objects.requireNonNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setObjectToNumberStrategy(ToNumberStrategy objectToNumberStrategy) {
        void var1_1;
        this.objectToNumberStrategy = (ToNumberStrategy)Objects.requireNonNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setNumberToNumberStrategy(ToNumberStrategy numberToNumberStrategy) {
        void var1_1;
        this.numberToNumberStrategy = (ToNumberStrategy)Objects.requireNonNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setExclusionStrategies(ExclusionStrategy ... strategies) {
        void var1_1;
        Objects.requireNonNull(strategies);
        for (void strategy : var1_1) {
            this.excluder = this.excluder.withExclusionStrategy((ExclusionStrategy)strategy, true, true);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder addSerializationExclusionStrategy(ExclusionStrategy strategy) {
        void var1_1;
        Objects.requireNonNull(strategy);
        this.excluder = this.excluder.withExclusionStrategy((ExclusionStrategy)var1_1, true, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy strategy) {
        void var1_1;
        Objects.requireNonNull(strategy);
        this.excluder = this.excluder.withExclusionStrategy((ExclusionStrategy)var1_1, false, true);
        return this;
    }

    public final GsonBuilder setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public final GsonBuilder setLenient() {
        this.lenient = true;
        return this;
    }

    public final GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setDateFormat(String pattern) {
        void var1_1;
        this.datePattern = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setDateFormat(int style) {
        void var1_1;
        this.dateStyle = var1_1;
        this.datePattern = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        void var2_2;
        void var1_1;
        this.dateStyle = var1_1;
        this.timeStyle = var2_2;
        this.datePattern = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        Objects.requireNonNull(type);
        $Gson$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator || typeAdapter instanceof TypeAdapter);
        if (typeAdapter instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer) {
            TypeToken<?> typeToken = TypeToken.get(type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType(typeToken, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            void var3_3;
            void var2_2;
            void var1_1;
            TypeAdapterFactory factory = TypeAdapters.newFactory(TypeToken.get((Type)var1_1), (TypeAdapter)var2_2);
            this.factories.add((TypeAdapterFactory)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder registerTypeAdapterFactory(TypeAdapterFactory factory) {
        void var1_1;
        Objects.requireNonNull(factory);
        this.factories.add((TypeAdapterFactory)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder registerTypeHierarchyAdapter(Class<?> baseType, Object typeAdapter) {
        Objects.requireNonNull(baseType);
        $Gson$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof TypeAdapter);
        if (typeAdapter instanceof JsonDeserializer || typeAdapter instanceof JsonSerializer) {
            this.hierarchyFactories.add(TreeTypeAdapter.newTypeHierarchyFactory(baseType, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            void var1_1;
            void var2_2;
            TypeAdapterFactory factory = TypeAdapters.newTypeHierarchyFactory(baseType, (TypeAdapter)var2_2);
            this.factories.add((TypeAdapterFactory)var1_1);
        }
        return this;
    }

    public final GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    public final GsonBuilder disableJdkUnsafe() {
        this.useJdkUnsafe = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final GsonBuilder addReflectionAccessFilter(ReflectionAccessFilter filter) {
        void var1_1;
        Objects.requireNonNull(filter);
        this.reflectionFilters.addFirst((ReflectionAccessFilter)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Gson create() {
        void var1_1;
        void var2_2;
        ArrayList<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>(this.factories.size() + this.hierarchyFactories.size() + 3);
        factories.addAll(this.factories);
        Collections.reverse(factories);
        ArrayList<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>(this.hierarchyFactories);
        Collections.reverse(hierarchyFactories);
        factories.addAll((Collection<TypeAdapterFactory>)var2_2);
        GsonBuilder gsonBuilder = this;
        gsonBuilder.addTypeAdaptersForDate(gsonBuilder.datePattern, this.dateStyle, this.timeStyle, factories);
        return new Gson(this.excluder, this.fieldNamingPolicy, new HashMap(this.instanceCreators), this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.prettyPrinting, this.lenient, this.serializeSpecialFloatingPointValues, this.useJdkUnsafe, this.longSerializationPolicy, this.datePattern, this.dateStyle, this.timeStyle, new ArrayList<TypeAdapterFactory>(this.factories), new ArrayList<TypeAdapterFactory>(this.hierarchyFactories), (List<TypeAdapterFactory>)var1_1, this.objectToNumberStrategy, this.numberToNumberStrategy, new ArrayList<ReflectionAccessFilter>(this.reflectionFilters));
    }

    /*
     * WARNING - void declaration
     */
    private void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, List<TypeAdapterFactory> factories) {
        TypeAdapterFactory dateAdapterFactory;
        boolean sqlTypesSupported = SqlTypesSupport.SUPPORTS_SQL_TYPES;
        TypeAdapterFactory sqlTimestampAdapterFactory = null;
        TypeAdapterFactory sqlDateAdapterFactory = null;
        if (datePattern != null && !datePattern.trim().isEmpty()) {
            dateAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(datePattern);
            if (sqlTypesSupported) {
                void var1_1;
                sqlTimestampAdapterFactory = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(datePattern);
                sqlDateAdapterFactory = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory((String)var1_1);
            }
        } else if (dateStyle != 2 && timeStyle != 2) {
            dateAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(dateStyle, timeStyle);
            if (sqlTypesSupported) {
                void var3_3;
                void var2_2;
                sqlTimestampAdapterFactory = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(dateStyle, timeStyle);
                sqlDateAdapterFactory = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory((int)var2_2, (int)var3_3);
            }
        } else {
            return;
        }
        factories.add(dateAdapterFactory);
        if (sqlTypesSupported) {
            factories.add(sqlTimestampAdapterFactory);
            factories.add(sqlDateAdapterFactory);
        }
    }
}

