/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.NumberTypeAdapter;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.SerializationDelegatingTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.sql.SqlTypesSupport;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class Gson {
    public static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    public static final boolean DEFAULT_LENIENT = false;
    public static final boolean DEFAULT_PRETTY_PRINT = false;
    public static final boolean DEFAULT_ESCAPE_HTML = true;
    public static final boolean DEFAULT_SERIALIZE_NULLS = false;
    public static final boolean DEFAULT_COMPLEX_MAP_KEYS = false;
    public static final boolean DEFAULT_SPECIALIZE_FLOAT_VALUES = false;
    public static final boolean DEFAULT_USE_JDK_UNSAFE = true;
    public static final String DEFAULT_DATE_PATTERN = null;
    public static final FieldNamingStrategy DEFAULT_FIELD_NAMING_STRATEGY = FieldNamingPolicy.IDENTITY;
    public static final ToNumberStrategy DEFAULT_OBJECT_TO_NUMBER_STRATEGY = ToNumberPolicy.DOUBLE;
    public static final ToNumberStrategy DEFAULT_NUMBER_TO_NUMBER_STRATEGY = ToNumberPolicy.LAZILY_PARSED_NUMBER;
    public static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    public final ThreadLocal<Map<TypeToken<?>, TypeAdapter<?>>> threadLocalAdapterResults = new ThreadLocal();
    public final ConcurrentMap<TypeToken<?>, TypeAdapter<?>> typeTokenCache = new ConcurrentHashMap();
    public final ConstructorConstructor constructorConstructor;
    public final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    public final List<TypeAdapterFactory> factories;
    public final Excluder excluder;
    public final FieldNamingStrategy fieldNamingStrategy;
    public final Map<Type, InstanceCreator<?>> instanceCreators;
    public final boolean serializeNulls;
    public final boolean complexMapKeySerialization;
    public final boolean generateNonExecutableJson;
    public final boolean htmlSafe;
    public final boolean prettyPrinting;
    public final boolean lenient;
    public final boolean serializeSpecialFloatingPointValues;
    public final boolean useJdkUnsafe;
    public final String datePattern;
    public final int dateStyle;
    public final int timeStyle;
    public final LongSerializationPolicy longSerializationPolicy;
    public final List<TypeAdapterFactory> builderFactories;
    public final List<TypeAdapterFactory> builderHierarchyFactories;
    public final ToNumberStrategy objectToNumberStrategy;
    public final ToNumberStrategy numberToNumberStrategy;
    public final List<ReflectionAccessFilter> reflectionFilters;

    public Gson() {
        this(Excluder.DEFAULT, DEFAULT_FIELD_NAMING_STRATEGY, Collections.emptyMap(), false, false, false, true, false, false, false, true, LongSerializationPolicy.DEFAULT, DEFAULT_DATE_PATTERN, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), DEFAULT_OBJECT_TO_NUMBER_STRATEGY, DEFAULT_NUMBER_TO_NUMBER_STRATEGY, Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> instanceCreators, boolean serializeNulls, boolean complexMapKeySerialization, boolean generateNonExecutableGson, boolean htmlSafe, boolean prettyPrinting, boolean lenient, boolean serializeSpecialFloatingPointValues, boolean useJdkUnsafe, LongSerializationPolicy longSerializationPolicy, String datePattern, int dateStyle, int timeStyle, List<TypeAdapterFactory> builderFactories, List<TypeAdapterFactory> builderHierarchyFactories, List<TypeAdapterFactory> factoriesToBeAdded, ToNumberStrategy objectToNumberStrategy, ToNumberStrategy numberToNumberStrategy, List<ReflectionAccessFilter> reflectionFilters) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.excluder = excluder;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.instanceCreators = instanceCreators;
        this.constructorConstructor = new ConstructorConstructor(instanceCreators, useJdkUnsafe, reflectionFilters);
        this.serializeNulls = serializeNulls;
        this.complexMapKeySerialization = complexMapKeySerialization;
        this.generateNonExecutableJson = generateNonExecutableGson;
        this.htmlSafe = htmlSafe;
        this.prettyPrinting = prettyPrinting;
        this.lenient = lenient;
        this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        this.useJdkUnsafe = useJdkUnsafe;
        this.longSerializationPolicy = longSerializationPolicy;
        this.datePattern = datePattern;
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.builderFactories = builderFactories;
        this.builderHierarchyFactories = builderHierarchyFactories;
        this.objectToNumberStrategy = objectToNumberStrategy;
        this.numberToNumberStrategy = numberToNumberStrategy;
        this.reflectionFilters = reflectionFilters;
        ArrayList<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
        factories.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        factories.add(ObjectTypeAdapter.getFactory(objectToNumberStrategy));
        factories.add(excluder);
        factories.addAll(factoriesToBeAdded);
        factories.add(TypeAdapters.STRING_FACTORY);
        factories.add(TypeAdapters.INTEGER_FACTORY);
        factories.add(TypeAdapters.BOOLEAN_FACTORY);
        factories.add(TypeAdapters.BYTE_FACTORY);
        factories.add(TypeAdapters.SHORT_FACTORY);
        TypeAdapter<Number> longAdapter = Gson.longAdapter(longSerializationPolicy);
        factories.add(TypeAdapters.newFactory(Long.TYPE, Long.class, longAdapter));
        factories.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(serializeSpecialFloatingPointValues)));
        factories.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(serializeSpecialFloatingPointValues)));
        factories.add(NumberTypeAdapter.getFactory(numberToNumberStrategy));
        factories.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        factories.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        factories.add(TypeAdapters.newFactory(AtomicLong.class, Gson.atomicLongAdapter(longAdapter)));
        factories.add(TypeAdapters.newFactory(AtomicLongArray.class, Gson.atomicLongArrayAdapter(longAdapter)));
        factories.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        factories.add(TypeAdapters.CHARACTER_FACTORY);
        factories.add(TypeAdapters.STRING_BUILDER_FACTORY);
        factories.add(TypeAdapters.STRING_BUFFER_FACTORY);
        factories.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        factories.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        factories.add(TypeAdapters.newFactory(LazilyParsedNumber.class, TypeAdapters.LAZILY_PARSED_NUMBER));
        factories.add(TypeAdapters.URL_FACTORY);
        factories.add(TypeAdapters.URI_FACTORY);
        factories.add(TypeAdapters.UUID_FACTORY);
        factories.add(TypeAdapters.CURRENCY_FACTORY);
        factories.add(TypeAdapters.LOCALE_FACTORY);
        factories.add(TypeAdapters.INET_ADDRESS_FACTORY);
        factories.add(TypeAdapters.BIT_SET_FACTORY);
        factories.add(DateTypeAdapter.FACTORY);
        factories.add(TypeAdapters.CALENDAR_FACTORY);
        if (SqlTypesSupport.SUPPORTS_SQL_TYPES) {
            factories.add(SqlTypesSupport.TIME_FACTORY);
            factories.add(SqlTypesSupport.DATE_FACTORY);
            factories.add(SqlTypesSupport.TIMESTAMP_FACTORY);
        }
        factories.add(ArrayTypeAdapter.FACTORY);
        factories.add(TypeAdapters.CLASS_FACTORY);
        factories.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        factories.add(new MapTypeAdapterFactory(this.constructorConstructor, complexMapKeySerialization));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        factories.add(this.jsonAdapterFactory);
        factories.add(TypeAdapters.ENUM_FACTORY);
        factories.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, (FieldNamingStrategy)var2_2, (Excluder)var1_1, this.jsonAdapterFactory, reflectionFilters));
        this.factories = Collections.unmodifiableList(var3_3);
    }

    public GsonBuilder newBuilder() {
        return new GsonBuilder(this);
    }

    @Deprecated
    public Excluder excluder() {
        return this.excluder;
    }

    public FieldNamingStrategy fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public boolean serializeNulls() {
        return this.serializeNulls;
    }

    public boolean htmlSafe() {
        return this.htmlSafe;
    }

    private TypeAdapter<Number> doubleAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(this){
            final /* synthetic */ Gson this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Double read(JsonReader in) throws IOException {
                void var1_1;
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return var1_1.nextDouble();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                void var3_3;
                void var1_1;
                void var2_2;
                if (value == null) {
                    out.nullValue();
                    return;
                }
                double doubleValue = var2_2.doubleValue();
                Gson.checkValidFloatingPoint(doubleValue);
                var1_1.value((double)var3_3);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(this){
            final /* synthetic */ Gson this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Float read(JsonReader in) throws IOException {
                void var1_1;
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Float.valueOf((float)var1_1.nextDouble());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                void var2_2;
                void var1_1;
                void var3_3;
                if (value == null) {
                    out.nullValue();
                    return;
                }
                float floatValue = value.floatValue();
                Gson.checkValidFloatingPoint(floatValue);
                Number floatNumber = value instanceof Float ? (Number)value : (Number)Float.valueOf((float)var3_3);
                var1_1.value((Number)var2_2);
            }
        };
    }

    static void checkValidFloatingPoint(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            double d;
            throw new IllegalArgumentException(d + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Number read(JsonReader in) throws IOException {
                void var1_1;
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return var1_1.nextLong();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                void var2_2;
                void var1_1;
                if (value == null) {
                    out.nullValue();
                    return;
                }
                var1_1.value(var2_2.toString());
            }
        };
    }

    private static TypeAdapter<AtomicLong> atomicLongAdapter(TypeAdapter<Number> longAdapter) {
        TypeAdapter<Number> typeAdapter;
        return new TypeAdapter<AtomicLong>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, AtomicLong value) throws IOException {
                void var2_2;
                void var1_1;
                typeAdapter.write((JsonWriter)var1_1, var2_2.get());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AtomicLong read(JsonReader in) throws IOException {
                void var1_1;
                Number value = (Number)typeAdapter.read(in);
                return new AtomicLong(var1_1.longValue());
            }
        }.nullSafe();
    }

    private static TypeAdapter<AtomicLongArray> atomicLongArrayAdapter(TypeAdapter<Number> longAdapter) {
        TypeAdapter<Number> typeAdapter;
        return new TypeAdapter<AtomicLongArray>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void write(JsonWriter out, AtomicLongArray value) throws IOException {
                void var1_1;
                out.beginArray();
                int length = value.length();
                for (int i = 0; i < length; ++i) {
                    typeAdapter.write(out, value.get(i));
                }
                var1_1.endArray();
            }

            @Override
            public AtomicLongArray read(JsonReader in) throws IOException {
                ArrayList<Long> list = new ArrayList<Long>();
                in.beginArray();
                while (in.hasNext()) {
                    long value = ((Number)typeAdapter.read(in)).longValue();
                    list.add(value);
                }
                in.endArray();
                int length = list.size();
                AtomicLongArray array = new AtomicLongArray(length);
                for (int i = 0; i < length; ++i) {
                    array.set(i, (Long)list.get(i));
                }
                return array;
            }
        }.nullSafe();
    }

    /*
     * WARNING - void declaration
     */
    public <T> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        void var3_4;
        void var4_7;
        Objects.requireNonNull(type, "type must not be null");
        TypeAdapter cached = (TypeAdapter)this.typeTokenCache.get(type);
        if (cached != null) {
            return cached;
        }
        Map<TypeToken<?>, TypeAdapter<?>> threadCalls = this.threadLocalAdapterResults.get();
        boolean isInitialAdapterRequest = false;
        if (threadCalls == null) {
            threadCalls = new HashMap();
            this.threadLocalAdapterResults.set(threadCalls);
            isInitialAdapterRequest = true;
        } else {
            TypeAdapter<?> typeAdapter = threadCalls.get(type);
            if (typeAdapter != null) {
                return typeAdapter;
            }
        }
        Object var4_6 = null;
        try {
            FutureTypeAdapter<T> call = new FutureTypeAdapter<T>();
            threadCalls.put(type, call);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                TypeAdapter<T> typeAdapter = typeAdapterFactory.create(this, type);
                if (typeAdapter == null) continue;
                call.setDelegate(typeAdapter);
                threadCalls.put(type, typeAdapter);
                break;
            }
        }
        finally {
            if (isInitialAdapterRequest) {
                this.threadLocalAdapterResults.remove();
            }
        }
        if (var4_7 == null) {
            void var1_1;
            throw new IllegalArgumentException("GSON (2.10.1) cannot handle " + var1_1);
        }
        if (var3_4 != false) {
            void var2_3;
            this.typeTokenCache.putAll((Map<TypeToken<?>, TypeAdapter<?>>)var2_3);
        }
        return var4_7;
    }

    /*
     * WARNING - void declaration
     */
    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory skipPast, TypeToken<T> type) {
        void var2_2;
        if (!this.factories.contains(skipPast)) {
            skipPast = this.jsonAdapterFactory;
        }
        boolean skipPastFound = false;
        for (TypeAdapterFactory factory : this.factories) {
            if (!skipPastFound) {
                if (factory != skipPast) continue;
                skipPastFound = true;
                continue;
            }
            TypeAdapter<T> candidate = factory.create(this, type);
            if (candidate == null) continue;
            return candidate;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> TypeAdapter<T> getAdapter(Class<T> type) {
        void var1_1;
        return this.getAdapter(TypeToken.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JsonElement toJsonTree(Object src) {
        void var1_1;
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        void v0 = var1_1;
        return this.toJsonTree(v0, v0.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public JsonElement toJsonTree(Object src, Type typeOfSrc) {
        void var3_3;
        void var2_2;
        void var1_1;
        JsonTreeWriter writer = new JsonTreeWriter();
        this.toJson((Object)var1_1, (Type)var2_2, writer);
        return var3_3.get();
    }

    /*
     * WARNING - void declaration
     */
    public String toJson(Object src) {
        void var1_1;
        if (src == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        void v0 = var1_1;
        return this.toJson((Object)v0, v0.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public String toJson(Object src, Type typeOfSrc) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringWriter writer = new StringWriter();
        this.toJson((Object)var1_1, (Type)var2_2, writer);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void toJson(Object src, Appendable writer) throws JsonIOException {
        void var2_2;
        if (src != null) {
            void var1_1;
            void v0 = var1_1;
            this.toJson((Object)v0, v0.getClass(), writer);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, (Appendable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void toJson(Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        try {
            void var2_2;
            void var1_1;
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson((Object)var1_1, (Type)var2_2, jsonWriter);
            return;
        }
        catch (IOException e) {
            void var3_4;
            throw new JsonIOException((Throwable)var3_4);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toJson(Object src, Type typeOfSrc, JsonWriter writer) throws JsonIOException {
        TypeAdapter<?> adapter = this.getAdapter(TypeToken.get(typeOfSrc));
        boolean oldLenient = writer.isLenient();
        writer.setLenient(true);
        boolean oldHtmlSafe = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean oldSerializeNulls = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            void var2_5;
            var2_5.write(writer, src);
            writer.setLenient(oldLenient);
            writer.setHtmlSafe(oldHtmlSafe);
            writer.setSerializeNulls(oldSerializeNulls);
            return;
        }
        catch (IOException e) {
            try {
                throw new JsonIOException(e);
                catch (AssertionError e2) {
                    void var1_3;
                    throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e2)).getMessage(), (Throwable)var1_3);
                }
            }
            catch (Throwable throwable) {
                void var3_6;
                writer.setLenient(oldLenient);
                writer.setHtmlSafe(oldHtmlSafe);
                var3_6.setSerializeNulls(oldSerializeNulls);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toJson(JsonElement jsonElement) {
        void var2_2;
        void var1_1;
        StringWriter writer = new StringWriter();
        this.toJson((JsonElement)var1_1, (Appendable)writer);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void toJson(JsonElement jsonElement, Appendable writer) throws JsonIOException {
        try {
            void var1_1;
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson((JsonElement)var1_1, jsonWriter);
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new JsonIOException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter newJsonWriter(Writer writer) throws IOException {
        void var1_1;
        if (this.generateNonExecutableJson) {
            writer.write(JSON_NON_EXECUTABLE_PREFIX);
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        if (this.prettyPrinting) {
            jsonWriter.setIndent("  ");
        }
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setLenient(this.lenient);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JsonReader newJsonReader(Reader reader) {
        void var1_1;
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(this.lenient);
        return var1_1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toJson(JsonElement jsonElement, JsonWriter writer) throws JsonIOException {
        boolean oldLenient = writer.isLenient();
        writer.setLenient(true);
        boolean oldHtmlSafe = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean oldSerializeNulls = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, writer);
            writer.setLenient(oldLenient);
            writer.setHtmlSafe(oldHtmlSafe);
            writer.setSerializeNulls(oldSerializeNulls);
            return;
        }
        catch (IOException e) {
            try {
                throw new JsonIOException(e);
                catch (AssertionError e2) {
                    void var1_3;
                    throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e2)).getMessage(), (Throwable)var1_3);
                }
            }
            catch (Throwable throwable) {
                void var2_5;
                void var3_6;
                writer.setLenient((boolean)var3_6);
                writer.setHtmlSafe(oldHtmlSafe);
                var2_5.setSerializeNulls(oldSerializeNulls);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        void var1_1;
        void var2_2;
        T object = this.fromJson(json, TypeToken.get(classOfT));
        return Primitives.wrap(var2_2).cast(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        void var2_2;
        void var1_1;
        return (T)this.fromJson((String)var1_1, TypeToken.get((Type)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(String json, TypeToken<T> typeOfT) throws JsonSyntaxException {
        void var2_2;
        void var1_1;
        if (json == null) {
            return null;
        }
        StringReader reader = new StringReader(json);
        return this.fromJson((Reader)var1_1, (TypeToken<T>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        void var1_1;
        void var2_2;
        T object = this.fromJson(json, TypeToken.get(classOfT));
        return Primitives.wrap(var2_2).cast(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        void var2_2;
        void var1_1;
        return (T)this.fromJson((Reader)var1_1, TypeToken.get((Type)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(Reader json, TypeToken<T> typeOfT) throws JsonIOException, JsonSyntaxException {
        void var2_2;
        void var1_1;
        JsonReader jsonReader = this.newJsonReader(json);
        T object = this.fromJson(jsonReader, typeOfT);
        Gson.assertFullConsumption(object, (JsonReader)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void assertFullConsumption(Object obj, JsonReader reader) {
        try {
            void var1_3;
            if (obj != null && var1_3.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("JSON document was not fully consumed.");
            }
            return;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            void var0_2;
            throw new JsonIOException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        void var2_2;
        void var1_1;
        return (T)this.fromJson((JsonReader)var1_1, TypeToken.get((Type)var2_2));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T fromJson(JsonReader reader, TypeToken<T> typeOfT) throws JsonIOException, JsonSyntaxException {
        boolean isEmpty = true;
        boolean oldLenient = reader.isLenient();
        reader.setLenient(true);
        try {
            reader.peek();
            isEmpty = false;
            typeOfT = this.getAdapter((TypeToken<T>)((Object)typeOfT));
            typeOfT = typeOfT.read(reader);
        }
        catch (EOFException e) {
            void var3_8;
            if (var3_8 != false) {
                reader.setLenient(oldLenient);
                return null;
            }
            try {
                throw new JsonSyntaxException(e);
                catch (IllegalStateException e2) {
                    throw new JsonSyntaxException(e2);
                }
                catch (IOException e3) {
                    throw new JsonSyntaxException(e3);
                }
                catch (AssertionError e4) {
                    void var2_6;
                    throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e4)).getMessage(), (Throwable)var2_6);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.setLenient(oldLenient);
                throw throwable;
            }
        }
        reader.setLenient(oldLenient);
        return (T)typeOfT;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        void var1_1;
        void var2_2;
        T object = this.fromJson(json, TypeToken.get(classOfT));
        return Primitives.wrap(var2_2).cast(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        void var2_2;
        void var1_1;
        return (T)this.fromJson((JsonElement)var1_1, TypeToken.get((Type)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fromJson(JsonElement json, TypeToken<T> typeOfT) throws JsonSyntaxException {
        void var2_2;
        void var1_1;
        if (json == null) {
            return null;
        }
        return this.fromJson((JsonReader)new JsonTreeReader((JsonElement)var1_1), (TypeToken<T>)var2_2);
    }

    public String toString() {
        return "{serializeNulls:" + this.serializeNulls + ",factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }

    static class FutureTypeAdapter<T>
    extends SerializationDelegatingTypeAdapter<T> {
        private TypeAdapter<T> delegate = null;

        FutureTypeAdapter() {
        }

        /*
         * WARNING - void declaration
         */
        public void setDelegate(TypeAdapter<T> typeAdapter) {
            void var1_1;
            if (this.delegate != null) {
                throw new AssertionError((Object)"Delegate is already set");
            }
            this.delegate = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private TypeAdapter<T> delegate() {
            void var1_1;
            TypeAdapter<T> delegate = this.delegate;
            if (delegate == null) {
                throw new IllegalStateException("Adapter for type with cyclic dependency has been used before dependency has been resolved");
            }
            return var1_1;
        }

        @Override
        public TypeAdapter<T> getSerializationDelegate() {
            return this.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T read(JsonReader in) throws IOException {
            void var1_1;
            return this.delegate().read((JsonReader)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(JsonWriter out, T value) throws IOException {
            void var2_2;
            void var1_1;
            this.delegate().write((JsonWriter)var1_1, var2_2);
        }
    }
}

