/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public final String translateName(Field f) {
            return f.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public final String translateName(Field f) {
            return 2.upperCaseFirstLetter(f.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public final String translateName(Field f) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(f.getName(), ' '));
        }
    }
    ,
    UPPER_CASE_WITH_UNDERSCORES{

        @Override
        public final String translateName(Field f) {
            return 4.separateCamelCase(f.getName(), '_').toUpperCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public final String translateName(Field f) {
            return 5.separateCamelCase(f.getName(), '_').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public final String translateName(Field f) {
            return 6.separateCamelCase(f.getName(), '-').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public final String translateName(Field f) {
            return 7.separateCamelCase(f.getName(), '.').toLowerCase(Locale.ENGLISH);
        }
    };


    /*
     * WARNING - void declaration
     */
    static String separateCamelCase(String name, char separator) {
        void var2_2;
        StringBuilder translation = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append(separator);
            }
            translation.append(character);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static String upperCaseFirstLetter(String s) {
        String string;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            void var1_1;
            void var3_3;
            char c = s.charAt(i);
            if (!Character.isLetter(c)) continue;
            if (Character.isUpperCase(c)) {
                return s;
            }
            char uppercased = Character.toUpperCase((char)var3_3);
            if (i == 0) {
                return uppercased + s.substring(1);
            }
            return s.substring(0, i) + (char)var1_1 + s.substring(i + 1);
        }
        return string;
    }
}

