/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.sse.internal;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal._ResponseCommonKt;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.internal.ServerSentEventReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u0004\u001a\u00020\u0005H\u0016J\f\u0010!\u001a\u00020\f*\u00020\"H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lokhttp3/sse/internal/RealEventSource;", "Lokhttp3/sse/EventSource;", "Lokhttp3/sse/internal/ServerSentEventReader$Callback;", "Lokhttp3/Callback;", "request", "Lokhttp3/Request;", "listener", "Lokhttp3/sse/EventSourceListener;", "(Lokhttp3/Request;Lokhttp3/sse/EventSourceListener;)V", "call", "Lokhttp3/Call;", "canceled", "", "cancel", "", "connect", "callFactory", "Lokhttp3/Call$Factory;", "onEvent", "id", "", "type", "data", "onFailure", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "onRetryChange", "timeMs", "", "processResponse", "isEventStream", "Lokhttp3/ResponseBody;", "okhttp-sse"})
public final class RealEventSource
implements Callback,
EventSource,
ServerSentEventReader.Callback {
    private final Request request;
    private final EventSourceListener listener;
    private Call call;
    private volatile boolean canceled;

    /*
     * WARNING - void declaration
     */
    public RealEventSource(Request request, EventSourceListener listener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.request = var1_1;
        this.listener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(Call.Factory callFactory) {
        void var2_2;
        Call call;
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Call $this$connect_u24lambda_u240 = call = call.newCall(this.request);
        RealEventSource realEventSource = this;
        var2_2.enqueue((Callback)this);
        realEventSource.call = call;
    }

    /*
     * WARNING - void declaration
     */
    public final void onResponse(Call call, Response response) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.processResponse((Response)var2_2);
    }

    public final void processResponse(Response response) {
        Closeable closeable;
        block15: {
            Throwable throwable;
            ResponseBody body;
            Throwable throwable2;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    closeable = (Closeable)response;
                    throwable2 = null;
                    Response cfr_ignored_0 = (Response)closeable;
                    if (response.isSuccessful()) break block13;
                    this.listener.onFailure(this, null, response);
                    CloseableKt.closeFinally((Closeable)closeable, null);
                    return;
                }
                body = response.body();
                if (this.isEventStream(body)) break block14;
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + body.contentType()), response);
                CloseableKt.closeFinally((Closeable)closeable, null);
                return;
            }
            Call call = this.call;
            if (call != null && (call = call.timeout()) != null) {
                call.cancel();
            }
            response = _ResponseCommonKt.stripBody((Response)response);
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
            try {
                if (!this.canceled) {
                    this.listener.onOpen(this, response);
                    while (!this.canceled && reader.processNextEvent()) {
                    }
                }
            }
            catch (Exception e) {
                Exception exception = this.canceled ? (Exception)new IOException("canceled", e) : e;
                this.listener.onFailure(this, exception, response);
                CloseableKt.closeFinally((Closeable)closeable, null);
                return;
            }
            try {
                if (this.canceled) {
                    this.listener.onFailure(this, new IOException("canceled"), (Response)throwable);
                    break block15;
                }
                this.listener.onClosed(this);
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throwable2 = throwable3;
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    throw throwable4;
                }
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEventStream(ResponseBody $this$isEventStream) {
        void var1_1;
        MediaType mediaType = $this$isEventStream.contentType();
        if (mediaType == null) {
            return false;
        }
        MediaType contentType = mediaType;
        return Intrinsics.areEqual((Object)mediaType.type(), (Object)"text") && Intrinsics.areEqual((Object)var1_1.subtype(), (Object)"event-stream");
    }

    /*
     * WARNING - void declaration
     */
    public final void onFailure(Call call, IOException e) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.listener.onFailure(this, (Throwable)var2_2, null);
    }

    @Override
    public final Request request() {
        return this.request;
    }

    @Override
    public final void cancel() {
        this.canceled = true;
        Call call = this.call;
        if (call != null) {
            call.cancel();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onEvent(String id, String type, String data) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.listener.onEvent(this, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    @Override
    public final void onRetryChange(long timeMs) {
    }
}

