/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.StringUtils;

abstract class RFC1522Codec {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "?=";
    protected static final String PREFIX = "=?";

    RFC1522Codec() {
    }

    /*
     * WARNING - void declaration
     */
    protected String encodeText(String text, Charset charset) throws EncoderException {
        void var3_3;
        void var1_1;
        void var2_2;
        if (text == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(PREFIX);
        buffer.append(charset);
        buffer.append('?');
        buffer.append(this.getEncoding());
        buffer.append('?');
        byte[] rawData = this.doEncoding(text.getBytes((Charset)var2_2));
        buffer.append(StringUtils.newStringUsAscii((byte[])var1_1));
        buffer.append(POSTFIX);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String encodeText(String text, String charsetName) throws EncoderException, UnsupportedEncodingException {
        void var2_2;
        void var1_1;
        if (text == null) {
            return null;
        }
        return this.encodeText((String)var1_1, Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected String decodeText(String text) throws DecoderException, UnsupportedEncodingException {
        void var1_1;
        void var3_6;
        if (text == null) {
            return null;
        }
        if (!text.startsWith(PREFIX) || !text.endsWith(POSTFIX)) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int terminator = text.length() - 2;
        int to = text.indexOf(63, 2);
        if (to == terminator) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String charset = text.substring(2, to);
        if (charset.equals("")) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        int from = to + 1;
        if ((to = text.indexOf(63, from)) == terminator) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String encoding = text.substring(from, to);
        if (!this.getEncoding().equalsIgnoreCase(encoding)) {
            void var2_3;
            throw new DecoderException("This codec cannot decode " + (String)var2_3 + " encoded content");
        }
        from = to + 1;
        to = text.indexOf(63, from);
        byte[] data = StringUtils.getBytesUsAscii(text.substring((int)var3_6, to));
        data = this.doDecoding(data);
        return new String((byte[])var1_1, charset);
    }

    protected abstract String getEncoding();

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;
}

