/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
implements BinaryDecoder,
BinaryEncoder,
StringDecoder,
StringEncoder {
    private final Charset charset;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;

    public QuotedPrintableCodec() {
        this(Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public QuotedPrintableCodec(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QuotedPrintableCodec(String charsetName) throws IllegalCharsetNameException, IllegalArgumentException, UnsupportedCharsetException {
        this(Charset.forName((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final void encodeQuotedPrintable(int b, ByteArrayOutputStream buffer) {
        int n;
        void var1_1;
        void var2_2;
        buffer.write(61);
        char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
        int hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        buffer.write((int)var2_2);
        var1_1.write(n);
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] encodeQuotedPrintable(BitSet printable, byte[] bytes) {
        void var2_2;
        if (bytes == null) {
            return null;
        }
        if (printable == null) {
            printable = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] arr$ = bytes;
        int len$ = bytes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int n;
            int b = n = arr$[i$];
            if (n < 0) {
                b += 256;
            }
            if (printable.get(b)) {
                buffer.write(b);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(b, buffer);
        }
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] decodeQuotedPrintable(byte[] bytes) throws DecoderException {
        void var1_1;
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            void var3_3;
            byte b = bytes[i];
            if (b == 61) {
                try {
                    int u = Utils.digit16(bytes[++i]);
                    int l = Utils.digit16(bytes[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    void var3_4;
                    throw new DecoderException("Invalid quoted-printable encoding", (Throwable)var3_4);
                }
            }
            buffer.write((int)var3_3);
        }
        return var1_1.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encode(byte[] bytes) {
        void var1_1;
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, (byte[])var1_1);
    }

    @Override
    public byte[] decode(byte[] bytes) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(bytes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String str) throws EncoderException {
        void var1_1;
        return this.encode((String)var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    public String decode(String str, Charset charset) throws DecoderException {
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii((String)var1_1)), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String decode(String str, String charset) throws DecoderException, UnsupportedEncodingException {
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii((String)var1_1)), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String decode(String str) throws DecoderException {
        void var1_1;
        return this.decode((String)var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.encode((byte[])obj);
        }
        if (obj instanceof String) {
            return this.encode((String)obj);
        }
        throw new EncoderException("Objects of type " + var1_1.getClass().getName() + " cannot be quoted-printable encoded");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object decode(Object obj) throws DecoderException {
        void var1_1;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.decode((byte[])obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new DecoderException("Objects of type " + var1_1.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String str, Charset charset) {
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(var1_1.getBytes((Charset)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String str, String charset) throws UnsupportedEncodingException {
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(var1_1.getBytes((String)var2_2)));
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

