/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.codec.net.RFC1522Codec;

public class QCodec
extends RFC1522Codec
implements StringDecoder,
StringEncoder {
    private final Charset charset;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte BLANK = 32;
    private static final byte UNDERSCORE = 95;
    private boolean encodeBlanks = false;

    public QCodec() {
        this(Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public QCodec(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QCodec(String charsetName) {
        this(Charset.forName((String)var1_1));
        void var1_1;
    }

    @Override
    protected String getEncoding() {
        return "Q";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] doEncoding(byte[] bytes) {
        void var1_1;
        if (bytes == null) {
            return null;
        }
        byte[] data = QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, bytes);
        if (this.encodeBlanks) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 32) continue;
                data[i] = 95;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] doDecoding(byte[] bytes) throws DecoderException {
        void var1_1;
        void var2_2;
        if (bytes == null) {
            return null;
        }
        boolean hasUnderscores = false;
        byte[] arr$ = bytes;
        int len$ = bytes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte by = arr$[i$];
            if (by != 95) continue;
            hasUnderscores = true;
            break;
        }
        if (var2_2 != false) {
            void var3_3;
            byte[] tmp = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                int b = bytes[i];
                tmp[i] = b != 95 ? b : 32;
            }
            return QuotedPrintableCodec.decodeQuotedPrintable((byte[])var3_3);
        }
        return QuotedPrintableCodec.decodeQuotedPrintable((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String str, Charset charset) throws EncoderException {
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        return this.encodeText((String)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String str, String charset) throws EncoderException {
        if (str == null) {
            return null;
        }
        try {
            void var2_3;
            return this.encodeText(str, (String)var2_3);
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            throw new EncoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String str) throws EncoderException {
        void var1_1;
        if (str == null) {
            return null;
        }
        return this.encode((String)var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String decode(String str) throws DecoderException {
        if (str == null) {
            return null;
        }
        try {
            return this.decodeText(str);
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            throw new DecoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return this.encode((String)obj);
        }
        throw new EncoderException("Objects of type " + var1_1.getClass().getName() + " cannot be encoded using Q codec");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object decode(Object obj) throws DecoderException {
        void var1_1;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new DecoderException("Objects of type " + var1_1.getClass().getName() + " cannot be decoded using Q codec");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    public boolean isEncodeBlanks() {
        return this.encodeBlanks;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncodeBlanks(boolean b) {
        void var1_1;
        this.encodeBlanks = var1_1;
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        PRINTABLE_CHARS.set(32);
        PRINTABLE_CHARS.set(33);
        PRINTABLE_CHARS.set(34);
        PRINTABLE_CHARS.set(35);
        PRINTABLE_CHARS.set(36);
        PRINTABLE_CHARS.set(37);
        PRINTABLE_CHARS.set(38);
        PRINTABLE_CHARS.set(39);
        PRINTABLE_CHARS.set(40);
        PRINTABLE_CHARS.set(41);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(43);
        PRINTABLE_CHARS.set(44);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(47);
        for (i = 48; i <= 57; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(58);
        PRINTABLE_CHARS.set(59);
        PRINTABLE_CHARS.set(60);
        PRINTABLE_CHARS.set(62);
        PRINTABLE_CHARS.set(64);
        for (i = 65; i <= 90; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(91);
        PRINTABLE_CHARS.set(92);
        PRINTABLE_CHARS.set(93);
        PRINTABLE_CHARS.set(94);
        PRINTABLE_CHARS.set(96);
        for (i = 97; i <= 122; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(123);
        PRINTABLE_CHARS.set(124);
        PRINTABLE_CHARS.set(125);
        PRINTABLE_CHARS.set(126);
    }
}

