/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.RFC1522Codec;

public class BCodec
extends RFC1522Codec
implements StringDecoder,
StringEncoder {
    private final Charset charset;

    public BCodec() {
        this(Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public BCodec(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BCodec(String charsetName) {
        this(Charset.forName((String)var1_1));
        void var1_1;
    }

    @Override
    protected String getEncoding() {
        return "B";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] doEncoding(byte[] bytes) {
        void var1_1;
        if (bytes == null) {
            return null;
        }
        return Base64.encodeBase64((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] doDecoding(byte[] bytes) {
        void var1_1;
        if (bytes == null) {
            return null;
        }
        return Base64.decodeBase64((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String value, Charset charset) throws EncoderException {
        void var2_2;
        void var1_1;
        if (value == null) {
            return null;
        }
        return this.encodeText((String)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String value, String charset) throws EncoderException {
        if (value == null) {
            return null;
        }
        try {
            void var2_3;
            return this.encodeText(value, (String)var2_3);
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            throw new EncoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String value) throws EncoderException {
        void var1_1;
        if (value == null) {
            return null;
        }
        return this.encode((String)var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String decode(String value) throws DecoderException {
        if (value == null) {
            return null;
        }
        try {
            return this.decodeText(value);
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            throw new DecoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object value) throws EncoderException {
        void var1_1;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.encode((String)value);
        }
        throw new EncoderException("Objects of type " + var1_1.getClass().getName() + " cannot be encoded using BCodec");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object decode(Object value) throws DecoderException {
        void var1_1;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.decode((String)value);
        }
        throw new DecoderException("Objects of type " + var1_1.getClass().getName() + " cannot be decoded using BCodec");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }
}

