/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.RuleType;

public class Rule {
    public static final RPattern ALL_STRINGS_RMATCHER = new RPattern(){

        @Override
        public final boolean isMatch(CharSequence input) {
            return true;
        }
    };
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final Map<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>> RULES = new EnumMap<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>>(NameType.class);
    private final RPattern lContext;
    private final String pattern;
    private final PhonemeExpr phoneme;
    private final RPattern rContext;

    private static boolean contains(CharSequence chars, char input) {
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != input) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static String createResourceName(NameType nameType, RuleType rt, String lang) {
        void var2_2;
        void var1_1;
        NameType nameType2;
        return String.format("org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType2.getName(), var1_1.getName(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Scanner createScanner(NameType nameType, RuleType rt, String lang) {
        void var1_1;
        void var2_2;
        Object resName = Rule.createResourceName(nameType, rt, (String)var2_2);
        InputStream rulesIS = Languages.class.getClassLoader().getResourceAsStream((String)resName);
        if (rulesIS == null) {
            Object object;
            throw new IllegalArgumentException("Unable to load resource: " + (String)object);
        }
        return new Scanner((InputStream)var1_1, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    private static Scanner createScanner(String lang) {
        void var1_1;
        String resName = String.format("org/apache/commons/codec/language/bm/%s.txt", lang);
        InputStream rulesIS = Languages.class.getClassLoader().getResourceAsStream(resName);
        if (rulesIS == null) {
            String string;
            throw new IllegalArgumentException("Unable to load resource: " + string);
        }
        return new Scanner((InputStream)var1_1, "UTF-8");
    }

    private static boolean endsWith(CharSequence input, CharSequence suffix) {
        if (suffix.length() > input.length()) {
            return false;
        }
        int i = input.length() - 1;
        for (int j = suffix.length() - 1; j >= 0; --j) {
            if (input.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            --i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Rule> getInstance(NameType nameType, RuleType rt, Languages.LanguageSet langs) {
        void var1_1;
        Map<String, List<Rule>> ruleMap = Rule.getInstanceMap(nameType, rt, langs);
        ArrayList allRules = new ArrayList();
        for (List rules : ruleMap.values()) {
            void var2_2;
            allRules.addAll(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Rule> getInstance(NameType nameType, RuleType rt, String lang) {
        void var2_2;
        void var1_1;
        return Rule.getInstance(nameType, (RuleType)var1_1, Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(var2_2))));
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType rt, Languages.LanguageSet langs) {
        void var1_1;
        NameType nameType2;
        if (langs.isSingleton()) {
            void var2_2;
            return Rule.getInstanceMap(nameType, rt, var2_2.getAny());
        }
        return Rule.getInstanceMap(nameType2, (RuleType)var1_1, "any");
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType rt, String lang) {
        void var3_3;
        Map<String, List<Rule>> rules = RULES.get((Object)nameType).get((Object)rt).get(lang);
        if (rules == null) {
            void var2_2;
            void var1_1;
            NameType nameType2;
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, %s.", nameType2.getName(), var1_1.getName(), var2_2));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Phoneme parsePhoneme(String ph) {
        HashSet<String> hashSet;
        int open = ph.indexOf("[");
        if (open >= 0) {
            void var2_2;
            void var1_1;
            if (!ph.endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String before = ph.substring(0, open);
            HashSet<String> in = ph.substring((int)(var1_1 + true), ph.length() - 1);
            HashSet<String> langs = new HashSet<String>(Arrays.asList(((String)((Object)in)).split("[+]")));
            return new Phoneme((CharSequence)var2_2, Languages.LanguageSet.from((Set<String>)hashSet));
        }
        return new Phoneme((CharSequence)((Object)hashSet), Languages.ANY_LANGUAGE);
    }

    /*
     * WARNING - void declaration
     */
    private static PhonemeExpr parsePhonemeExpr(String ph) {
        String string;
        if (ph.startsWith("(")) {
            void var1_1;
            if (!ph.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starts with '(' so must end with ')'");
            }
            ArrayList<Phoneme> phs = new ArrayList<Phoneme>();
            String body = ph.substring(1, ph.length() - 1);
            for (String part : body.split("[|]")) {
                phs.add(Rule.parsePhoneme(part));
            }
            if (body.startsWith("|") || string.endsWith("|")) {
                phs.add(new Phoneme("", Languages.ANY_LANGUAGE));
            }
            return new PhonemeList((List<Phoneme>)var1_1);
        }
        return Rule.parsePhoneme(string);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, List<Rule>> parseRules(Scanner scanner, final String location) {
        void var2_2;
        HashMap<String, List<Rule>> lines = new HashMap<String, List<Rule>>();
        int currentLine = 0;
        boolean inMultilineComment = false;
        while (scanner.hasNextLine()) {
            String incl;
            String rawLine;
            ++currentLine;
            String line = rawLine = scanner.nextLine();
            if (inMultilineComment) {
                if (!line.endsWith("*/")) continue;
                inMultilineComment = false;
                continue;
            }
            if (line.startsWith("/*")) {
                inMultilineComment = true;
                continue;
            }
            int cmtI = line.indexOf("//");
            if (cmtI >= 0) {
                line = line.substring(0, cmtI);
            }
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith(HASH_INCLUDE)) {
                incl = line.substring(8).trim();
                if (incl.contains(" ")) {
                    throw new IllegalArgumentException("Malformed import statement '" + rawLine + "' in " + location);
                }
                lines.putAll(Rule.parseRules(Rule.createScanner(incl), location + "->" + incl));
                continue;
            }
            String[] parts = incl.split("\\s+");
            if (parts.length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + parts.length + " parts: " + rawLine + " in " + location);
            }
            try {
                String pat = Rule.stripQuotes(parts[0]);
                String lCon = Rule.stripQuotes(parts[1]);
                String rCon = Rule.stripQuotes(parts[2]);
                PhonemeExpr ph = Rule.parsePhonemeExpr(Rule.stripQuotes(parts[3]));
                final int cLine = currentLine;
                Rule r = new Rule(pat, lCon, rCon, ph){
                    private final int myLine;
                    private final String loc;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        super((String)var1_1, (String)var2_2, (String)var3_3, x3);
                        this.myLine = cLine;
                        this.loc = location;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString() {
                        void var1_1;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Rule");
                        sb.append("{line=").append(this.myLine);
                        sb.append(", loc='").append(this.loc).append('\'');
                        sb.append('}');
                        return var1_1.toString();
                    }
                };
                String patternKey = r.pattern.substring(0, 1);
                ArrayList<2> rules = (ArrayList<2>)lines.get(patternKey);
                if (rules == null) {
                    rules = new ArrayList<2>();
                    lines.put(patternKey, rules);
                }
                rules.add(r);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Problem parsing line '" + currentLine + "' in " + location, e);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static RPattern pattern(String regex) {
        String string;
        boolean endsWith;
        boolean startsWith = regex.startsWith("^");
        final String content = regex.substring(startsWith ? 1 : 0, (endsWith = regex.endsWith("$")) ? regex.length() - 1 : regex.length());
        boolean bl = content.contains("[");
        if (!bl) {
            if (startsWith && endsWith) {
                if (content.length() == 0) {
                    return new RPattern(){

                        @Override
                        public final boolean isMatch(CharSequence input) {
                            return input.length() == 0;
                        }
                    };
                }
                return new RPattern(){

                    @Override
                    public final boolean isMatch(CharSequence input) {
                        return input.equals(content);
                    }
                };
            }
            if ((startsWith || endsWith) && content.length() == 0) {
                return ALL_STRINGS_RMATCHER;
            }
            if (startsWith) {
                return new RPattern(){

                    @Override
                    public final boolean isMatch(CharSequence input) {
                        return Rule.access$100(input, content);
                    }
                };
            }
            if (endsWith) {
                return new RPattern(){

                    @Override
                    public final boolean isMatch(CharSequence input) {
                        return Rule.access$200(input, content);
                    }
                };
            }
        } else {
            String boxContent;
            boolean startsWithBox = content.startsWith("[");
            boolean endsWithBox = content.endsWith("]");
            if (startsWithBox && endsWithBox && !(boxContent = content.substring(1, content.length() - 1)).contains("[")) {
                void var2_2;
                void var1_1;
                void bContent;
                boolean shouldMatch;
                boolean negate = boxContent.startsWith("^");
                if (negate) {
                    boxContent = boxContent.substring(1);
                }
                boolean bl2 = shouldMatch = !negate;
                if (startsWith && endsWith) {
                    return new RPattern((String)bContent, shouldMatch){
                        final /* synthetic */ String val$bContent;
                        final /* synthetic */ boolean val$shouldMatch;
                        {
                            this.val$bContent = string;
                            this.val$shouldMatch = bl;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public final boolean isMatch(CharSequence input) {
                            void var1_1;
                            return input.length() == 1 && Rule.access$300(this.val$bContent, var1_1.charAt(0)) == this.val$shouldMatch;
                        }
                    };
                }
                if (var1_1 != false) {
                    return new RPattern((String)bContent, shouldMatch){
                        final /* synthetic */ String val$bContent;
                        final /* synthetic */ boolean val$shouldMatch;
                        {
                            this.val$bContent = string;
                            this.val$shouldMatch = bl;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public final boolean isMatch(CharSequence input) {
                            void var1_1;
                            return input.length() > 0 && Rule.access$300(this.val$bContent, var1_1.charAt(0)) == this.val$shouldMatch;
                        }
                    };
                }
                if (var2_2 != false) {
                    void var3_3;
                    return new RPattern((String)var3_3, shouldMatch){
                        final /* synthetic */ String val$bContent;
                        final /* synthetic */ boolean val$shouldMatch;
                        {
                            this.val$bContent = string;
                            this.val$shouldMatch = bl;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public final boolean isMatch(CharSequence input) {
                            if (input.length() > 0) {
                                void var1_1;
                                void v0 = var1_1;
                                if (Rule.access$300(this.val$bContent, v0.charAt(v0.length() - 1)) == this.val$shouldMatch) {
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                }
            }
        }
        return new RPattern(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile(string);
            }

            @Override
            public final boolean isMatch(CharSequence input) {
                Matcher matcher;
                matcher = this.pattern.matcher((CharSequence)((Object)matcher));
                return matcher.find();
            }
        };
    }

    private static boolean startsWith(CharSequence input, CharSequence prefix) {
        if (prefix.length() > input.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String str) {
        String string;
        if (str.startsWith(DOUBLE_QUOTE)) {
            str = str.substring(1);
        }
        if (str.endsWith(DOUBLE_QUOTE)) {
            str = str.substring(0, str.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public Rule(String pattern, String lContext, String rContext, PhonemeExpr phoneme) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.pattern = var1_1;
        this.lContext = Rule.pattern((String)var2_2 + "$");
        this.rContext = Rule.pattern("^" + (String)var3_3);
        this.phoneme = phoneme;
    }

    public RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public RPattern getRContext() {
        return this.rContext;
    }

    /*
     * WARNING - void declaration
     */
    public boolean patternAndContextMatches(CharSequence input, int i) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (i < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int patternLength = this.pattern.length();
        int ipl = i + patternLength;
        if (ipl > input.length()) {
            return false;
        }
        if (!input.subSequence(i, ipl).equals(this.pattern)) {
            return false;
        }
        if (!this.rContext.isMatch(input.subSequence((int)var3_3, input.length()))) {
            return false;
        }
        return this.lContext.isMatch(var1_1.subSequence(0, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(CharSequence x0, CharSequence x1) {
        void var1_1;
        return Rule.startsWith(x0, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$200(CharSequence x0, CharSequence x1) {
        void var1_1;
        return Rule.endsWith(x0, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(CharSequence x0, char x1) {
        void var1_1;
        return Rule.contains(x0, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        for (NameType s : NameType.values()) {
            void var3_4;
            EnumMap rts = new EnumMap(RuleType.class);
            for (RuleType rt : RuleType.values()) {
                HashMap<String, Map<String, List<Rule>>> rs = new HashMap<String, Map<String, List<Rule>>>();
                Languages languages = Languages.getInstance(s);
                for (String l : languages.getLanguages()) {
                    try {
                        rs.put(l, Rule.parseRules(Rule.createScanner(s, rt, l), Rule.createResourceName(s, rt, l)));
                    }
                    catch (IllegalStateException e) {
                        void var0_1;
                        throw new IllegalStateException("Problem processing " + Rule.createResourceName(s, rt, l), (Throwable)var0_1);
                    }
                }
                if (!rt.equals((Object)RuleType.RULES)) {
                    rs.put("common", Rule.parseRules(Rule.createScanner(s, rt, "common"), Rule.createResourceName(s, rt, "common")));
                }
                rts.put(rt, Collections.unmodifiableMap(rs));
            }
            RULES.put((NameType)var3_4, Collections.unmodifiableMap(rts));
        }
    }

    public static interface RPattern {
        public boolean isMatch(CharSequence var1);
    }

    public static final class PhonemeList
    implements PhonemeExpr {
        private final List<Phoneme> phonemes;

        /*
         * WARNING - void declaration
         */
        public PhonemeList(List<Phoneme> phonemes) {
            void var1_1;
            this.phonemes = var1_1;
        }

        public final List<Phoneme> getPhonemes() {
            return this.phonemes;
        }
    }

    public static interface PhonemeExpr {
        public Iterable<Phoneme> getPhonemes();
    }

    public static final class Phoneme
    implements PhonemeExpr {
        public static final Comparator<Phoneme> COMPARATOR = new Comparator<Phoneme>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final int compare(Phoneme o1, Phoneme o2) {
                void var2_2;
                void var1_1;
                for (int i = 0; i < o1.phonemeText.length(); ++i) {
                    if (i >= o2.phonemeText.length()) {
                        return 1;
                    }
                    int c = o1.phonemeText.charAt(i) - o2.phonemeText.charAt(i);
                    if (c == 0) continue;
                    return c;
                }
                if (((Phoneme)var1_1).phonemeText.length() < ((Phoneme)var2_2).phonemeText.length()) {
                    return -1;
                }
                return 0;
            }
        };
        private final StringBuilder phonemeText;
        private final Languages.LanguageSet languages;

        /*
         * WARNING - void declaration
         */
        public Phoneme(CharSequence phonemeText, Languages.LanguageSet languages) {
            void var2_2;
            void var1_1;
            this.phonemeText = new StringBuilder((CharSequence)var1_1);
            this.languages = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Phoneme(Phoneme phonemeLeft, Phoneme phonemeRight) {
            this(phonemeLeft.phonemeText, var1_1.languages);
            void var2_2;
            void var1_1;
            this.phonemeText.append((CharSequence)var2_2.phonemeText);
        }

        /*
         * WARNING - void declaration
         */
        public Phoneme(Phoneme phonemeLeft, Phoneme phonemeRight, Languages.LanguageSet languages) {
            this(var1_1.phonemeText, (Languages.LanguageSet)var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.phonemeText.append((CharSequence)var2_2.phonemeText);
        }

        /*
         * WARNING - void declaration
         */
        public final Phoneme append(CharSequence str) {
            void var1_1;
            this.phonemeText.append((CharSequence)var1_1);
            return this;
        }

        public final Languages.LanguageSet getLanguages() {
            return this.languages;
        }

        @Override
        public final Iterable<Phoneme> getPhonemes() {
            return Collections.singleton(this);
        }

        public final CharSequence getPhonemeText() {
            return this.phonemeText;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public final Phoneme join(Phoneme right) {
            void var1_1;
            return new Phoneme(this.phonemeText.toString() + right.phonemeText.toString(), this.languages.restrictTo(var1_1.languages));
        }
    }
}

