/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.RuleType;

public class PhoneticEngine {
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap<NameType, Set<String>>(NameType.class);
    private static final int DEFAULT_MAX_PHONEMES = 20;
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;
    private final int maxPhonemes;

    /*
     * WARNING - void declaration
     */
    private static String join(Iterable<String> strings, String sep) {
        void var2_2;
        StringBuilder sb = new StringBuilder();
        Iterator<String> si = strings.iterator();
        if (si.hasNext()) {
            sb.append((String)si.next());
        }
        while (si.hasNext()) {
            sb.append(sep).append((String)si.next());
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean concat) {
        this((NameType)var1_1, (RuleType)var2_2, (boolean)var3_3, 20);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean concat, int maxPhonemes) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + (Object)((Object)RuleType.RULES));
        }
        this.nameType = nameType;
        this.ruleType = var2_2;
        this.concat = var3_3;
        this.lang = Lang.instance((NameType)var1_1);
        this.maxPhonemes = maxPhonemes;
    }

    /*
     * WARNING - void declaration
     */
    private PhonemeBuilder applyFinalRules(PhonemeBuilder phonemeBuilder, Map<String, List<Rule>> finalRules) {
        void var3_3;
        if (finalRules == null) {
            throw new NullPointerException("finalRules can not be null");
        }
        if (finalRules.isEmpty()) {
            return phonemeBuilder;
        }
        TreeSet<Rule.Phoneme> phonemes = new TreeSet<Rule.Phoneme>(Rule.Phoneme.COMPARATOR);
        for (Rule.Phoneme phoneme : phonemeBuilder.getPhonemes()) {
            PhonemeBuilder subBuilder = PhonemeBuilder.empty(phoneme.getLanguages());
            String phonemeText = phoneme.getPhonemeText().toString();
            int i = 0;
            while (i < phonemeText.length()) {
                RulesApplication rulesApplication = new RulesApplication(finalRules, phonemeText, subBuilder, i, this.maxPhonemes).invoke();
                boolean found = rulesApplication.isFound();
                subBuilder = rulesApplication.getPhonemeBuilder();
                if (!found) {
                    int n = i;
                    subBuilder.append(phonemeText.subSequence(n, n + 1));
                }
                i = rulesApplication.getI();
            }
            phonemes.addAll(subBuilder.getPhonemes());
        }
        return new PhonemeBuilder((Set)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String input) {
        void var2_2;
        void var1_1;
        Languages.LanguageSet languageSet = this.lang.guessLanguages(input);
        return this.encode((String)var1_1, (Languages.LanguageSet)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String input, Languages.LanguageSet languageSet) {
        void var2_2;
        String string;
        Map<String, List<Rule>> rules = Rule.getInstanceMap(this.nameType, RuleType.RULES, languageSet);
        Map<String, List<Rule>> finalRules1 = Rule.getInstanceMap(this.nameType, this.ruleType, "common");
        Map<String, List<Rule>> finalRules2 = Rule.getInstanceMap(this.nameType, this.ruleType, languageSet);
        input = input.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (input.length() >= 2 && input.substring(0, 2).equals("d'")) {
                String remainder = input.substring(2);
                String combined = "d" + remainder;
                return "(" + this.encode(remainder) + ")-(" + this.encode(combined) + ")";
            }
            for (String l : NAME_PREFIXES.get((Object)this.nameType)) {
                if (!input.startsWith(l + " ")) continue;
                String remainder = input.substring(l.length() + 1);
                String combined = l + remainder;
                return "(" + this.encode(remainder) + ")-(" + this.encode(combined) + ")";
            }
        }
        List<String> words = Arrays.asList(input.split("\\s+"));
        ArrayList<String> words2 = new ArrayList<String>();
        switch (this.nameType) {
            case SEPHARDIC: {
                for (String combined : words) {
                    String[] parts = combined.split("'");
                    String lastPart = parts[parts.length - 1];
                    words2.add(string);
                }
                words2.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case ASHKENAZI: {
                words2.addAll(words);
                words2.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case GENERIC: {
                words2.addAll(words);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + (Object)((Object)this.nameType));
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join(words2, " ");
        } else if (words2.size() == 1) {
            string = words.iterator().next();
        } else {
            StringBuilder result = new StringBuilder();
            for (String word : words2) {
                result.append("-").append(this.encode(word));
            }
            return result.substring(1);
        }
        PhonemeBuilder phonemeBuilder = PhonemeBuilder.empty((Languages.LanguageSet)var2_2);
        int i = 0;
        while (i < string.length()) {
            RulesApplication rulesApplication = new RulesApplication(rules, string, phonemeBuilder, i, this.maxPhonemes).invoke();
            i = rulesApplication.getI();
            phonemeBuilder = rulesApplication.getPhonemeBuilder();
        }
        phonemeBuilder = this.applyFinalRules(phonemeBuilder, finalRules1);
        PhonemeBuilder phonemeBuilder2 = this.applyFinalRules(phonemeBuilder, finalRules2);
        return phonemeBuilder2.makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    public int getMaxPhonemes() {
        return this.maxPhonemes;
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }

    private static final class RulesApplication {
        private final Map<String, List<Rule>> finalRules;
        private final CharSequence input;
        private PhonemeBuilder phonemeBuilder;
        private int i;
        private final int maxPhonemes;
        private boolean found;

        /*
         * WARNING - void declaration
         */
        public RulesApplication(Map<String, List<Rule>> finalRules, CharSequence input, PhonemeBuilder phonemeBuilder, int i, int maxPhonemes) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (finalRules == null) {
                throw new NullPointerException("The finalRules argument must not be null");
            }
            this.finalRules = var1_1;
            this.phonemeBuilder = var3_3;
            this.input = var2_2;
            this.i = i;
            this.maxPhonemes = maxPhonemes;
        }

        public final int getI() {
            return this.i;
        }

        public final PhonemeBuilder getPhonemeBuilder() {
            return this.phonemeBuilder;
        }

        /*
         * WARNING - void declaration
         */
        public final RulesApplication invoke() {
            void var1_1;
            this.found = false;
            int patternLength22 = 1;
            List<Rule> rules = this.finalRules.get(this.input.subSequence(this.i, this.i + 1));
            if (rules != null) {
                for (Rule rule : rules) {
                    void var3_4;
                    String patternLength22 = rule.getPattern();
                    patternLength22 = patternLength22.length();
                    if (!rule.patternAndContextMatches(this.input, this.i)) continue;
                    this.phonemeBuilder.apply(var3_4.getPhoneme(), this.maxPhonemes);
                    this.found = true;
                    break;
                }
            }
            if (!this.found) {
                patternLength22 = 1;
            }
            this.i += var1_1;
            return this;
        }

        public final boolean isFound() {
            return this.found;
        }
    }

    static final class PhonemeBuilder {
        private final Set<Rule.Phoneme> phonemes;

        public static PhonemeBuilder empty(Languages.LanguageSet languages) {
            Languages.LanguageSet languageSet;
            return new PhonemeBuilder(new Rule.Phoneme("", languageSet));
        }

        /*
         * WARNING - void declaration
         */
        private PhonemeBuilder(Rule.Phoneme phoneme) {
            void var1_1;
            this.phonemes = new LinkedHashSet<Rule.Phoneme>();
            this.phonemes.add((Rule.Phoneme)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private PhonemeBuilder(Set<Rule.Phoneme> phonemes) {
            void var1_1;
            this.phonemes = var1_1;
        }

        public final void append(CharSequence str) {
            for (Rule.Phoneme phoneme : this.phonemes) {
                phoneme.append(str);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void apply(Rule.PhonemeExpr phonemeExpr, int maxPhonemes) {
            void var3_3;
            LinkedHashSet<Rule.Phoneme> newPhonemes = new LinkedHashSet<Rule.Phoneme>(maxPhonemes);
            for (Rule.Phoneme left : this.phonemes) {
                for (Rule.Phoneme right : phonemeExpr.getPhonemes()) {
                    Languages.LanguageSet languages = left.getLanguages().restrictTo(right.getLanguages());
                    if (languages.isEmpty()) continue;
                    Rule.Phoneme join = new Rule.Phoneme(left, right, languages);
                    if (newPhonemes.size() >= maxPhonemes) continue;
                    newPhonemes.add(join);
                    if (newPhonemes.size() < maxPhonemes) continue;
                }
            }
            this.phonemes.clear();
            this.phonemes.addAll((Collection<Rule.Phoneme>)var3_3);
        }

        public final Set<Rule.Phoneme> getPhonemes() {
            return this.phonemes;
        }

        /*
         * WARNING - void declaration
         */
        public final String makeString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            for (Rule.Phoneme ph : this.phonemes) {
                void var3_3;
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(var3_3.getPhonemeText());
            }
            return var1_1.toString();
        }
    }
}

