/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.codec.language.bm.NameType;

public class Languages {
    public static final String ANY = "any";
    private static final Map<NameType, Languages> LANGUAGES = new EnumMap<NameType, Languages>(NameType.class);
    private final Set<String> languages;
    public static final LanguageSet NO_LANGUAGES;
    public static final LanguageSet ANY_LANGUAGE;

    public static Languages getInstance(NameType nameType) {
        NameType nameType2;
        return LANGUAGES.get((Object)nameType2);
    }

    /*
     * WARNING - void declaration
     */
    public static Languages getInstance(String languagesResourceName) {
        void var1_1;
        HashSet<void> ls22 = new HashSet<void>();
        InputStream langIS = Languages.class.getClassLoader().getResourceAsStream(languagesResourceName);
        if (langIS == null) {
            throw new IllegalArgumentException("Unable to resolve required resource: " + languagesResourceName);
        }
        Scanner lsScanner = new Scanner(langIS, "UTF-8");
        try {
            boolean inExtendedComment = false;
            while (lsScanner.hasNextLine()) {
                void var3_5;
                String line = lsScanner.nextLine().trim();
                if (inExtendedComment) {
                    if (!line.endsWith("*/")) continue;
                    inExtendedComment = false;
                    continue;
                }
                if (line.startsWith("/*")) {
                    inExtendedComment = true;
                    continue;
                }
                if (line.length() <= 0) continue;
                ls22.add(var3_5);
            }
            lsScanner.close();
        }
        catch (Throwable ls22) {
            Scanner scanner;
            scanner.close();
            throw ls22;
        }
        return new Languages(Collections.unmodifiableSet(var1_1));
    }

    private static String langResourceName(NameType nameType) {
        NameType nameType2;
        return String.format("org/apache/commons/codec/language/bm/%s_languages.txt", nameType2.getName());
    }

    /*
     * WARNING - void declaration
     */
    private Languages(Set<String> languages) {
        void var1_1;
        this.languages = var1_1;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    /*
     * WARNING - void declaration
     */
    static {
        for (NameType s : NameType.values()) {
            void var3_3;
            void v0 = var3_3;
            LANGUAGES.put((NameType)v0, Languages.getInstance(Languages.langResourceName((NameType)v0)));
        }
        NO_LANGUAGES = new LanguageSet(){

            @Override
            public final boolean contains(String language) {
                return false;
            }

            @Override
            public final String getAny() {
                throw new NoSuchElementException("Can't fetch any language from the empty language set.");
            }

            @Override
            public final boolean isEmpty() {
                return true;
            }

            @Override
            public final boolean isSingleton() {
                return false;
            }

            @Override
            public final LanguageSet restrictTo(LanguageSet other) {
                return this;
            }

            public final String toString() {
                return "NO_LANGUAGES";
            }
        };
        ANY_LANGUAGE = new LanguageSet(){

            @Override
            public final boolean contains(String language) {
                return true;
            }

            @Override
            public final String getAny() {
                throw new NoSuchElementException("Can't fetch any language from the any language set.");
            }

            @Override
            public final boolean isEmpty() {
                return false;
            }

            @Override
            public final boolean isSingleton() {
                return false;
            }

            @Override
            public final LanguageSet restrictTo(LanguageSet other) {
                return other;
            }

            public final String toString() {
                return "ANY_LANGUAGE";
            }
        };
    }

    public static final class SomeLanguages
    extends LanguageSet {
        private final Set<String> languages;

        /*
         * WARNING - void declaration
         */
        private SomeLanguages(Set<String> languages) {
            void var1_1;
            this.languages = Collections.unmodifiableSet(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(String language) {
            void var1_1;
            return this.languages.contains(var1_1);
        }

        @Override
        public final String getAny() {
            return this.languages.iterator().next();
        }

        public final Set<String> getLanguages() {
            return this.languages;
        }

        @Override
        public final boolean isEmpty() {
            return this.languages.isEmpty();
        }

        @Override
        public final boolean isSingleton() {
            return this.languages.size() == 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final LanguageSet restrictTo(LanguageSet other) {
            void var2_2;
            if (other == NO_LANGUAGES) {
                return other;
            }
            if (other == ANY_LANGUAGE) {
                return this;
            }
            SomeLanguages sl = (SomeLanguages)other;
            HashSet<String> ls = new HashSet<String>(Math.min(this.languages.size(), sl.languages.size()));
            for (String lang : this.languages) {
                if (!sl.languages.contains(lang)) continue;
                ls.add(lang);
            }
            return SomeLanguages.from((Set<String>)var2_2);
        }

        public final String toString() {
            return "Languages(" + this.languages.toString() + ")";
        }
    }

    public static abstract class LanguageSet {
        public static LanguageSet from(Set<String> langs) {
            Set<String> set;
            if (langs.isEmpty()) {
                return NO_LANGUAGES;
            }
            return new SomeLanguages(set);
        }

        public abstract boolean contains(String var1);

        public abstract String getAny();

        public abstract boolean isEmpty();

        public abstract boolean isSingleton();

        public abstract LanguageSet restrictTo(LanguageSet var1);
    }
}

