/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    private static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    @Deprecated
    private int maxLength = 4;
    private final char[] soundexMapping;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    /*
     * WARNING - void declaration
     */
    public Soundex(char[] mapping) {
        void var1_1;
        this.soundexMapping = new char[mapping.length];
        System.arraycopy(mapping, 0, this.soundexMapping, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public Soundex(String mapping) {
        void var1_1;
        this.soundexMapping = var1_1.toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    public int difference(String s1, String s2) throws EncoderException {
        void var2_2;
        void var1_1;
        return SoundexUtils.difference(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (!(obj instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String str) {
        void var1_1;
        return this.soundex((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private char getMappingCode(String str, int index) {
        void var3_4;
        void var1_2;
        char preHWChar;
        char c;
        char hwChar;
        char mappedChar = this.map(str.charAt(index));
        if (!(index <= 1 || mappedChar == '0' || 'H' != (hwChar = str.charAt(index - 1)) && 'W' != hwChar || (c = this.map(preHWChar = str.charAt((int)(c - 2)))) != mappedChar && 'H' != preHWChar && 87 != var1_2)) {
            return '\u0000';
        }
        return (char)var3_4;
    }

    @Deprecated
    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    /*
     * WARNING - void declaration
     */
    private char map(char ch) {
        void var2_2;
        int index = ch - 65;
        if (index < 0 || index >= this.getSoundexMapping().length) {
            void var1_1;
            throw new IllegalArgumentException("The character is not mapped: " + (char)var1_1);
        }
        return this.getSoundexMapping()[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setMaxLength(int maxLength) {
        void var1_1;
        this.maxLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String soundex(String str) {
        void var2_2;
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = str.charAt(0);
        char last = this.getMappingCode(str, 0);
        while (incount < str.length() && count < out.length) {
            char mapped;
            if ((mapped = this.getMappingCode(str, incount++)) == '\u0000') continue;
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String((char[])var2_2);
    }
}

