/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class RefinedSoundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "01360240043788015936020505";
    private static final char[] US_ENGLISH_MAPPING = "01360240043788015936020505".toCharArray();
    private final char[] soundexMapping;
    public static final RefinedSoundex US_ENGLISH = new RefinedSoundex();

    public RefinedSoundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    /*
     * WARNING - void declaration
     */
    public RefinedSoundex(char[] mapping) {
        void var1_1;
        this.soundexMapping = new char[mapping.length];
        System.arraycopy(mapping, 0, this.soundexMapping, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public RefinedSoundex(String mapping) {
        void var1_1;
        this.soundexMapping = var1_1.toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    public int difference(String s1, String s2) throws EncoderException {
        void var2_2;
        void var1_1;
        return SoundexUtils.difference(this, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (!(obj instanceof String)) {
            throw new EncoderException("Parameter supplied to RefinedSoundex encode is not of type java.lang.String");
        }
        return this.soundex((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String str) {
        void var1_1;
        return this.soundex((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    char getMappingCode(char c) {
        void var1_1;
        if (!Character.isLetter(c)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase((char)var1_1) - 65];
    }

    /*
     * WARNING - void declaration
     */
    public String soundex(String str) {
        void var2_2;
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        StringBuilder sBuf = new StringBuilder();
        sBuf.append(str.charAt(0));
        char last = '*';
        for (int i = 0; i < str.length(); ++i) {
            char current = this.getMappingCode(str.charAt(i));
            if (current == last) continue;
            if (current != '\u0000') {
                sBuf.append(current);
            }
            last = current;
        }
        return var2_2.toString();
    }
}

