/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    /*
     * WARNING - void declaration
     */
    public String doubleMetaphone(String value) {
        void var1_1;
        return this.doubleMetaphone((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String doubleMetaphone(String value, boolean alternate) {
        void var2_2;
        if ((value = this.cleanInput(value)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value);
        int index = this.isSilentStart(value) ? 1 : 0;
        DoubleMetaphone doubleMetaphone = this;
        DoubleMetaphoneResult result = doubleMetaphone.new DoubleMetaphoneResult(doubleMetaphone.getMaxCodeLen());
        block25: while (!result.isComplete() && index <= value.length() - 1) {
            switch (value.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index = this.handleAEIOUY(result, index);
                    continue block25;
                }
                case 'B': {
                    result.append('P');
                    index = this.charAt(value, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result.append('S');
                    ++index;
                    continue block25;
                }
                case 'C': {
                    index = this.handleC(value, result, index);
                    continue block25;
                }
                case 'D': {
                    index = this.handleD(value, result, index);
                    continue block25;
                }
                case 'F': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'G': {
                    index = this.handleG(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index = this.handleH(value, result, index);
                    continue block25;
                }
                case 'J': {
                    index = this.handleJ(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'L': {
                    index = this.handleL(value, result, index);
                    continue block25;
                }
                case 'M': {
                    result.append('M');
                    index = this.conditionM0(value, index) ? index + 2 : index + 1;
                    continue block25;
                }
                case 'N': {
                    result.append('N');
                    index = this.charAt(value, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result.append('N');
                    ++index;
                    continue block25;
                }
                case 'P': {
                    index = this.handleP(value, result, index);
                    continue block25;
                }
                case 'Q': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'R': {
                    index = this.handleR(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index = this.handleS(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index = this.handleT(value, result, index);
                    continue block25;
                }
                case 'V': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'W': {
                    index = this.handleW(value, result, index);
                    continue block25;
                }
                case 'X': {
                    index = this.handleX(value, result, index);
                    continue block25;
                }
                case 'Z': {
                    index = this.handleZ(value, result, index, slavoGermanic);
                    continue block25;
                }
            }
            ++index;
        }
        if (var2_2 != false) {
            return result.getAlternate();
        }
        return result.getPrimary();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (!(obj instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String value) {
        void var1_1;
        return this.doubleMetaphone((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        void var2_2;
        void var1_1;
        return this.isDoubleMetaphoneEqual((String)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.doubleMetaphone((String)var1_1, alternate).equals(this.doubleMetaphone((String)var2_2, (boolean)var3_3));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCodeLen(int maxCodeLen) {
        void var1_1;
        this.maxCodeLen = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int handleAEIOUY(DoubleMetaphoneResult result, int index) {
        void var2_2;
        if (index == 0) {
            void var1_1;
            var1_1.append('A');
        }
        return (int)(var2_2 + true);
    }

    /*
     * WARNING - void declaration
     */
    private int handleC(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (this.conditionC0(value, index)) {
            result.append('K');
            index += 2;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 6, "CAESAR")) {
            result.append('S');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 2, "CH")) {
            index = this.handleCH(value, result, index);
        } else if (DoubleMetaphone.contains(value, index, 2, "CZ") && !DoubleMetaphone.contains(value, index - 2, 4, "WICZ")) {
            result.append('S', 'X');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 3, "CIA")) {
            result.append('X');
            index += 3;
        } else {
            if (DoubleMetaphone.contains(value, index, 2, "CC") && (index != 1 || this.charAt(value, 0) != 'M')) {
                return this.handleCC(value, result, index);
            }
            if (DoubleMetaphone.contains(value, index, 2, "CK", "CG", "CQ")) {
                result.append('K');
                index += 2;
            } else if (DoubleMetaphone.contains(value, index, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(value, index, 3, "CIO", "CIE", "CIA")) {
                    result.append('S', 'X');
                } else {
                    result.append('S');
                }
                index += 2;
            } else {
                void var1_1;
                void var2_2;
                var2_2.append('K');
                index = DoubleMetaphone.contains(value, index + 1, 2, " C", " Q", " G") ? (index += 3) : (DoubleMetaphone.contains(value, index + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains((String)var1_1, index + 1, 2, "CE", "CI") ? (index += 2) : ++index);
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleCC(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (DoubleMetaphone.contains(value, index + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(value, index + 2, 2, "HU")) {
            void var1_1;
            if (index == 1 && this.charAt(value, index - 1) == 'A' || DoubleMetaphone.contains((String)var1_1, index - 1, 5, "UCCEE", "UCCES")) {
                result.append("KS");
            } else {
                result.append('X');
            }
            index += 3;
        } else {
            void var2_2;
            var2_2.append('K');
            index += 2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleCH(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (index > 0 && DoubleMetaphone.contains(value, index, 4, "CHAE")) {
            result.append('K', 'X');
            return index + 2;
        }
        if (this.conditionCH0(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (index > 0) {
            void var1_1;
            if (DoubleMetaphone.contains((String)var1_1, 0, 2, "MC")) {
                result.append('K');
            } else {
                result.append('X', 'K');
            }
        } else {
            void var2_2;
            var2_2.append('X');
        }
        return (int)(var3_3 + 2);
    }

    /*
     * WARNING - void declaration
     */
    private int handleD(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        void var1_1;
        if (DoubleMetaphone.contains(value, index, 2, "DG")) {
            if (DoubleMetaphone.contains(value, index + 2, 1, "I", "E", "Y")) {
                result.append('J');
                index += 3;
            } else {
                result.append("TK");
                index += 2;
            }
        } else if (DoubleMetaphone.contains((String)var1_1, index, 2, "DT", "DD")) {
            result.append('T');
            index += 2;
        } else {
            void var2_2;
            var2_2.append('T');
            ++index;
        }
        return (int)var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private int handleG(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        block19: {
            block20: {
                block18: {
                    if (this.charAt(value, index + 1) != 'H') break block18;
                    index = this.handleGH(value, result, index);
                    break block19;
                }
                if (this.charAt(value, index + 1) != 'N') break block20;
                if (index != 1) ** GOTO lbl-1000
                v0 = this;
                if (v0.isVowel(v0.charAt(value, 0)) && !slavoGermanic) {
                    result.append("KN", "N");
                } else if (!DoubleMetaphone.contains(value, index + 2, 2, new String[]{"EY"}) && this.charAt(value, index + 1) != 'Y' && !slavoGermanic) {
                    result.append("N", "KN");
                } else {
                    result.append("KN");
                }
                index += 2;
                break block19;
            }
            if (DoubleMetaphone.contains(value, index + 1, 2, new String[]{"LI"}) && !slavoGermanic) {
                result.append("KL", "L");
                index += 2;
            } else if (index == 0 && (this.charAt(value, index + 1) == 'Y' || DoubleMetaphone.contains(value, index + 1, 2, DoubleMetaphone.ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
                result.append('K', 'J');
                index += 2;
            } else if (!(!DoubleMetaphone.contains(value, index + 1, 2, new String[]{"ER"}) && this.charAt(value, index + 1) != 'Y' || DoubleMetaphone.contains(value, 0, 6, new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.contains(value, index - 1, 1, new String[]{"E", "I"}) || DoubleMetaphone.contains(value, index - 1, 3, new String[]{"RGY", "OGY"}))) {
                result.append('K', 'J');
                index += 2;
            } else if (DoubleMetaphone.contains(value, index + 1, 1, new String[]{"E", "I", "Y"}) || DoubleMetaphone.contains(value, index - 1, 4, new String[]{"AGGI", "OGGI"})) {
                if (DoubleMetaphone.contains(value, 0, 4, new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"}) || DoubleMetaphone.contains(value, index + 1, 2, new String[]{"ET"})) {
                    result.append('K');
                } else if (DoubleMetaphone.contains(value, index + 1, 3, new String[]{"IER"})) {
                    result.append('J');
                } else {
                    result.append('J', 'K');
                }
                index += 2;
            } else if (this.charAt((String)var1_1, index + 1) == 'G') {
                index += 2;
                result.append('K');
            } else {
                ++index;
                var2_2.append('K');
            }
        }
        return (int)var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private int handleGH(String value, DoubleMetaphoneResult result, int index) {
        block9: {
            if (index <= 0) break block9;
            v0 = this;
            if (v0.isVowel(v0.charAt(value, index - 1))) break block9;
            result.append('K');
            ** GOTO lbl22
        }
        if (index == 0) {
            if (this.charAt(value, index + 2) == 'I') {
                result.append('J');
            } else {
                result.append('K');
            }
            index += 2;
        } else if (index > 1 && DoubleMetaphone.contains(value, index - 2, 1, new String[]{"B", "H", "D"}) != false || index > 2 && DoubleMetaphone.contains(value, index - 3, 1, new String[]{"B", "H", "D"}) != false || index > 3 && DoubleMetaphone.contains(value, index - 4, 1, new String[]{"B", "H"})) {
            index += 2;
        } else {
            if (index > 2 && this.charAt(value, index - 1) == 'U' && DoubleMetaphone.contains(value, index - 3, 1, new String[]{"C", "G", "L", "R", "T"})) {
                result.append('F');
            } else if (index > 0 && this.charAt((String)var1_1, index - 1) != 'I') {
                var2_2.append('K');
            }
lbl22:
            // 5 sources

            index += 2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private int handleH(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        block5: {
            void var1_1;
            block4: {
                if (index == 0) break block4;
                DoubleMetaphone doubleMetaphone = this;
                if (!doubleMetaphone.isVowel(doubleMetaphone.charAt(value, index - 1))) break block5;
            }
            DoubleMetaphone doubleMetaphone = this;
            if (doubleMetaphone.isVowel(doubleMetaphone.charAt((String)var1_1, index + 1))) {
                void var2_2;
                var2_2.append('H');
                index += 2;
                return (int)var3_3;
            }
        }
        ++index;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleJ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        void var3_3;
        if (DoubleMetaphone.contains(value, index, 4, "JOSE") || DoubleMetaphone.contains(value, 0, 4, "SAN ")) {
            if (index == 0 && this.charAt(value, index + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains(value, 0, 4, "SAN ")) {
                result.append('H');
            } else {
                result.append('J', 'H');
            }
            ++index;
        } else {
            void var1_1;
            if (index == 0 && !DoubleMetaphone.contains(value, index, 4, "JOSE")) {
                result.append('J', 'A');
            } else {
                DoubleMetaphone doubleMetaphone = this;
                if (doubleMetaphone.isVowel(doubleMetaphone.charAt(value, index - 1)) && !slavoGermanic && (this.charAt(value, index + 1) == 'A' || this.charAt(value, index + 1) == 'O')) {
                    result.append('J', 'H');
                } else if (index == value.length() - 1) {
                    result.append('J', ' ');
                } else if (!DoubleMetaphone.contains(value, index + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value, index - 1, 1, "S", "K", "L")) {
                    void var2_2;
                    var2_2.append('J');
                }
            }
            index = this.charAt((String)var1_1, index + 1) == 'J' ? (index += 2) : ++index;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleL(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (this.charAt(value, index + 1) == 'L') {
            void var1_1;
            if (this.conditionL0((String)var1_1, index)) {
                result.appendPrimary('L');
            } else {
                result.append('L');
            }
            index += 2;
        } else {
            void var2_2;
            ++index;
            var2_2.append('L');
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleP(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (this.charAt(value, index + 1) == 'H') {
            result.append('F');
            index += 2;
        } else {
            void var1_1;
            void var2_2;
            var2_2.append('P');
            index = DoubleMetaphone.contains((String)var1_1, index + 1, 1, "P", "B") ? index + 2 : index + 1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleR(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        void var3_3;
        void var1_1;
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value, index - 2, 2, "IE") && !DoubleMetaphone.contains(value, index - 4, 2, "ME", "MA")) {
            result.appendAlternate('R');
        } else {
            void var2_2;
            var2_2.append('R');
        }
        if (this.charAt((String)var1_1, index + 1) == 'R') {
            return index + 2;
        }
        return (int)(var3_3 + true);
    }

    /*
     * WARNING - void declaration
     */
    private int handleS(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        void var3_3;
        if (DoubleMetaphone.contains(value, index - 1, 3, "ISL", "YSL")) {
            ++index;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 5, "SUGAR")) {
            result.append('X', 'S');
            ++index;
        } else if (DoubleMetaphone.contains(value, index, 2, "SH")) {
            if (DoubleMetaphone.contains(value, index + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                result.append('S');
            } else {
                result.append('X');
            }
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 3, "SIO", "SIA") || DoubleMetaphone.contains(value, index, 4, "SIAN")) {
            if (slavoGermanic) {
                result.append('S');
            } else {
                result.append('S', 'X');
            }
            index += 3;
        } else if (index == 0 && DoubleMetaphone.contains(value, index + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(value, index + 1, 1, "Z")) {
            result.append('S', 'X');
            index = DoubleMetaphone.contains(value, index + 1, 1, "Z") ? index + 2 : index + 1;
        } else {
            int n;
            if (DoubleMetaphone.contains(value, index, 2, "SC")) {
                n = this.handleSC(value, result, index);
            } else {
                void var1_1;
                if (index == value.length() - 1 && DoubleMetaphone.contains(value, index - 2, 2, "AI", "OI")) {
                    result.appendAlternate('S');
                } else {
                    void var2_2;
                    var2_2.append('S');
                }
                n = DoubleMetaphone.contains((String)var1_1, index + 1, 1, "S", "Z") ? index + 2 : index + 1;
            }
            index = n;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private int handleSC(String value, DoubleMetaphoneResult result, int index) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (this.charAt(value, index + 2) == 'H') {
            if (DoubleMetaphone.contains(value, index + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(value, index + 3, 2, "ER", "EN")) {
                    result.append("X", "SK");
                    return (int)(var3_3 + 3);
                }
                result.append("SK");
                return (int)(var3_3 + 3);
            }
            if (index == 0) {
                DoubleMetaphone doubleMetaphone = this;
                if (!doubleMetaphone.isVowel(doubleMetaphone.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                    result.append('X', 'S');
                    return (int)(var3_3 + 3);
                }
            }
            result.append('X');
            return (int)(var3_3 + 3);
        }
        if (DoubleMetaphone.contains((String)var1_1, index + 2, 1, "I", "E", "Y")) {
            result.append('S');
            return (int)(var3_3 + 3);
        }
        var2_2.append("SK");
        return (int)(var3_3 + 3);
    }

    /*
     * WARNING - void declaration
     */
    private int handleT(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (DoubleMetaphone.contains(value, index, 4, "TION")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 3, "TIA", "TCH")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 2, "TH") || DoubleMetaphone.contains(value, index, 3, "TTH")) {
            if (DoubleMetaphone.contains(value, index + 2, 2, "OM", "AM") || DoubleMetaphone.contains(value, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value, 0, 3, "SCH")) {
                result.append('T');
            } else {
                result.append('0', 'T');
            }
            index += 2;
        } else {
            void var1_1;
            void var2_2;
            var2_2.append('T');
            index = DoubleMetaphone.contains((String)var1_1, index + 1, 1, "T", "D") ? index + 2 : index + 1;
        }
        return (int)var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private int handleW(String value, DoubleMetaphoneResult result, int index) {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                if (!DoubleMetaphone.contains(value, index, 2, new String[]{"WR"})) break block4;
                                result.append('R');
                                index += 2;
                                break block5;
                            }
                            if (index != 0) break block6;
                            v0 = this;
                            if (!v0.isVowel(v0.charAt(value, index + 1)) && !DoubleMetaphone.contains(value, index, 2, new String[]{"WH"})) break block6;
                            v1 = this;
                            if (v1.isVowel(v1.charAt(value, index + 1))) {
                                result.append('A', 'F');
                            } else {
                                result.append('A');
                            }
                            ++index;
                            break block5;
                        }
                        if (index != value.length() - 1) break block7;
                        v2 = this;
                        if (v2.isVowel(v2.charAt(value, index - 1))) break block8;
                    }
                    if (!DoubleMetaphone.contains(value, index - 1, 5, new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) && !DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"})) break block9;
                }
                result.appendAlternate('F');
                ** GOTO lbl-1000
            }
            if (DoubleMetaphone.contains((String)var1_1, index, 4, new String[]{"WICZ", "WITZ"})) {
                var2_2.append("TS", "FX");
                index += 4;
            } else lbl-1000:
            // 2 sources

            {
                ++index;
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleX(String value, DoubleMetaphoneResult result, int index) {
        void var3_3;
        if (index == 0) {
            result.append('S');
            ++index;
        } else {
            void var1_1;
            if (index != value.length() - 1 || !DoubleMetaphone.contains(value, index - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(value, index - 2, 2, "AU", "OU")) {
                void var2_2;
                var2_2.append("KS");
            }
            index = DoubleMetaphone.contains((String)var1_1, index + 1, 1, "C", "X") ? index + 2 : index + 1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int handleZ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        void var3_3;
        if (this.charAt(value, index + 1) == 'H') {
            result.append('J');
            index += 2;
        } else {
            void var1_1;
            if (DoubleMetaphone.contains(value, index + 1, 2, "ZO", "ZI", "ZA") || slavoGermanic && index > 0 && this.charAt(value, index - 1) != 'T') {
                result.append("S", "TS");
            } else {
                void var2_2;
                var2_2.append('S');
            }
            index = this.charAt((String)var1_1, index + 1) == 'Z' ? index + 2 : index + 1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean conditionC0(String value, int index) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (DoubleMetaphone.contains(value, index, 4, "CHIA")) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        DoubleMetaphone doubleMetaphone = this;
        if (doubleMetaphone.isVowel(doubleMetaphone.charAt(value, index - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index - 1, 3, "ACH")) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && var3_3 != 69 || DoubleMetaphone.contains((String)var1_1, (int)(var2_2 - 2), 6, "BACHER", "MACHER");
    }

    /*
     * WARNING - void declaration
     */
    private boolean conditionCH0(String value, int index) {
        void var1_1;
        void var2_2;
        if (index != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(value, (int)(var2_2 + true), 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains((String)var1_1, 0, 5, "CHORE");
    }

    /*
     * WARNING - void declaration
     */
    private boolean conditionCH1(String value, int index) {
        void var1_1;
        void var2_2;
        return DoubleMetaphone.contains(value, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value, 0, 3, "SCH") || DoubleMetaphone.contains(value, index - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(value, index + 2, 1, "T", "S") || (DoubleMetaphone.contains(value, index - 1, 1, "A", "O", "U", "E") || index == 0) && (DoubleMetaphone.contains(value, index + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || var2_2 + true == var1_1.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean conditionL0(String value, int index) {
        block6: {
            void var2_2;
            void var1_1;
            block5: {
                if (index == value.length() - 3 && DoubleMetaphone.contains(value, index - 1, 4, "ILLO", "ILLA", "ALLE")) {
                    return true;
                }
                String string = value;
                if (DoubleMetaphone.contains(string, string.length() - 2, 2, "AS", "OS")) break block5;
                String string2 = value;
                if (!DoubleMetaphone.contains(string2, string2.length() - 1, 1, "A", "O")) break block6;
            }
            if (DoubleMetaphone.contains((String)var1_1, (int)(var2_2 - true), 4, "ALLE")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean conditionM0(String value, int index) {
        void var2_2;
        void var1_1;
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(value, index - 1, 3, "UMB") && (index + 1 == value.length() - 1 || DoubleMetaphone.contains((String)var1_1, (int)(var2_2 + 2), 2, "ER"));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSlavoGermanic(String value) {
        void var1_1;
        return value.indexOf(87) >= 0 || value.indexOf(75) >= 0 || value.indexOf("CZ") >= 0 || var1_1.indexOf("WITZ") >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isVowel(char ch) {
        void var1_1;
        return VOWELS.indexOf((int)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSilentStart(String value) {
        void var2_2;
        boolean result = false;
        String[] arr$ = SILENT_START;
        int len$ = SILENT_START.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String element = arr$[i$];
            if (!value.startsWith(element)) continue;
            result = true;
            break;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String cleanInput(String input) {
        void var1_1;
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return var1_1.toUpperCase(Locale.ENGLISH);
    }

    /*
     * WARNING - void declaration
     */
    protected char charAt(String value, int index) {
        void var2_2;
        void var1_1;
        if (index < 0 || index >= value.length()) {
            return '\u0000';
        }
        return var1_1.charAt((int)var2_2);
    }

    protected static boolean contains(String value, int start, int length, String ... criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            int n = start;
            String target = value.substring(n, n + length);
            String[] arr$ = criteria;
            int len$ = criteria.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String element = arr$[i$];
                if (!target.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public class DoubleMetaphoneResult {
        private final StringBuilder primary;
        private final StringBuilder alternate;
        private final int maxLength;

        /*
         * WARNING - void declaration
         */
        public DoubleMetaphoneResult(int maxLength) {
            void var2_2;
            this.primary = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void append(char value) {
            void var1_1;
            this.appendPrimary(value);
            this.appendAlternate((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void append(char primary, char alternate) {
            void var2_2;
            void var1_1;
            this.appendPrimary((char)var1_1);
            this.appendAlternate((char)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void appendPrimary(char value) {
            if (this.primary.length() < this.maxLength) {
                void var1_1;
                this.primary.append((char)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void appendAlternate(char value) {
            if (this.alternate.length() < this.maxLength) {
                void var1_1;
                this.alternate.append((char)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void append(String value) {
            void var1_1;
            this.appendPrimary(value);
            this.appendAlternate((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void append(String primary, String alternate) {
            void var2_2;
            void var1_1;
            this.appendPrimary((String)var1_1);
            this.appendAlternate((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void appendPrimary(String value) {
            void var2_2;
            void var1_1;
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                this.primary.append(value);
                return;
            }
            this.primary.append(var1_1.substring(0, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public void appendAlternate(String value) {
            void var2_2;
            void var1_1;
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                this.alternate.append(value);
                return;
            }
            this.alternate.append(var1_1.substring(0, (int)var2_2));
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

