/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] SCZ = new char[]{'S', 'C', 'Z'};
    private static final char[] WFPV = new char[]{'W', 'F', 'P', 'V'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHOUKQX = new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'};
    private static final char[] TDX = new char[]{'T', 'D', 'X'};
    private static final char[][] PREPROCESS_MAP = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};

    private static boolean arrayContains(char[] arr, char key) {
        char[] arr$ = arr;
        int len$ = arr.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$];
            if (c != key) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String colognePhonetic(String text) {
        void var2_2;
        if (text == null) {
            return null;
        }
        text = this.preprocess(text);
        CologneOutputBuffer output = new CologneOutputBuffer(text.length() << 1);
        CologneInputBuffer input = new CologneInputBuffer(text.toCharArray());
        char lastChar = '-';
        int lastCode = 47;
        int rightLength = input.length();
        while (rightLength > 0) {
            void var3_6;
            int code;
            char chr = input.removeNext();
            rightLength = input.length();
            int nextChar = rightLength > 0 ? (int)input.getNextChar() : 45;
            if (ColognePhonetic.arrayContains(AEIJOUY, chr)) {
                code = 48;
            } else if (chr == 'H' || chr < 'A' || chr > 'Z') {
                if (lastCode == 47) continue;
                code = 45;
            } else if (chr == 'B' || chr == 'P' && code != 72) {
                code = 49;
            } else if (!(chr != 'D' && chr != 'T' || ColognePhonetic.arrayContains(SCZ, (char)code))) {
                code = 50;
            } else if (ColognePhonetic.arrayContains(WFPV, chr)) {
                code = 51;
            } else if (ColognePhonetic.arrayContains(GKQ, chr)) {
                code = 52;
            } else if (chr == 'X' && !ColognePhonetic.arrayContains(CKQ, lastChar)) {
                code = 52;
                input.addLeft('S');
                ++rightLength;
            } else {
                code = chr == 'S' || chr == 'Z' ? 56 : (chr == 'C' ? (lastCode == 47 ? (ColognePhonetic.arrayContains(AHKLOQRUX, (char)code) ? 52 : 56) : (ColognePhonetic.arrayContains(SZ, lastChar) || !ColognePhonetic.arrayContains(AHOUKQX, (char)code) ? 56 : 52)) : (ColognePhonetic.arrayContains(TDX, chr) ? 56 : (chr == 'R' ? 55 : (chr == 'L' ? 53 : (chr == 'M' || chr == 'N' ? 54 : (int)chr)))));
            }
            if (code != 45 && (lastCode != code && (code != 48 || lastCode == 47) || code < 48 || code > 56)) {
                output.addRight((char)code);
            }
            lastChar = chr;
            lastCode = var3_6;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object object) throws EncoderException {
        void var1_1;
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(String text) {
        void var1_1;
        return this.colognePhonetic((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEncodeEqual(String text1, String text2) {
        void var2_2;
        void var1_1;
        return this.colognePhonetic((String)var1_1).equals(this.colognePhonetic((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private String preprocess(String text) {
        void var1_1;
        text = text.toUpperCase(Locale.GERMAN);
        char[] chrs = text.toCharArray();
        block0: for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] <= 'Z') continue;
            char[][] arr$ = PREPROCESS_MAP;
            int len$ = PREPROCESS_MAP.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char[] element = arr$[i$];
                if (chrs[index] != element[0]) continue;
                chrs[index] = element[1];
                continue block0;
            }
        }
        return new String((char[])var1_1);
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        /*
         * WARNING - void declaration
         */
        public CologneInputBuffer(char[] data) {
            void var2_2;
            super((char[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void addLeft(char ch) {
            void var1_1;
            ++this.length;
            this.data[this.getNextPos()] = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected char[] copyData(int start, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            char[] newData = new char[length];
            System.arraycopy(this.data, this.data.length - this.length + var1_1, newData, 0, (int)var2_2);
            return var3_3;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        /*
         * WARNING - void declaration
         */
        public char removeNext() {
            void var1_1;
            char ch = this.getNextChar();
            --this.length;
            return (char)var1_1;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        /*
         * WARNING - void declaration
         */
        public CologneOutputBuffer(int buffSize) {
            void var2_2;
            super((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void addRight(char chr) {
            void var1_1;
            this.data[this.length] = var1_1;
            ++this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected char[] copyData(int start, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            char[] newData = new char[length];
            System.arraycopy(this.data, (int)var1_1, newData, 0, (int)var2_2);
            return var3_3;
        }
    }

    private abstract class CologneBuffer {
        protected final char[] data;
        protected int length = 0;

        /*
         * WARNING - void declaration
         */
        public CologneBuffer(char[] data) {
            void var2_2;
            this.data = data;
            this.length = ((void)var2_2).length;
        }

        /*
         * WARNING - void declaration
         */
        public CologneBuffer(int buffSize) {
            void var2_2;
            this.data = new char[var2_2];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

