/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.B64;
import org.apache.commons.codec.digest.DigestUtils;

public class Md5Crypt {
    static final String APR1_PREFIX = "$apr1$";
    private static final int BLOCKSIZE = 16;
    static final String MD5_PREFIX = "$1$";
    private static final int ROUNDS = 1000;

    public static String apr1Crypt(byte[] keyBytes) {
        return Md5Crypt.apr1Crypt(keyBytes, APR1_PREFIX + B64.getRandomSalt(8));
    }

    /*
     * WARNING - void declaration
     */
    public static String apr1Crypt(byte[] keyBytes, String salt) {
        void var1_1;
        byte[] byArray;
        if (salt != null && !salt.startsWith(APR1_PREFIX)) {
            salt = APR1_PREFIX + salt;
        }
        return Md5Crypt.md5Crypt(byArray, (String)var1_1, APR1_PREFIX);
    }

    public static String apr1Crypt(String keyBytes) {
        return Md5Crypt.apr1Crypt(keyBytes.getBytes(Charsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    public static String apr1Crypt(String keyBytes, String salt) {
        void var1_1;
        return Md5Crypt.apr1Crypt(keyBytes.getBytes(Charsets.UTF_8), (String)var1_1);
    }

    public static String md5Crypt(byte[] keyBytes) {
        return Md5Crypt.md5Crypt(keyBytes, MD5_PREFIX + B64.getRandomSalt(8));
    }

    /*
     * WARNING - void declaration
     */
    public static String md5Crypt(byte[] keyBytes, String salt) {
        void var1_1;
        return Md5Crypt.md5Crypt(keyBytes, (String)var1_1, MD5_PREFIX);
    }

    /*
     * WARNING - void declaration
     */
    public static String md5Crypt(byte[] keyBytes, String salt, String prefix) {
        void var1_1;
        byte[] byArray;
        int ii;
        String saltString;
        int keyLen = keyBytes.length;
        if (salt == null) {
            saltString = B64.getRandomSalt(8);
        } else {
            Pattern pattern = Pattern.compile("^" + prefix.replace("$", "\\$") + "([\\.\\/a-zA-Z0-9]{1,8}).*");
            Matcher m = pattern.matcher(saltString);
            if (m == null || !m.find()) {
                throw new IllegalArgumentException("Invalid salt value: " + saltString);
            }
            saltString = m.group(1);
        }
        byte[] saltBytes = saltString.getBytes(Charsets.UTF_8);
        MessageDigest ctx = DigestUtils.getMd5Digest();
        ctx.update(keyBytes);
        ctx.update(prefix.getBytes(Charsets.UTF_8));
        ctx.update(saltBytes);
        MessageDigest ctx1 = DigestUtils.getMd5Digest();
        ctx1.update(keyBytes);
        ctx1.update(saltBytes);
        ctx1.update(keyBytes);
        byte[] finalb = ctx1.digest();
        for (ii = keyLen; ii > 0; ii -= 16) {
            ctx.update(finalb, 0, ii > 16 ? 16 : ii);
        }
        Arrays.fill(finalb, (byte)0);
        for (ii = var3_4; ii > 0; ii >>= 1) {
            if ((ii & 1) == 1) {
                ctx.update(finalb[0]);
                continue;
            }
            ctx.update(keyBytes[0]);
        }
        StringBuilder passwd = new StringBuilder(prefix + saltString + "$");
        finalb = ctx.digest();
        for (int i = 0; i < 1000; ++i) {
            ctx1 = DigestUtils.getMd5Digest();
            if ((i & 1) != 0) {
                ctx1.update(keyBytes);
            } else {
                ctx1.update(finalb, 0, 16);
            }
            if (i % 3 != 0) {
                ctx1.update(saltBytes);
            }
            if (i % 7 != 0) {
                ctx1.update(keyBytes);
            }
            if ((i & 1) != 0) {
                ctx1.update(finalb, 0, 16);
            } else {
                ctx1.update(keyBytes);
            }
            finalb = ctx1.digest();
        }
        B64.b64from24bit(finalb[0], finalb[6], finalb[12], 4, passwd);
        B64.b64from24bit(finalb[1], finalb[7], finalb[13], 4, passwd);
        B64.b64from24bit(finalb[2], finalb[8], finalb[14], 4, passwd);
        B64.b64from24bit(finalb[3], finalb[9], finalb[15], 4, passwd);
        B64.b64from24bit(finalb[4], finalb[10], finalb[5], 4, passwd);
        B64.b64from24bit((byte)0, (byte)0, finalb[11], 2, passwd);
        ctx.reset();
        ctx1.reset();
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(saltBytes, (byte)0);
        Arrays.fill(finalb, (byte)0);
        return var1_1.toString();
    }
}

