/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.Charsets;

public class StringUtils {
    /*
     * WARNING - void declaration
     */
    private static byte[] getBytes(String string, Charset charset) {
        void var1_1;
        String string2;
        if (string == null) {
            return null;
        }
        return string2.getBytes((Charset)var1_1);
    }

    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.getBytes(string, Charsets.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            void var1_2;
            throw StringUtils.newIllegalStateException((String)var1_2, (UnsupportedEncodingException)var0_1);
        }
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.getBytes(string, Charsets.US_ASCII);
    }

    public static byte[] getBytesUtf16(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16);
    }

    public static byte[] getBytesUtf16Be(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16BE);
    }

    public static byte[] getBytesUtf16Le(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16LE);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        void var1_1;
        String string;
        return new IllegalStateException(string + ": " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String newString(byte[] bytes, Charset charset) {
        void var1_1;
        byte[] byArray;
        if (bytes == null) {
            return null;
        }
        return new String(byArray, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            void var1_2;
            throw StringUtils.newIllegalStateException((String)var1_2, (UnsupportedEncodingException)var0_1);
        }
    }

    public static String newStringIso8859_1(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static String newStringUsAscii(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, Charsets.US_ASCII);
    }

    public static String newStringUtf16(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, Charsets.UTF_16);
    }

    public static String newStringUtf16Be(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, Charsets.UTF_16BE);
    }

    public static String newStringUtf16Le(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, Charsets.UTF_16LE);
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, Charsets.UTF_8);
    }
}

