/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.nio.charset.Charset;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryDecoder,
BinaryEncoder {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;

    /*
     * WARNING - void declaration
     */
    public static byte[] decodeHex(char[] data) throws DecoderException {
        void var2_2;
        int len = data.length;
        if ((len & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)f;
            ++i;
        }
        return var2_2;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        void var1_1;
        return Hex.encodeHex(data, var1_1 != false ? DIGITS_LOWER : DIGITS_UPPER);
    }

    /*
     * WARNING - void declaration
     */
    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        void var3_3;
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return var3_3;
    }

    public static String encodeHexString(byte[] data) {
        byte[] byArray;
        return new String(Hex.encodeHex(byArray));
    }

    /*
     * WARNING - void declaration
     */
    protected static int toDigit(char ch, int index) throws DecoderException {
        void var2_2;
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            void var1_1;
            char c;
            throw new DecoderException("Illegal hexadecimal character " + c + " at index " + (int)var1_1);
        }
        return (int)var2_2;
    }

    public Hex() {
        this.charset = DEFAULT_CHARSET;
    }

    /*
     * WARNING - void declaration
     */
    public Hex(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Hex(String charsetName) {
        this(Charset.forName((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(byte[] array) throws DecoderException {
        void var1_1;
        return Hex.decodeHex(new String((byte[])var1_1, this.getCharset()).toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object decode(Object object) throws DecoderException {
        try {
            char[] cArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            object = cArray;
            return Hex.decodeHex(cArray);
        }
        catch (ClassCastException e) {
            void var1_2;
            throw new DecoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    @Override
    public byte[] encode(byte[] array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byArray = object instanceof String ? ((String)object).getBytes(this.getCharset()) : (byte[])object;
            object = byArray;
            return Hex.encodeHex(byArray);
        }
        catch (ClassCastException e) {
            void var1_2;
            throw new EncoderException(e.getMessage(), (Throwable)var1_2);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charset + "]";
    }
}

