/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.BaseNCodec;

public class BaseNCodecOutputStream
extends FilterOutputStream {
    private final boolean doEncode;
    private final BaseNCodec baseNCodec;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec.Context context = new BaseNCodec.Context();

    /*
     * WARNING - void declaration
     */
    public BaseNCodecOutputStream(OutputStream out, BaseNCodec basedCodec, boolean doEncode) {
        super((OutputStream)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.baseNCodec = var2_2;
        this.doEncode = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int i) throws IOException {
        void var1_1;
        this.singleByte[0] = (byte)var1_1;
        BaseNCodecOutputStream baseNCodecOutputStream = this;
        baseNCodecOutputStream.write(baseNCodecOutputStream.singleByte, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > b.length || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            if (this.doEncode) {
                this.baseNCodec.encode(b, offset, len, this.context);
            } else {
                void var3_3;
                void var2_2;
                void var1_1;
                this.baseNCodec.decode((byte[])var1_1, (int)var2_2, (int)var3_3, this.context);
            }
            this.flush(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flush(boolean propagate) throws IOException {
        void var1_1;
        byte[] buf;
        int c;
        int avail = this.baseNCodec.available(this.context);
        if (avail > 0 && (c = this.baseNCodec.readResults(buf = new byte[avail], 0, avail, this.context)) > 0) {
            void var2_2;
            void var3_3;
            this.out.write((byte[])var3_3, 0, (int)var2_2);
        }
        if (var1_1 != false) {
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException {
        if (this.doEncode) {
            this.baseNCodec.encode(this.singleByte, 0, -1, this.context);
        } else {
            this.baseNCodec.decode(this.singleByte, 0, -1, this.context);
        }
        this.flush();
        this.out.close();
    }
}

